/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.after;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.after.abs.AbstractAfterSaleService;
import com.dtyunxi.tcbj.app.open.biz.utils.ErpOrderAssert;
import com.dtyunxi.tcbj.app.open.biz.utils.OrderExceptionEnum;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.CreateAfterSalesOrderDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerRelationQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="subTenantAfterSaleServiceImpl")
public class SubTenantAfterSaleServiceImpl
extends AbstractAfterSaleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubTenantAfterSaleServiceImpl.class);
    @Resource
    private ICustomerQueryApi customerQueryApiExt;
    @Resource
    private ICustomerRelationQueryApi customerRelationQueryApi;

    @Override
    protected void verifyReqParams(CreateAfterSalesOrderDto createAfterSalesOrderDto) {
        ErpOrderAssert.isTrue(StringUtils.isNotBlank((String)createAfterSalesOrderDto.getTenantId()), OrderExceptionEnum.CHECK_PARAM_NOT_NULL, "\u4e2dB\u79df\u6237ID");
        ErpOrderAssert.isTrue(StringUtils.isNotBlank((String)createAfterSalesOrderDto.getExtlReturnSrc()), OrderExceptionEnum.CHECK_PARAM_NOT_NULL, "\u5916\u90e8\u4ea4\u6613\u7cfb\u7edf\u7f16\u53f7");
        ErpOrderAssert.isTrue(StringUtils.isNotBlank((String)createAfterSalesOrderDto.getExtlReturnSerial()), OrderExceptionEnum.CHECK_PARAM_NOT_NULL, "\u5916\u90e8\u9000\u8d27\u5355\u53f7");
        for (ItemReqDto afterSalesItem : createAfterSalesOrderDto.getAfterSalesItems()) {
            ErpOrderAssert.isTrue(StringUtils.isNotBlank((String)afterSalesItem.getWarehouseCode()), OrderExceptionEnum.CHECK_PARAM_NOT_NULL, "\u4ed3\u5e93\u7f16\u7801");
        }
    }

    @Override
    protected CustomerRespDto getCustomerRespDto(CreateAfterSalesOrderDto createAfterSalesOrderDto) {
        LOGGER.info("\u3010\u8fdb\u9500\u5b58\u3011\u5ba1\u6838\u9000\u8d27\u51fa\u5e93\u5355\u901a\u8fc7\uff0c\u5f00\u59cb\u521b\u5efa\u552e\u540e\u6d41\u7a0b\uff1a{}", (Object)JSONObject.toJSONString((Object)createAfterSalesOrderDto));
        RestResponse listRestResponse = this.customerQueryApiExt.queryByThirdPartyIds(Arrays.asList(createAfterSalesOrderDto.getTenantId()));
        LOGGER.info("\u3010\u5ba2\u6237\u4e2d\u5fc3\u3011\u6839\u636e\u79df\u6237ID\uff1a{} \u83b7\u53d6\u4e2dB\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(Arrays.asList(createAfterSalesOrderDto.getTenantId())), (Object)JSON.toJSONString((Object)listRestResponse));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        CustomerRespDto middleCustomerRespDto = (CustomerRespDto)customerRespDtos.stream().findFirst().get();
        CustomerRelationRespDto customerRelationRespDto = (CustomerRelationRespDto)RestResponseHelper.extractData((RestResponse)this.customerRelationQueryApi.queryByCustomer(middleCustomerRespDto.getId()));
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApiExt.queryByThirdPartyIds(Arrays.asList(customerRelationRespDto.getThirdCode())));
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoList.stream().findFirst().get();
        LOGGER.info("\u3010\u5ba2\u6237\u4e2d\u5fc3\u3011\u6839\u636e\u79df\u6237ID\uff1a{} \u83b7\u53d6\u4e2dB\u5bf9\u5e94\u5c0fB\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(Arrays.asList(createAfterSalesOrderDto.getTenantId())), (Object)JSON.toJSONString((Object)customerRespDto));
        return customerRespDto;
    }
}

