/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.enums.WarehouseColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.IWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="centerHandleWarehouseServiceImpl")
public class CenterHandleWarehouseServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleWarehouseServiceImpl.class);
    @Resource
    private IWarehouseApi warehouseApi;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private RequestBaseData requestBaseData;

    @Override
    public String getModelType() {
        return ModelCodeEnum.WAREHOUSE.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        List orgDtoList;
        ArrayList<DataDistributeRespDto> respDtoList = new ArrayList<DataDistributeRespDto>();
        DataDistributeRespDto respDto = new DataDistributeRespDto();
        logger.info("\u4ed3\u5e93\u6570\u636e\u5206\u53d1:{}", (Object)modelInfoReqDto.toString());
        List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        String str = this.validaData(maps);
        if (StringUtils.isNotEmpty((String)str)) {
            return new ArrayList<DataDistributeRespDto>();
        }
        ArrayList<String> codes = new ArrayList<String>();
        ArrayList<String> orgCodes = new ArrayList<String>();
        for (Map map : maps) {
            codes.add(map.get(WarehouseColumnEnum.FNUMBER.name()).toString());
            orgCodes.add(map.get(WarehouseColumnEnum.ORGNUM.name()).toString());
        }
        RestResponse warehouseRespDtoRest = this.warehouseQueryApi.queryListByCodes(codes);
        List warehouseRespDtoList = new ArrayList();
        if (warehouseRespDtoRest != null && warehouseRespDtoRest.getData() != null && ((List)warehouseRespDtoRest.getData()).size() > 0) {
            warehouseRespDtoList = (List)warehouseRespDtoRest.getData();
        }
        if ((orgDtoList = (List)this.bizOrganizationQueryApi.getOrganizations(orgCodes).getData()) == null || orgDtoList.size() <= 0) {
            respDto.setType("failure");
            respDto.setReason("\u6ca1\u6709\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f");
            respDtoList.add(respDto);
            return respDtoList;
        }
        Map<String, Long> orgListMap = orgDtoList.stream().collect(Collectors.toMap(OrganizationDto::getCode, OrganizationDto::getId));
        for (Map map : maps) {
            boolean ifAdd = false;
            Long id = null;
            for (WarehouseRespDto dto : warehouseRespDtoList) {
                if (!dto.getCode().equals(map.get(WarehouseColumnEnum.FNUMBER.name()).toString())) continue;
                ifAdd = true;
                id = dto.getId();
                break;
            }
            if (ifAdd) {
                WarehouseUpdateReqDto warehouseUpdateReqDto = new WarehouseUpdateReqDto();
                warehouseUpdateReqDto.setId(id);
                warehouseUpdateReqDto.setStatus(map.get(WarehouseColumnEnum.WAREHOUSE_STATUS.name()).toString());
                warehouseUpdateReqDto.setOrganizationName(map.get(WarehouseColumnEnum.ORGNAME.name()).toString());
                warehouseUpdateReqDto.setOrganizationId(orgListMap.get(map.get(WarehouseColumnEnum.ORGNUM.name()).toString()));
                warehouseUpdateReqDto.setName(map.get(WarehouseColumnEnum.FNAME.name()).toString());
                warehouseUpdateReqDto.setCode(map.get(WarehouseColumnEnum.FNUMBER.name()).toString());
                warehouseUpdateReqDto.setType("0");
                this.warehouseApi.modifyWarehouse(warehouseUpdateReqDto.getId(), warehouseUpdateReqDto);
                continue;
            }
            WarehouseCreateReqDto warehouseCreateReqDto = new WarehouseCreateReqDto();
            warehouseCreateReqDto.setStatus(map.get(WarehouseColumnEnum.WAREHOUSE_STATUS.name()).toString());
            warehouseCreateReqDto.setOrganizationName(map.get(WarehouseColumnEnum.ORGNAME.name()).toString());
            warehouseCreateReqDto.setOrganizationId(orgListMap.get(map.get(WarehouseColumnEnum.ORGNUM.name()).toString()));
            warehouseCreateReqDto.setName(map.get(WarehouseColumnEnum.FNAME.name()).toString());
            warehouseCreateReqDto.setCode(map.get(WarehouseColumnEnum.FNUMBER.name()).toString());
            warehouseCreateReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            warehouseCreateReqDto.setType("0");
            warehouseCreateReqDto.setTenantId(this.requestBaseData.getTenantId());
            this.warehouseApi.addWarehouse(warehouseCreateReqDto);
        }
        respDto.setReason("\u66f4\u65b0\u6210\u529f");
        respDtoList.add(respDto);
        return respDtoList;
    }

    private String validaData(List<Map> dataMap) {
        if (dataMap == null || dataMap.size() <= 0) {
            return "\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (Map map : dataMap) {
            if (map.get(WarehouseColumnEnum.WAREHOUSE_STATUS.name()) == null) {
                return "\u4ed3\u5e93\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a";
            }
            String s = this.getStatus(map);
            if (s == null) {
                return "\u4ed3\u5e93\u72b6\u6001\u6570\u503c'" + map.get(WarehouseColumnEnum.WAREHOUSE_STATUS.name()) + "'\u65e0\u6cd5\u5bf9\u5e94";
            }
            map.put(WarehouseColumnEnum.WAREHOUSE_STATUS.name(), s);
            if (map.get(WarehouseColumnEnum.ORGNUM.name()) == null) {
                return "\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801";
            }
            if (map.get(WarehouseColumnEnum.FNUMBER.name()) == null) {
                return "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (map.get(WarehouseColumnEnum.FNAME.name()) != null) continue;
            return "\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private String getStatus(Map map) {
        Object o = map.get(WarehouseColumnEnum.WAREHOUSE_STATUS.name());
        if (o == null) {
            return null;
        }
        try {
            if (Integer.parseInt(o.toString()) == 0) {
                return "BANNED";
            }
            if (Integer.parseInt(o.toString()) == 1) {
                return "NORMAL";
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            return "\u4ed3\u5e93\u72b6\u6001\u8f6c\u6362\u5f02\u5e38";
        }
    }
}

