/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.app.open.dao.eo.CustomerSalesmanRelationEo;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerSalesmanApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserExtQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="centerSalesmanRelationServiceImpl")
public class CenterSalesmanRelationServiceImpl
implements ICenterHandleService {
    private Logger logger = LoggerFactory.getLogger(CenterSalesmanRelationServiceImpl.class);
    @Autowired
    private IUserExtQueryApi userExtQueryApi;
    @Autowired
    private ICustomerSalesmanApi customerSalesmanApi;
    @Value(value="${customer.salesman.relation.pageSize:10000}")
    private Integer pageSize;
    @Autowired
    private IBizOrganizationQueryApi organizationQueryApi;

    private void handleRelation(List<CustomerSalesmanRelationEo> relationList) {
        this.logger.debug("\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5ba2\u6237\u5173\u7cfb\u540c\u6b65\u4e1a\u52a1\uff0c\u8425\u9500\u4e91\u540c\u6b65\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(relationList));
        HashMap xbCustomerCodeMap = Maps.newHashMap();
        HashMap rUserOrgMap = Maps.newHashMap();
        for (CustomerSalesmanRelationEo customerSalesmanRelationEo : relationList) {
            if (xbCustomerCodeMap.containsKey(customerSalesmanRelationEo.getLogin())) {
                ((List)xbCustomerCodeMap.get(customerSalesmanRelationEo.getLogin())).add(customerSalesmanRelationEo.getDealerId());
            } else {
                ArrayList list = Lists.newArrayList((Object[])new String[]{customerSalesmanRelationEo.getDealerId()});
                xbCustomerCodeMap.put(customerSalesmanRelationEo.getLogin(), list);
            }
            rUserOrgMap.put(customerSalesmanRelationEo.getLogin(), customerSalesmanRelationEo.getOrgId());
        }
        List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.getOrganizations(new ArrayList(rUserOrgMap.values())));
        this.logger.debug("\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5ba2\u6237\u5173\u7cfb\u540c\u6b65\u4e1a\u52a1\uff0c\u7ec4\u7ec7\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)organizationDtos));
        Map<String, OrganizationDto> orgMap = organizationDtos.stream().collect(Collectors.toMap(e -> e.getCode(), e -> e, (e1, e2) -> e1));
        UserQueryReqDto userQueryReqDto = new UserQueryReqDto();
        userQueryReqDto.setUserNames(new ArrayList(xbCustomerCodeMap.keySet()));
        ArrayList list = Lists.newArrayList();
        List userRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.userExtQueryApi.queryUserByUserNames(userQueryReqDto));
        this.logger.debug("\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5ba2\u6237\u5173\u7cfb\u540c\u6b65\u4e1a\u52a1\uff0c\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)userRespDtos));
        for (UserRespDto userRespDto : userRespDtos) {
            String orgCode;
            CustomerSalesmanReqDto reqDto = new CustomerSalesmanReqDto();
            if (xbCustomerCodeMap.containsKey(userRespDto.getUserName())) {
                List customerCodes = (List)xbCustomerCodeMap.get(userRespDto.getUserName());
                reqDto.setCustomerCodes(customerCodes);
            }
            if (rUserOrgMap.containsKey(userRespDto.getUserName()) && orgMap.containsKey(orgCode = (String)rUserOrgMap.get(userRespDto.getUserName()))) {
                OrganizationDto organizationDto = orgMap.get(orgCode);
                reqDto.setOrgInfoId(organizationDto.getId());
            }
            reqDto.setCode(userRespDto.getUserName());
            reqDto.setName(userRespDto.getUserName());
            reqDto.setUserId(userRespDto.getId());
            reqDto.setStatus(userRespDto.getStatus());
            reqDto.setTenantId(userRespDto.getTenantId());
            reqDto.setInstanceId(userRespDto.getInstanceId());
            reqDto.setSex(StringUtils.isNumeric((CharSequence)userRespDto.getSex()) ? Integer.valueOf(userRespDto.getSex()) : null);
            list.add(reqDto);
        }
        RestResponseHelper.extractData((RestResponse)this.customerSalesmanApi.batchAddSalesmanRelation((List)list));
    }

    @Override
    public String getModelType() {
        return ModelCodeEnum.SALES_MAN_RELATION.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        this.logger.info("\u67e5\u51fa\u6765\u7684\u4e1a\u52a1\u5458\u548c\u5c0fb\u7684\u89c6\u56fe\u4e3a:{}", (Object)modelInfoReqDto.getDataStr());
        List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        ArrayList customerSalesmanRelationEos = Lists.newArrayList();
        for (Map map : maps) {
            CustomerSalesmanRelationEo customerSalesmanRelationEo = new CustomerSalesmanRelationEo();
            customerSalesmanRelationEo.setLogin(map.get("LOGIN").toString());
            customerSalesmanRelationEo.setOrgId(map.get("ORG_ID").toString());
            customerSalesmanRelationEo.setDealerId(map.get("DEALERID").toString());
            customerSalesmanRelationEos.add(customerSalesmanRelationEo);
        }
        if (CollectionUtils.isEmpty((Collection)customerSalesmanRelationEos)) {
            this.logger.info("\u67e5\u8be2\u89c6\u56fe\u8fd4\u56de\u7684\u4e1a\u52a1\u5458\u548c\u5c0fb\u7684\u5173\u7cfb\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        this.handleRelation(customerSalesmanRelationEos);
        return null;
    }
}

