/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.app.open.biz.service.IMapService;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.Geocode;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.MapRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.MapTextRespDto;
import com.dtyunxi.util.HttpUtil;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MapServiceImpl
implements IMapService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapServiceImpl.class);
    @Value(value="${autoNavi.map.geocode.url}")
    private String autoNaviMapUrl;
    @Value(value="${autoNavi.map.text.url}")
    private String autoNaviMapTextUrl;
    @Value(value="${autoNavi.map.access.token}")
    private String autoNaviKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapRespDto parserStoreAddress(String address) {
        MapRespDto mapRespDto = null;
        try {
            StringBuffer param = new StringBuffer();
            param.append("key=").append(this.autoNaviKey);
            param.append("&").append("address=").append(address);
            String body = HttpUtil.sendGet((String)this.autoNaviMapUrl, (String)param.toString());
            LOGGER.info("req\u3010\u9ad8\u5fb7\u3011\u83b7\u53d6\u5730\u5740\u6570\u636e response :{}", (Object)body);
            mapRespDto = (MapRespDto)JSON.parseObject((String)body, MapRespDto.class);
            if (CollectionUtils.isNotEmpty((Collection)mapRespDto.getGeocodes())) {
                Geocode geocode = (Geocode)mapRespDto.getGeocodes().stream().findFirst().get();
                String location = geocode.getLocation();
                geocode.setLog(location.substring(0, location.indexOf(",")));
                geocode.setLat(location.substring(location.indexOf(",") + 1, location.length()));
                mapRespDto.setGeocodes(Arrays.asList(geocode));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u9ad8\u5fb7\u5730\u56fe\u3011\u9006\u5730\u5740\u89e3\u6790\u7ecf\u7eac\u5ea6\u5f02\u5e38");
            e.printStackTrace();
        }
        finally {
            return mapRespDto;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapTextRespDto parserText(String text) {
        MapTextRespDto mapRespDto = null;
        try {
            StringBuffer param = new StringBuffer();
            param.append("key=").append(this.autoNaviKey);
            param.append("&").append("keywords=").append(text);
            String body = HttpUtil.sendGet((String)this.autoNaviMapTextUrl, (String)param.toString());
            LOGGER.info("req\u3010\u9ad8\u5fb7\u3011\u5173\u952e\u5b57\u67e5\u8be2 response :{}", (Object)body);
            mapRespDto = (MapTextRespDto)JSON.parseObject((String)body, MapTextRespDto.class);
            return mapRespDto;
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u9ad8\u5fb7\u5730\u56fe\u3011\u5173\u952e\u5b57\u67e5\u8be2");
            e.printStackTrace();
        }
        finally {
            return mapRespDto;
        }
    }

    public static void main(String[] args) {
        MapTextRespDto mapTextRespDto = (MapTextRespDto)JSON.parseObject((String)"{\"suggestion\":{\"keywords\":[],\"cities\":[]},\"count\":\"3\",\"infocode\":\"10000\",\"pois\":[{\"parent\":\"B0FFHISCW5\",\"address\":\"\u5cb3\u57ce\u8def18\u53f7\",\"distance\":[],\"pname\":\"\u6e56\u5357\u7701\",\"importance\":[],\"biz_ext\":{\"cost\":[],\"rating\":\"4.4\"},\"biz_type\":[],\"cityname\":\"\u5cb3\u9633\u5e02\",\"type\":\"\u751f\u6d3b\u670d\u52a1;\u751f\u6d3b\u670d\u52a1\u573a\u6240;\u751f\u6d3b\u670d\u52a1\u573a\u6240\",\"photos\":[{\"title\":[],\"url\":\"http://store.is.autonavi.com/showpic/af9fddd39fe9e4b0ae6869cec38dd251\"}],\"typecode\":\"070000\",\"shopinfo\":\"0\",\"poiweight\":[],\"childtype\":\"320\",\"adname\":\"\u5cb3\u9633\u697c\u533a\",\"name\":\"\u5cb3\u9633\u6d1e\u6295\u60a6\u6e56\u6e7e\u8425\u9500\u4e2d\u5fc3\",\"location\":\"113.114688,29.384719\",\"tel\":\"0730-8708999\",\"shopid\":[],\"id\":\"B0HD55H1J0\"},{\"parent\":[],\"address\":\"\u5cb3\u57ce\u8def\u4e0e\u6e56\u4e1c\u8def\u4ea4\u53c9\u53e3\u4e1c\u5357120\u7c73\",\"distance\":[],\"pname\":\"\u6e56\u5357\u7701\",\"importance\":[],\"biz_ext\":{\"cost\":[],\"rating\":[]},\"biz_type\":[],\"cityname\":\"\u5cb3\u9633\u5e02\",\"type\":\"\u5546\u52a1\u4f4f\u5b85;\u4f4f\u5b85\u533a;\u4f4f\u5b85\u5c0f\u533a\",\"photos\":[{\"title\":[],\"url\":\"http://store.is.autonavi.com/showpic/302f306cbfc75175ba2a4557d2383369\"},{\"title\":[],\"url\":\"http://store.is.autonavi.com/showpic/d29a8f805e9e5bf8e43a7a25871dab28\"}],\"typecode\":\"120302\",\"shopinfo\":\"0\",\"poiweight\":[],\"childtype\":[],\"adname\":\"\u5cb3\u9633\u697c\u533a\",\"name\":\"\u60a6\u6e56\u6e7e\",\"location\":\"113.115027,29.383867\",\"tel\":[],\"shopid\":[],\"id\":\"B0HKCB1Y3Z\"},{\"parent\":[],\"address\":\"\u5cb3\u9633\u697c\u533a\",\"distance\":[],\"pname\":\"\u6e56\u5357\u7701\",\"importance\":[],\"biz_ext\":{\"cost\":[],\"rating\":[]},\"biz_type\":[],\"cityname\":\"\u5cb3\u9633\u5e02\",\"type\":\"\u5730\u540d\u5730\u5740\u4fe1\u606f;\u4ea4\u901a\u5730\u540d;\u9053\u8def\u540d\",\"photos\":[],\"typecode\":\"190301\",\"shopinfo\":\"2\",\"poiweight\":[],\"childtype\":[],\"adname\":\"\u5cb3\u9633\u697c\u533a\",\"name\":\"\u67ab\u6865\u6e56\u8def\",\"location\":\"113.116494,29.379755\",\"tel\":[],\"shopid\":[],\"id\":\"B0FFH3Q7RX\"}],\"status\":\"1\",\"info\":\"OK\"}", MapTextRespDto.class);
        System.out.println(mapTextRespDto);
    }
}

