/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl.db;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.app.open.biz.service.ISellerSkuPriceService;
import com.dtyunxi.tcbj.app.open.dao.das.DataDistributeDas;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.tcbj.center.openapi.api.exception.DBItemEnum;
import com.dtyunxi.tcbj.center.openapi.api.exception.ItemEnum;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.ICargoApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IBrandApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemSkuApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IPropApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropNameCreateReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropNameReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IPropQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.query.IItemExtQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="centerHandleMaterialDBServiceImpl")
public class CenterHandleMaterialDBServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleMaterialDBServiceImpl.class);
    @Resource
    private IItemApi iItemApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemSkuApi iItemSkuApi;
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource
    private IBrandApi brandApi;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private ICargoApi cargoApi;
    @Resource
    private ICargoQueryApi cargoQueryApi;
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Resource
    private IPropApi propApi;
    @Resource
    private IPropQueryApi propQueryApi;
    @Autowired
    private DataDistributeDas dataDistributeDas;
    @Autowired
    private IUnitQueryApi unitQueryApi;
    @Resource
    private IItemExtQueryApi itemExtQueryApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.MP_CX_AWK_PRODUCT.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u7269\u6599\u6570\u636e\u5206\u53d1:{}", (Object)JSONObject.toJSONString((Object)modelInfoReqDto));
        logger.info("handle\u7269\u6599\u6570\u636e\u5206\u53d1\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)modelInfoReqDto));
        ArrayList<DataDistributeRespDto> responseList = new ArrayList<DataDistributeRespDto>();
        List list = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        DataDistributeRespDto dataDistributeRespDto = null;
        ArrayList itemCodes = Lists.newArrayList();
        for (Map map : list) {
            String code = (String)map.get(DBItemEnum.ZNUMBER.getCode());
            itemCodes.add(code);
        }
        HashMap<String, ItemRespDto> itemMap = new HashMap();
        if (CollectionUtil.isEmpty((Collection)itemCodes)) {
            logger.info("\u7269\u6599\u540c\u6b65\u6ca1\u6709\u5546\u54c1\u7f16\u7801");
            return new ArrayList<DataDistributeRespDto>();
        }
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtQueryApi.queryByCodes((List)itemCodes));
        if (CollectionUtil.isNotEmpty((Collection)itemRespDtos)) {
            itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        String type = DataDistributeRespEnum.SUCCESS.getCode();
        String reason = DataDistributeRespEnum.SUCCESS.getValue();
        MDC.put((String)"yes.req.userCode", (String)"csp-sync");
        ServiceContext.getContext().set("yes.req.userCode", (Object)"csp-sync");
        for (Map map : list) {
            dataDistributeRespDto = new DataDistributeRespDto();
            try {
                logger.info("\u5904\u7406map\uff1a{}", (Object)JSON.toJSONString((Object)map));
                dataDistributeRespDto.setTask_id((String)map.get(ModelCodeEnum.CIDP_TASK_UUID.name()));
                logger.info("================\u300b \u65b0\u589e\u5546\u54c1");
                Long itemId = this.createItem(map, itemMap);
                dataDistributeRespDto.setItemId(itemId);
                logger.info("================\u300b \u65b0\u589e\u5546\u54c1sku, itemId\uff1a{}", (Object)itemId);
                this.createItemSku(map, itemId);
            }
            catch (Exception e) {
                logger.info(e.getMessage(), (Throwable)e);
                type = DataDistributeRespEnum.FAILURE.getCode();
                reason = e.getMessage();
            }
        }
        dataDistributeRespDto.setType(type);
        dataDistributeRespDto.setReason(reason);
        responseList.add(dataDistributeRespDto);
        return responseList;
    }

    private Long createItem(Map<String, String> map, Map<String, ItemRespDto> itemMap) {
        logger.info("\u5927BcreateItem");
        ItemChangeApplyDto changApply = new ItemChangeApplyDto();
        Long id = null;
        String code = map.get(DBItemEnum.ZNUMBER.getCode());
        ItemRespDto itemRespDto = itemMap.get(code);
        logger.info("\u6821\u9a8c\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)itemRespDto));
        if (Objects.nonNull(itemRespDto) && Objects.nonNull(itemRespDto.getId())) {
            logger.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5df2\u5b58\u5728\uff01");
            return itemRespDto.getId();
        }
        changApply.setBrandId(this.createBrand(map));
        String longCode = map.get(DBItemEnum.FNUMBER.getCode());
        logger.info("\u622a\u524d\u53d6\u4e32\uff1a{} \uff0c  \u622a\u53d6\u540e\u5b57\u7b26\u4e32\uff1a{}", (Object)longCode, (Object)longCode.substring(longCode.lastIndexOf(".") + 1));
        String status = map.get(DBItemEnum.MATERIAL_STATUS.getCode());
        if (Objects.equals(status, "Active")) {
            changApply.setStatus(Integer.valueOf(1));
        } else if (Objects.equals(status, "Inactive")) {
            changApply.setStatus(Integer.valueOf(2));
        }
        changApply.setItemCode(map.get(DBItemEnum.ZNUMBER.getCode()));
        changApply.setItemName(map.get(DBItemEnum.FNAME.getCode()));
        logger.info("=================> \u65b0\u589e\u5546\u54c1\u540d\u79f0 : {}", (Object)changApply.getItemName());
        changApply.setDisplayName(changApply.getItemName());
        changApply.setBrand(map.get(DBItemEnum.CFPINPAINAME.getCode()));
        changApply.setDirId(Long.valueOf(1288630386802423099L));
        changApply.setDirName("\u9ed8\u8ba4\u7c7b\u76ee");
        changApply.setLongCode(longCode);
        String orgCode = map.get(DBItemEnum.ORGID.getCode());
        if (StringUtils.isNotEmpty((CharSequence)orgCode)) {
            List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.bizOrganizationQueryApi.getOrganizations((List)Lists.newArrayList((Object[])new String[]{orgCode})));
            Optional.ofNullable(organizationDtos).filter(CollUtil::isNotEmpty).ifPresent(r -> {
                OrganizationDto organizationDto = (OrganizationDto)organizationDtos.get(0);
                changApply.setOrganizationId(organizationDto.getId());
            });
        }
        changApply.setType(Integer.valueOf(1));
        changApply.setSubType(this.getItemType(map.get(DBItemEnum.ORDERPRODTYPE.getCode())));
        String prop = map.get(DBItemEnum.PRODSPEC.getCode());
        JSONObject parsed = JSONObject.parseObject((String)"{\"backDirList\":[1288630386802423099],\"propList\":[{\"extFields\":{},\"id\":1291137844393797633,\"name\":\"\u9ed8\u8ba4\",\"propValueList\":[\"100\u4e2a/\u7bb1\"]}]}\n");
        parsed.put("propValueList", (Object)Lists.newArrayList((Object[])new String[]{prop}));
        changApply.setAttrs(parsed.toJSONString());
        changApply.setSellerId(Long.valueOf(0L));
        changApply.setCreatePerson("\u7cfb\u7edf\u7528\u6237");
        changApply.setTenantId(this.requestBaseData.getTenantId());
        changApply.setInstanceId(this.requestBaseData.getInstanceId());
        changApply.setDosageForm(map.get(DBItemEnum.USETYPE.getCode()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("PRODNUM", (Object)map.get(DBItemEnum.PRODNUM.getCode()));
        jsonObject.put("PRODLINE", (Object)map.get(DBItemEnum.PRODLINE.getCode()));
        changApply.setExtension(JSONObject.toJSONString((Object)jsonObject));
        logger.info("=================> \u65b0\u589e\u5546\u54c1\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)changApply));
        id = (Long)this.iItemApi.addItem(changApply).getData();
        return id;
    }

    private void createItemSku(Map<String, String> map, Long itemId) {
        ItemBundleReqDto itemBundleReqDto = new ItemBundleReqDto();
        List skuRespDtos = (List)this.iItemSkuQueryApi.queryBySkuCode((List)Lists.newArrayList((Object[])new String[]{map.get(DBItemEnum.FNUMBER.getCode())})).getData();
        logger.info("\u67e5\u8be2\u5546\u54c1sku\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)skuRespDtos));
        if (CollectionUtil.isNotEmpty((Collection)skuRespDtos)) {
            logger.info("\u5546\u54c1sku\u5df2\u5b58\u5728\uff01");
        } else {
            itemBundleReqDto.setItemId(itemId);
            List itemSkuList = (List)this.iItemSkuQueryApi.queryByItemId(itemId).getData();
            if (CollectionUtil.isNotEmpty((Collection)itemSkuList)) {
                logger.info("\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5546\u54c1sku\u5df2\u5b58\u5728\uff01");
                return;
            }
            itemBundleReqDto.setBarCode(StringUtils.isEmpty((CharSequence)map.get(DBItemEnum.BARCODE.getCode())) ? null : map.get(DBItemEnum.BARCODE.getCode()));
            try {
                String data = map.get(DBItemEnum.FNUMBER_MINUNIT.getCode());
                if (Objects.nonNull(data)) {
                    if (data instanceof String) {
                        itemBundleReqDto.setMinPackage(Integer.valueOf(data));
                    } else if (data instanceof Integer) {
                        itemBundleReqDto.setMinPackage((Integer)((Object)data));
                    }
                }
            }
            catch (Exception e) {
                logger.info("=================> \u65b0\u589e\u5546\u54c1sku\u5165\u53c2\u6700\u5c0f\u5305\u88c5\u5f02\u5e38 : {}", (Object)JSONObject.toJSONString((Object)itemBundleReqDto));
            }
            String modelValue = "/";
            String prodspec = map.get(DBItemEnum.PRODSPEC.getCode());
            if (StringUtils.isNotBlank((CharSequence)prodspec)) {
                modelValue = prodspec.replaceAll("[\\s\\t\\n\\r]", "").trim();
            }
            itemBundleReqDto.setAttr("{\"\u9ed8\u8ba4\":\"" + modelValue + "\"}");
            String unitName = map.get(DBItemEnum.UNIT_NAME.getCode());
            if (StrUtil.isNotBlank((CharSequence)unitName)) {
                Optional.ofNullable(this.createItemUnit(unitName)).ifPresent(r -> itemBundleReqDto.setUnit(r.toString()));
            }
            itemBundleReqDto.setCargoCode(map.get(DBItemEnum.FNUMBER.getCode()));
            itemBundleReqDto.setCode(map.get(DBItemEnum.FNUMBER.getCode()));
            itemBundleReqDto.setCreatePerson("\u7cfb\u7edf\u7528\u6237");
            itemBundleReqDto.setTenantId(this.requestBaseData.getTenantId());
            itemBundleReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("=================> \u65b0\u589e\u5546\u54c1sku\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)itemBundleReqDto));
            ArrayList prices = Lists.newArrayList();
            ItemPriceReqDto itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u5212\u7ebf\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            String price = null;
            try {
                String priceObj = map.get(DBItemEnum.PRICE.getCode());
                if (priceObj instanceof String) {
                    price = StringUtils.isEmpty((CharSequence)map.get(DBItemEnum.PRICE.getCode())) ? "99999.90" : map.get(DBItemEnum.PRICE.getCode());
                } else if (priceObj instanceof Integer) {
                    price = Objects.nonNull(priceObj) ? priceObj + "" : "99999.90";
                } else if (priceObj instanceof Double) {
                    price = Objects.nonNull(priceObj) ? priceObj + "" : "99999.90";
                }
                itemPriceReqDto.setPrice(new BigDecimal(price));
            }
            catch (Exception e) {
                price = "99999.90";
                itemPriceReqDto.setPrice(new BigDecimal(price));
                logger.info("=================> \u65b0\u589e\u5546\u54c1sku\u5165\u53c2\u91d1\u989d\u5f02\u5e38 : {}", (Object)JSONObject.toJSONString((Object)itemBundleReqDto));
            }
            itemPriceReqDto.setPriceType("PRICE");
            prices.add(itemPriceReqDto);
            itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u552e\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            itemPriceReqDto.setPriceType("RETAIL_PRICE");
            prices.add(itemPriceReqDto);
            itemBundleReqDto.setPrices((List)prices);
            this.iItemSkuApi.addItemSku((List)Lists.newArrayList((Object[])new ItemBundleReqDto[]{itemBundleReqDto}));
            logger.info("================\u300b \u65b0\u589e\u5e93\u5b58\u8d27\u54c1\u5165\u53c2");
            this.createCarg(map);
        }
    }

    public void createCarg(Map<String, String> map) {
        CargoCreateReqDto cargoCreateReqDto = new CargoCreateReqDto();
        CargoRespDto respDto = (CargoRespDto)this.cargoQueryApi.queryByCode(map.get(DBItemEnum.FNUMBER.getCode()), "").getData();
        logger.info("\u67e5\u8be2\u5546\u54c1\u8d27\u54c1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)respDto));
        if (ObjectUtils.isNotEmpty((Object)respDto)) {
            logger.info("\u5546\u54c1\u8d27\u54c1\u5df2\u5b58\u5728\uff01");
        } else {
            cargoCreateReqDto.setCode(map.get(DBItemEnum.FNUMBER.getCode()));
            cargoCreateReqDto.setArtNo(map.get(DBItemEnum.FNUMBER.getCode()));
            cargoCreateReqDto.setName(map.get(DBItemEnum.FNAME.getCode()));
            cargoCreateReqDto.setBrandName(map.get(DBItemEnum.CFPINPAINAME.getCode()));
            cargoCreateReqDto.setTenantId(this.requestBaseData.getTenantId());
            cargoCreateReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("=================> \u65b0\u589e\u5546\u54c1\u8d27\u54c1\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)cargoCreateReqDto));
            this.cargoApi.addCargo(cargoCreateReqDto).getData();
        }
    }

    private Long createBrand(Map<String, String> map) {
        Long id = null;
        String filter = "{\"name\":\"" + map.get(DBItemEnum.CFPINPAINAME.getCode()) + "\"}";
        PageInfo dtoPageInfo = (PageInfo)this.brandQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(10)).getData();
        logger.info("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)dtoPageInfo.getList()));
        if (CollectionUtil.isEmpty((Collection)dtoPageInfo.getList())) {
            TagReqDto.BrandReqDto brandReqDto = new TagReqDto.BrandReqDto();
            brandReqDto.setCode(map.get(DBItemEnum.CFPINPAIDNUM.getCode()));
            brandReqDto.setName(map.get(DBItemEnum.CFPINPAINAME.getCode()));
            brandReqDto.setStatus(Integer.valueOf(1));
            brandReqDto.setCreatePerson("\u7cfb\u7edf\u7528\u6237");
            brandReqDto.setTenantId(this.requestBaseData.getTenantId());
            brandReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("=================> \u65b0\u589e\u54c1\u724c\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)brandReqDto));
            id = (Long)this.brandApi.addBrand(brandReqDto).getData();
            logger.info("=================> \u65b0\u589e\u54c1\u724cid : {}", (Object)id);
        } else {
            logger.info("=================> \u54c1\u724c\u5df2\u5b58\u5728 : {}", (Object)((BrandRespDto)dtoPageInfo.getList().get(0)).getId());
            id = ((BrandRespDto)dtoPageInfo.getList().get(0)).getId();
        }
        return id;
    }

    private Long createItemUnit(String unitName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", unitName);
        List list = ((PageInfo)this.unitQueryApi.queryByPage(JSONObject.toJSONString(map), Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
        return CollectionUtil.isNotEmpty((Collection)list) ? ((UnitRespDto)list.get(0)).getId() : 0L;
    }

    private void createItemPrice(String longCode) {
        this.sellerSkuPriceService.addNewSellerSkuPrice(longCode);
    }

    private Integer getItemType(String type) {
        if (type.equalsIgnoreCase("PRODUCT")) {
            return 1;
        }
        if (type.equalsIgnoreCase("MATERIAL")) {
            return 3;
        }
        if (type.equalsIgnoreCase("GIFT")) {
            return 2;
        }
        return 1;
    }

    private boolean isEmpty(Object obj) {
        if (obj.toString().equals("{\"extFields\":{}}")) {
            return true;
        }
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isEmpty((CharSequence)((CharSequence)obj));
        }
        if (obj instanceof Map) {
            return MapUtil.isEmpty((Map)((Map)obj));
        }
        if (obj instanceof Iterable) {
            return IterUtil.isEmpty((Iterable)((Iterable)obj));
        }
        if (obj instanceof Iterator) {
            return IterUtil.isEmpty((Iterator)((Iterator)obj));
        }
        return ArrayUtil.isArray((Object)obj) ? ArrayUtil.isEmpty((Object)obj) : false;
    }

    private String assembleAttr(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"backDirList\":[1288630386802423099],\"propList\":[{\"extFields\":{},\"id\":");
        PropNameReqDto propNameReqDto = new PropNameReqDto();
        propNameReqDto.setName("\u9ed8\u8ba4");
        List list = ((PageInfo)this.propQueryApi.queryPropNameByPage(propNameReqDto, Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
        logger.info("\u67e5\u8be2\u5230\u5c5e\u6027\u540d\uff1a{}", (Object)JSONObject.toJSONString((Object)list));
        List collect = list.stream().filter(t -> t.getName().equals("\u9ed8\u8ba4")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(collect)) {
            PropNameCreateReqDto propNameCreateReqDto = new PropNameCreateReqDto();
            propNameCreateReqDto.setCode(DateUtil.getCurrentTimeNum());
            propNameCreateReqDto.setName("\u9ed8\u8ba4");
            propNameCreateReqDto.setInputType(Integer.valueOf(1));
            propNameCreateReqDto.setRequired(Integer.valueOf(1));
            propNameCreateReqDto.setTenantId(this.requestBaseData.getTenantId());
            propNameCreateReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            propNameCreateReqDto.setPropValueList((List)Lists.newArrayList((Object[])new String[]{map.get(ItemEnum.FMODEL.getCode())}));
            logger.info("\u65b0\u589e\u5c5e\u6027\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)propNameCreateReqDto));
            Long aLong = (Long)this.propApi.addProp(propNameCreateReqDto).getData();
            logger.info("\u83b7\u53d6\u5230\u5c5e\u6027id\uff1a{}", (Object)aLong);
            stringBuilder.append(aLong.toString() + ",");
        } else {
            CubeBeanUtils.copyProperties((Object)propNameReqDto, collect.get(0), (String[])new String[0]);
            stringBuilder.append(propNameReqDto.getId().toString() + ",");
            logger.info("copy\u540e\u53c2\u6570 \uff1a{}", (Object)JSONObject.toJSONString((Object)propNameReqDto));
            if (!propNameReqDto.getPropValueList().contains(map.get(ItemEnum.FMODEL.getCode()))) {
                propNameReqDto.getPropValueList().add(map.get(ItemEnum.FMODEL.getCode()));
                logger.info("=================> \u5546\u54c1\u89c4\u683c\u4e0d\u5b58\u5728\u65b0\u589e\u89c4\u683c\u4fe1\u606f\uff01 {}", (Object)propNameReqDto.getPropValueList());
                this.propApi.modifyProp(propNameReqDto);
            }
        }
        String name = "\"name\":\"\u9ed8\u8ba4\",";
        String propValueList = "\"propValueList\":[\"" + map.get(ItemEnum.FMODEL.getCode()) + "\"]}]}";
        stringBuilder.append(name);
        stringBuilder.append(propValueList);
        logger.info("\u7ec4\u88c5\u5c5e\u6027\uff1a{}", (Object)JSONObject.toJSONString((Object)stringBuilder.toString()));
        return stringBuilder.toString().replace("\\", "").replace("\\\\", "");
    }

    @DS(value="slave_1")
    private void jointBrand(Map<String, String> map) {
        List mapList = this.dataDistributeDas.selectBrand(map.get(DBItemEnum.FNUMBER.getCode()));
        if (CollectionUtil.isNotEmpty((Collection)mapList)) {
            Map itemMap = (Map)mapList.get(0);
            logger.info("==========================\u300b \u5546\u54c1\u957f\u7f16\u7801{}\uff0c\u4f20\u5165\u54c1\u724c\u540d\u79f0{}\uff0c\u67e5\u8be2\u5230\u54c1\u724c\u540d\u79f0{}", new Object[]{map.get("FNUMBER"), map.get("CFPINPAINAME"), itemMap.get("PROD_BRAND_NAME")});
            map.put("CFPINPAINAME", (String)itemMap.get("PROD_BRAND_NAME"));
            map.put("D_SOURCESYSTEM", (String)itemMap.get("D_SOURCESYSTEM"));
        }
    }
}

