/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.app.open.biz.dto.response.WeixinTicketRespDto;
import com.dtyunxi.tcbj.app.open.biz.dto.response.WeixinTokenRespDto;
import com.dtyunxi.tcbj.app.open.biz.enums.WeixinRespCodeEnum;
import com.dtyunxi.tcbj.app.open.biz.service.IWeixinAccessService;
import com.dtyunxi.tcbj.app.open.biz.utils.HttpUtil;
import com.dtyunxi.tcbj.app.open.biz.utils.RandomUtils;
import com.dtyunxi.tcbj.app.open.biz.utils.SHAUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.weixin.JsApiSignatureDto;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.WeiXinApi;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WeixinAccessServiceImpl
implements IWeixinAccessService {
    private static final Logger logger = LoggerFactory.getLogger(WeixinAccessServiceImpl.class);
    private static int expireParam = 500;
    @Value(value="${tcbj.wx.token.config.appSecret:}")
    private String APPSECRET;
    @Resource
    private HttpUtil httpUtil;
    @Resource
    private ICacheService cacheService;
    private String cachePrefix = "WEIXIN:";

    @Override
    public JsApiSignatureDto jsApiSinature(String url, String appId) {
        JsApiSignatureDto respDto = new JsApiSignatureDto();
        logger.info("\u83b7\u53d6\u5fae\u4fe1jsApi \u7b7e\u540d,url:{},appId:{}", (Object)url, (Object)appId);
        String returnToken = this.getWeixinAppidToken(appId);
        String jsapiTicket = this.getWeixinJsApiTicket(appId, returnToken);
        long timestamp = System.currentTimeMillis() / 1000L;
        String randomStr = RandomUtils.getRandomStr();
        String signature = SHAUtil.genWithAmple("jsapi_ticket=" + jsapiTicket, "noncestr=" + randomStr, "timestamp=" + timestamp, "url=" + url);
        respDto.setAppId(appId);
        respDto.setTimestamp(Long.valueOf(timestamp));
        respDto.setNonceStr(randomStr);
        respDto.setUrl(url);
        respDto.setSignature(signature);
        return respDto;
    }

    @Override
    public String getWeixinAppidToken(String appId) {
        String key = this.cachePrefix + "TOKEN:" + appId;
        String returnToken = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isBlank((CharSequence)returnToken)) {
            String tokenUrl = WeiXinApi.getTokenUrl((String)appId, (String)this.APPSECRET);
            HashMap<String, Object> mapParam = new HashMap<String, Object>();
            WeixinTokenRespDto httpResponseDto = this.httpUtil.httpGet(tokenUrl, mapParam, WeixinTokenRespDto.class);
            logger.info("\u8c03\u7528\u5fae\u4fe1TokenUrl\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a:{}", (Object)JacksonUtil.toJson((Object)httpResponseDto));
            Assert.isTrue((httpResponseDto != null ? 1 : 0) != 0, (String)"1001001", (String)"\u8c03\u7528\u5fae\u4fe1TokenUrl API\u63a5\u53e3\u62a5\u9519\uff0c\u65e0\u54cd\u5e94");
            Assert.isTrue((boolean)StringUtils.isEmpty((CharSequence)httpResponseDto.getErrcode()), (String)httpResponseDto.getErrcode(), (String)httpResponseDto.getErrmsg());
            returnToken = httpResponseDto.getAccess_token();
            this.cacheService.setCache(key, (Object)returnToken, httpResponseDto.getExpires_in() - expireParam);
        }
        return returnToken;
    }

    @Override
    public String getWeixinJsApiTicket(String appId, String reqToken) {
        String key;
        String returnTicket;
        if (StringUtils.isBlank((CharSequence)reqToken)) {
            reqToken = this.getWeixinAppidToken(appId);
        }
        if (StringUtils.isBlank((CharSequence)(returnTicket = (String)this.cacheService.getCache(key = this.cachePrefix + "APPID:" + appId + ":TICKET:" + reqToken, String.class)))) {
            String ticketUrl = WeiXinApi.getJsApiTicketUrl((String)reqToken);
            HashMap<String, Object> mapParam = new HashMap<String, Object>();
            WeixinTicketRespDto httpResponseDto = this.httpUtil.httpGet(ticketUrl, mapParam, WeixinTicketRespDto.class);
            logger.info("\u8c03\u7528\u5fae\u4fe1JSApi\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a:{}", (Object)JacksonUtil.toJson((Object)httpResponseDto));
            Assert.isTrue((httpResponseDto != null ? 1 : 0) != 0, (String)"1001001", (String)"\u8c03\u7528\u5fae\u4fe1API\u63a5\u53e3\u62a5\u9519\uff0c\u65e0\u54cd\u5e94");
            Assert.isTrue((boolean)WeixinRespCodeEnum.OK.getCode().equals(httpResponseDto.getErrcode()), (String)httpResponseDto.getErrcode(), (String)httpResponseDto.getErrmsg());
            returnTicket = httpResponseDto.getTicket();
            this.cacheService.setCache(key, (Object)returnTicket, httpResponseDto.getExpires_in() - expireParam);
        }
        return returnTicket;
    }
}

