/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqServiceImpl;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.tcbj.app.open.biz.config.MqEnumConfig;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor.RabbitRedirectProcessor;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor.ThirdRedirectProcessor;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.rabbit.DispatchMessageListener;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.rabbit.IRabbitHelper;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.MqDispatchRegistryVo;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.BeansException;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

@Component
public class MqDispatchRegistryRunner
implements CommandLineRunner,
ImportBeanDefinitionRegistrar,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(MqDispatchRegistryRunner.class);
    @Resource
    private IRabbitHelper rabbitHelper;
    @Resource
    private AmqpTemplate amqpTemplate;
    @Resource
    private MqEnumConfig mqEnumConfig;
    @Resource
    private Environment environment;
    @Resource
    private SimpleMessageListenerContainer dispatchMessageContainer;
    private final Map<String, ICommonsMqService> mqServiceHashMap = new HashMap<String, ICommonsMqService>(4);

    public void run(String ... args) {
        this.logger.info("\u5f00\u59cbmq\u8c03\u5ea6\u52a0\u8f7d!");
        List<MqDispatchRegistryVo> mqDispatchRegistryVos = this.mqEnumConfig.getMapList();
        if (CollectionUtils.isEmpty(mqDispatchRegistryVos)) {
            return;
        }
        Map<String, List<MqDispatchRegistryVo>> mqTypeMap = mqDispatchRegistryVos.stream().collect(Collectors.groupingBy(MqDispatchRegistryVo::getMqType));
        String target = "rabbit";
        ((RabbitTemplate)this.amqpTemplate).setConfirmCallback((correlationData, ack, cause) -> this.logger.info("rabbitMq\u8f6c\u53d1\u6210\u529f:\u552f\u4e00\u6807\u8bc6:{}, \u786e\u8ba4\u72b6\u6001:{}, \u9020\u6210\u539f\u56e0:{} ", new Object[]{correlationData, ack, cause == null ? "" : cause}));
        mqTypeMap.forEach((type, vos) -> {
            if (target.equals(type)) {
                vos.forEach(this::registryThird);
                this.dispatchMessageContainer.addQueueNames(vos.stream().map(MqDispatchRegistryVo::getTopic).distinct().collect(Collectors.toList()).toArray(new String[0]));
            } else {
                vos.forEach(vo -> CommonsMqHelper.addProcessor((String)this.environment.resolvePlaceholders(vo.getTopic()), (String)this.parseConsumer((String)type, vo.getConsumer()), (String)this.environment.resolvePlaceholders(vo.getTag()), (String)"single", (IMessageProcessor)new RabbitRedirectProcessor((MqDispatchRegistryVo)vo, this.amqpTemplate)));
            }
        });
    }

    private String parseConsumer(String type, String consumer) {
        MessageRegistryVo messageRegistryVo = new MessageRegistryVo();
        messageRegistryVo.setType(type);
        return CommonsMqHelper.parseConsumer((MessageRegistryVo)messageRegistryVo, (String)consumer, (String)"");
    }

    private void registryThird(MqDispatchRegistryVo vo) {
        try {
            if (Binding.DestinationType.QUEUE.name().equals(vo.getDestinationType())) {
                this.rabbitHelper.bind(vo.getTopic(), vo.getTargetConsumer(), vo.getTag(), Binding.DestinationType.QUEUE);
            } else {
                this.rabbitHelper.bind(vo.getTopic(), vo.getTargetConsumer(), vo.getTag(), Binding.DestinationType.EXCHANGE);
            }
            ThirdRedirectProcessor thirdRedirectProcessor = new ThirdRedirectProcessor(this.mqServiceHashMap.get(vo.getTargetMqType()), vo);
            DispatchMessageListener.addProcessor(DispatchMessageListener.handleKey(vo.getTopic(), vo.getTag()), thirdRedirectProcessor);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u6ce8\u518c\u76d1\u542c\u5931\u8d25:{}, {}", (Object)e.getMessage(), (Object)JSONObject.toJSONString((Object)vo));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map serviceMap = applicationContext.getBeansOfType(ICommonsMqService.class);
        if (CollectionUtils.isEmpty((Map)serviceMap)) {
            return;
        }
        Set entrySet = serviceMap.entrySet();
        entrySet.forEach(entry -> {
            ICommonsMqService commonsMqService = (ICommonsMqService)entry.getValue();
            Field field = ReflectionUtils.findField(CommonsMqServiceImpl.class, (String)"messageRegistryVo");
            if (field == null) {
                return;
            }
            field.setAccessible(true);
            try {
                MessageRegistryVo messageRegistryVo = (MessageRegistryVo)field.get(commonsMqService);
                Assert.notNull((Object)messageRegistryVo);
                Assert.notEmpty((CharSequence)messageRegistryVo.getType(), (String)"MQ\u7c7b\u578b\u672a\u6307\u5b9a", (Object[])new Object[0]);
                this.mqServiceHashMap.put(messageRegistryVo.getType().toLowerCase(), commonsMqService);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }
}

