/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.pay;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.pay.AbstractPayHelp;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.pay.SimplePayReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.pay.TradePayRespDto;
import com.yx.tcbj.center.rebate.api.IOfflineBalanceBillApi;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillReqDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillSourceEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillTypeEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBusinessEnum;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="normalPayPayHelp")
public class NormalPayPayHelp
extends AbstractPayHelp<TradePayRespDto> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOfflineBalanceBillApi offlineBalanceBillApi;

    @Override
    public SimplePayReqDto initParam(Object ... objects) {
        SimplePayReqDto simplePayReqDto = new SimplePayReqDto();
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)simplePayReqDto);
        }
        return simplePayReqDto;
    }

    @Override
    protected SimplePayReqDto buildResult(SimplePayReqDto request) {
        return request;
    }

    @Override
    public void errorCallBack(SimplePayReqDto request) {
    }

    @Override
    public void successCallBackDefine(SimplePayReqDto simplePayReqDto) {
        this.addOrderPayRecord(simplePayReqDto);
    }

    @Override
    public boolean allowSubmitOrder(SimplePayReqDto request) {
        return true;
    }

    @Override
    public boolean isPrePayed(SimplePayReqDto simplePayReqDto) {
        return false;
    }

    @Override
    public void customerConfirmRefund(SimplePayReqDto simplePayReqDto) {
        if (simplePayReqDto.getRefundAmount() != null && BigDecimal.ZERO.compareTo(simplePayReqDto.getRefundAmount()) < 0) {
            OfflineBalanceBillReqDto billReqDto = new OfflineBalanceBillReqDto();
            billReqDto.setBillDate(new Date());
            billReqDto.setBillType(OfflineBalanceBillTypeEnum.REFUND.getCode());
            billReqDto.setBusinessContent(OfflineBalanceBusinessEnum.BUSINESS_ORDER.getCode());
            billReqDto.setCustomerId(Long.valueOf(simplePayReqDto.getCustomerId()));
            billReqDto.setAmount(simplePayReqDto.getRefundAmount());
            billReqDto.setBillSource(OfflineBalanceBillSourceEnum.ORDER_OFF_SUBMIT.getCode());
            billReqDto.setRelationNo(simplePayReqDto.getOrderNo());
            billReqDto.setReceiptRecordsNo(simplePayReqDto.getPayNo());
            this.logger.info("\u5728\u7ebf\u652f\u4ed8,\u751f\u6210\u5df2\u5ba1\u6838\u9000\u6b3e\u5355{}", (Object)JSON.toJSONString((Object)billReqDto));
            RestResponseHelper.extractData((RestResponse)this.offlineBalanceBillApi.addOfflineBalanceBill(billReqDto));
        }
    }
}

