/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.ForeignPortInventoryService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.BizStatusRepDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.BizStatusRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.BizCodeEnum;
import com.dtyunxi.tcbj.center.openapi.api.enums.BizStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ForeignPortInventoryServiceImpl
implements ForeignPortInventoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForeignPortInventoryServiceImpl.class);
    @Resource
    private ICsInventoryExposedApi csInventoryExposedApi;
    @Resource
    private ICacheService cacheService;

    @Override
    public RestResponse<Boolean> preemptInventoryByYxy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.cacheService.setCache(BizCodeEnum.PREEMPT_INVENTORY_YXY.getCode() + ":" + inventoryOperateReqDto.getSourceNo(), (Object)BizStatusEnum.BIZ_STATUS_PROCESSING.getCode(), 604800000);
        RestResponse restResponse = this.csInventoryExposedApi.preemptInventoryByYxy(inventoryOperateReqDto);
        LOGGER.info("preemptInventoryByYxy => \u5e93\u5b58\u9884\u5360,\u8425\u9500\u4e91\u4e13\u7528 result : {}", (Object)JSON.toJSONString((Object)restResponse));
        this.cacheService.setCache(BizCodeEnum.PREEMPT_INVENTORY_YXY.getCode() + ":" + inventoryOperateReqDto.getSourceNo(), (Object)BizStatusEnum.BIZ_STATUS_FINISH.getCode(), 604800000);
        return restResponse;
    }

    @Override
    public BizStatusRespDto queryBizStatus(BizStatusRepDto bizStatusRepDto) {
        String key = bizStatusRepDto.getCode() + ":" + bizStatusRepDto.getFlag();
        String cache = (String)this.cacheService.getCache(key, String.class);
        return new BizStatusRespDto(key, StringUtils.isAllBlank((CharSequence[])new CharSequence[]{cache}) ? BizStatusEnum.BIZ_STATUS_NOT_EXIT.getCode() : cache);
    }
}

