/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.auth.config;

import com.dtyunxi.tcbj.app.open.biz.auth.config.ContentRepeatableFilter;
import com.dtyunxi.tcbj.app.open.biz.auth.config.ThirdAuthInterceptorRegister;
import com.dtyunxi.tcbj.app.open.biz.auth.config.ThirdAuthProperties;
import com.dtyunxi.tcbj.app.open.biz.auth.interceptor.ThirdAuthInterceptor;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.SignHelper;
import com.dtyunxi.tcbj.app.open.biz.auth.sign.base.BaseShaSignHelper;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name={"openapi.third.auth.enable"}, havingValue="1")
@Configuration
@EnableConfigurationProperties(value={ThirdAuthProperties.class})
public class ThirdAuthAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SignHelper signHelper() {
        return new BaseShaSignHelper();
    }

    @Bean
    public ThirdAuthInterceptor thirdAuthInterceptor(SignHelper signHelper, ThirdAuthProperties properties) {
        return new ThirdAuthInterceptor(signHelper, properties);
    }

    @Bean
    public ThirdAuthInterceptorRegister thirdAuthInterceptorRegister(ThirdAuthInterceptor thirdAuthInterceptor) {
        return new ThirdAuthInterceptorRegister(thirdAuthInterceptor);
    }

    @Bean
    public FilterRegistrationBean someFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(this.contentRepeatableFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("contentRepeatableFilter");
        return registration;
    }

    @Bean(name={"contentRepeatableFilter"})
    public Filter contentRepeatableFilter() {
        return new ContentRepeatableFilter();
    }
}

