/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.after.abs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.constant.CommonConstant;
import com.dtyunxi.tcbj.app.open.biz.service.impl.IPriceRuleHelper;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.CreateAfterSalesOrderDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ItemReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.OrderItemExtDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.OrderReturnBizTypeEnum;
import com.dtyunxi.tcbj.center.openapi.api.enums.ReqCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.IAddressQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.ICommunalPriceQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.ReturnOrderCreateModeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.price.api.dto.response.EnablePriceConfigRespDto;
import com.yx.tcbj.center.price.api.query.IEnablePriceConfigQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAfterSaleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAfterSaleService.class);
    @Resource
    private IShopQueryApi shopQueryApi;
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IEnablePriceConfigQueryApi enablePriceConfigQueryApi;
    @Resource
    private ICommunalPriceQueryApi communalPriceQueryApi;
    @Resource
    private IPriceRuleHelper priceRuleHelper;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Autowired
    private IAddressQueryApi addressQueryApi;
    @Resource
    private IAfterSalesApi afterSalesApi;

    protected void verifyReqParams(CreateAfterSalesOrderDto createAfterSalesOrderDto) {
    }

    public String createAfterSalesOrder(CreateAfterSalesOrderDto createAfterSalesOrderDto) {
        this.verifyReqParams(createAfterSalesOrderDto);
        CustomerRespDto customerRespDto = this.getCustomerRespDto(createAfterSalesOrderDto);
        ShopQueryDto shopQueryDto = new ShopQueryDto();
        shopQueryDto.setOrganizationId(customerRespDto.getMerchantId());
        RestResponse shopListRestResponse = this.shopQueryApi.queryShopList(shopQueryDto);
        LOGGER.info("\u3010\u5e97\u94fa\u4e2d\u5fc3\u3011\u6839\u636e\u7ec4\u7ec7ID\uff1a{} \u83b7\u53d6\u5e97\u94fa\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)shopQueryDto), (Object)JSON.toJSONString((Object)shopListRestResponse));
        List shopDtos = (List)RestResponseHelper.extractData((RestResponse)shopListRestResponse);
        ShopDto shopDto = shopDtos.stream().filter(c -> c.getOrganizationId().equals(customerRespDto.getMerchantId())).findFirst().get();
        List cargoCodeList = createAfterSalesOrderDto.getAfterSalesItems().stream().map(c -> c.getCargoCode()).collect(Collectors.toList());
        RestResponse itemRespDtoRestResponse = this.itemQueryApi.queryByItemLongCodes(cargoCodeList);
        LOGGER.info("\u3010\u5546\u54c1\u4e2d\u5fc3\u3011\u6839\u636e\u5546\u54c1code:{} \u83b7\u53d6\u5546\u54c1\u57fa\u7840\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(cargoCodeList), (Object)JSON.toJSONString((Object)itemRespDtoRestResponse));
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)itemRespDtoRestResponse);
        List itemIds = itemRespDtos.stream().map(c -> c.getId()).collect(Collectors.toList());
        List skuIds = itemRespDtos.stream().map(c -> c.getSkuId()).collect(Collectors.toList());
        RestResponse itemSkuRestResponse = this.itemSkuQueryApi.querySkuExtBySkuId(skuIds);
        LOGGER.info("\u3010\u5546\u54c1\u4e2d\u5fc3\u3011\u6839\u636e\u5546\u54c1SKU:{} \u83b7\u53d6\u5546\u54c1SKU\u57fa\u7840\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(skuIds), (Object)JSON.toJSONString((Object)itemSkuRestResponse));
        List itemSkuExtRespDtos = (List)RestResponseHelper.extractData((RestResponse)itemSkuRestResponse);
        Map<String, ItemSkuExtRespDto> itemSkuExtRespDtoMap = itemSkuExtRespDtos.stream().collect(Collectors.toMap(ItemSkuRespDto::getCargoCode, ItemSkuExtRespDto2 -> ItemSkuExtRespDto2));
        EnablePriceConfigRespDto enablePriceConfigRespDto = (EnablePriceConfigRespDto)RestResponseHelper.extractData((RestResponse)this.enablePriceConfigQueryApi.queryByShopId(shopDto.getId()));
        CommunalPriceQueryReqDto communalPriceQueryReqDto = new CommunalPriceQueryReqDto();
        communalPriceQueryReqDto.setCustomerIds(Arrays.asList(customerRespDto.getId()));
        communalPriceQueryReqDto.setPolicyDate(new Date());
        ArrayList skuPriceReqDtoList = new ArrayList();
        createAfterSalesOrderDto.getAfterSalesItems().forEach(afterItem -> {
            ItemSkuExtRespDto itemSkuExtRespDto = (ItemSkuExtRespDto)itemSkuExtRespDtoMap.get(afterItem.getCargoCode());
            if (itemSkuExtRespDto != null) {
                CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                skuPriceReqDto.setSkuId(itemSkuExtRespDto.getId());
                skuPriceReqDto.setItemId(itemSkuExtRespDto.getItemId());
                skuPriceReqDto.setShopId(shopDto.getId());
                skuPriceReqDtoList.add(skuPriceReqDto);
            }
        });
        communalPriceQueryReqDto.setSkuList(skuPriceReqDtoList);
        List itemPolicyPriceRespDtos = null;
        itemPolicyPriceRespDtos = ObjectUtils.isNotEmpty((Object)enablePriceConfigRespDto) ? (List)RestResponseHelper.extractData((RestResponse)this.communalPriceQueryApi.queryDistributionPrice(communalPriceQueryReqDto)) : this.priceRuleHelper.getItemPrice(communalPriceQueryReqDto);
        LOGGER.info("\u3010\u5546\u54c1\u4e2d\u5fc3\u3011\u6839\u636e\u5546\u54c1\u4fe1\u606f:{} \u83b7\u53d6\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)communalPriceQueryReqDto), (Object)JSON.toJSONString((Object)itemPolicyPriceRespDtos));
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)itemPolicyPriceRespDtos), (String)ReqCodeEnum.ADDAFTERITAM_PRICE_ERROR.getCode(), (String)ReqCodeEnum.ADDAFTERITAM_PRICE_ERROR.getDesc());
        Map skuPriceMap = itemPolicyPriceRespDtos.stream().collect(Collectors.toMap(item -> item.getShopId() + "-" + item.getSkuId(), Function.identity(), (o1, o2) -> o2));
        List itemRespDtoList = (List)this.itemQueryApi.queryByItemIds(StringUtils.join(itemIds, (String)",")).getData();
        LOGGER.info("\u3010\u5546\u54c1\u4e2d\u5fc3\u3011\u6839\u636e\u5546\u54c1\u4fe1\u606f:{} \u83b7\u53d6\u5546\u54c1\u5b50\u7c7b\u578b\u4ee5\u53ca\u4e0a\u67b6\u7c7b\u578b\u4fe1\u606f\uff1a{}", (Object)StringUtils.join(itemIds, (String)","), (Object)JSON.toJSONString((Object)itemRespDtoList));
        Map<Long, OrderItemExtDto> itemTypeMap = itemRespDtoList.stream().map(c -> {
            OrderItemExtDto orderItemExtDto = new OrderItemExtDto();
            orderItemExtDto.setItemId(c.getId());
            orderItemExtDto.setShelfType(c.getShelfType());
            orderItemExtDto.setSubType(c.getSubType());
            return orderItemExtDto;
        }).collect(Collectors.toMap(key -> key.getItemId(), val -> val, (v1, v2) -> v1));
        List afterSalesItemReqDtos = createAfterSalesOrderDto.getAfterSalesItems().stream().map(c -> {
            AfterSalesItemReqDto itemReqDto = this.createAfterSalesItemReqDto(itemSkuExtRespDtoMap, skuPriceMap, itemTypeMap, (ItemReqDto)c, shopDto.getId());
            return itemReqDto;
        }).collect(Collectors.toList());
        ReturnReqDto reqDto = new ReturnReqDto();
        reqDto.setAfterSalesItems(afterSalesItemReqDtos);
        reqDto.setCancelType(DeliveryCancelTypeEnum.NOT_CANCLE.getType());
        reqDto.setOrderTradeNo(null);
        reqDto.setTradeNo(null);
        reqDto.setReturnType(StringUtils.isBlank((CharSequence)createAfterSalesOrderDto.getOrderReturnBizType()) ? OrderReturnBizTypeEnum.REFUND_AND_RETURN.getCode() : createAfterSalesOrderDto.getOrderReturnBizType());
        reqDto.setCustomerId(customerRespDto.getId().toString());
        reqDto.setExtlReturnSerial(createAfterSalesOrderDto.getExtlReturnSerial());
        reqDto.setExtlReturnSrc(createAfterSalesOrderDto.getExtlReturnSrc());
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setOrganizationId(customerRespDto.getMerchantId());
        List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
        SellerRespDto sellerRespDto = sellerRespDtos.stream().filter(c -> c.getOrganizationId().equals(customerRespDto.getMerchantId())).findFirst().get();
        int sum = afterSalesItemReqDtos.stream().mapToInt(c -> c.getItemNum()).sum();
        HashMap<String, Object> extFields = new HashMap<String, Object>();
        extFields.put("createMode", ReturnOrderCreateModeEnum.FROM_MANUAL_SKU.getType());
        extFields.put("refundStatus", "INIT");
        extFields.put("applyReturnQty", sum);
        extFields.put("placeTime", DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date()));
        extFields.put("sellerId", sellerRespDto.getId());
        extFields.put("customerId", customerRespDto.getId());
        extFields.put("shopId", shopDto.getId());
        AddressQueryReqDto addressQueryReqDto = new AddressQueryReqDto();
        addressQueryReqDto.setOrgInfoId(customerRespDto.getOrgInfoId());
        addressQueryReqDto.setAddressType(AddressTypeEnum.DELIVERY.getCode());
        addressQueryReqDto.setStatus(Integer.valueOf(1));
        PageInfo addressPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.addressQueryApi.queryAddressByPage(addressQueryReqDto, Integer.valueOf(1), Integer.valueOf(10000)));
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)addressPage.getList()), (String)ReqCodeEnum.ADDRESS_IS_NOT_EXIT.getCode(), (String)ReqCodeEnum.ADDRESS_IS_NOT_EXIT.getDesc());
        AddressRespDto addressRespDto = (AddressRespDto)addressPage.getList().stream().findFirst().get();
        extFields.put("buyerAddrInfo", JSON.toJSONString((Object)addressRespDto));
        reqDto.setExtFields(extFields);
        ServiceContext.getContext().setAttachment("yes.req.tenantId", CommonConstant.TENANT_ID.toString());
        ServiceContext.getContext().setAttachment("yes.req.instanceId", CommonConstant.INSTANCE_ID.toString());
        LOGGER.info("\u3010\u539f\u5355\u9000\u8d27\u3011\u5f00\u59cb\u5904\u7406\u552e\u540e request:{}", (Object)JSONObject.toJSONString((Object)reqDto));
        RestResponse mapRestResponse = this.afterSalesApi.addAfterSaleApply(reqDto);
        Map result = (Map)RestResponseHelper.extractData((RestResponse)mapRestResponse);
        LOGGER.info("\u751f\u6210\u9000\u8d27\u5355 response:{}", (Object)JSONObject.toJSONString((Object)mapRestResponse));
        Assert.notNull((Object)result, (String)ReqCodeEnum.ADDAFTERSALEAPPLY_ERROR.getCode(), (String)ReqCodeEnum.ADDAFTERSALEAPPLY_ERROR.getDesc());
        return result.getOrDefault("returnNo", "").toString();
    }

    protected CustomerRespDto getCustomerRespDto(CreateAfterSalesOrderDto createAfterSalesOrderDto) {
        return null;
    }

    private AfterSalesItemReqDto createAfterSalesItemReqDto(Map<String, ItemSkuExtRespDto> itemSkuExtRespDtoMap, Map<String, ItemPolicyPriceRespDto> skuPriceMap, Map<Long, OrderItemExtDto> itemTypeMap, ItemReqDto c, Long shopId) {
        ItemSkuExtRespDto itemSkuExtRespDto = itemSkuExtRespDtoMap.getOrDefault(c.getCargoCode(), null);
        ItemPolicyPriceRespDto orDefault = skuPriceMap.getOrDefault(shopId + "-" + itemSkuExtRespDto.getSkuId(), null);
        OrderItemExtDto orderItemExtDto = itemTypeMap.getOrDefault(itemSkuExtRespDto.getItemId(), null);
        BigDecimal defaultMatchPrice = this.priceRuleHelper.getDefaultMatchPrice(orDefault, c.getChangeInventory().intValue());
        Assert.notNull((Object)itemSkuExtRespDto, (String)ReqCodeEnum.ADDAFTERITAM_ERROR.getCode(), (String)ReqCodeEnum.ADDAFTERITAM_ERROR.getDesc());
        Assert.notNull((Object)orDefault, (String)ReqCodeEnum.ADDAFTERITAM_PRICE_ERROR.getCode(), (String)ReqCodeEnum.ADDAFTERITAM_PRICE_ERROR.getDesc());
        AfterSalesItemReqDto itemReqDto = new AfterSalesItemReqDto();
        itemReqDto.setItemNum(Integer.valueOf(c.getChangeInventory().intValue()));
        itemReqDto.setItemPrice(defaultMatchPrice);
        itemReqDto.setSkuSerial(itemSkuExtRespDto.getSkuId().toString());
        itemReqDto.setItemSerial(itemSkuExtRespDto.getItemId().toString());
        itemReqDto.setItemCode(itemSkuExtRespDto.getItemCode());
        itemReqDto.setBatchNo(c.getBatch() + "#" + c.getChangeInventory());
        itemReqDto.setExtension(JSONObject.toJSONString((Object)orderItemExtDto));
        HashMap<String, Object> extFields = new HashMap<String, Object>();
        extFields.put("returnedNum", 0);
        extFields.put("cargoSerial", itemSkuExtRespDto.getSkuCode());
        extFields.put("returnNum", c.getChangeInventory());
        extFields.put("unit", itemSkuExtRespDto.getUnit());
        extFields.put("itemAmount", BigDecimal.ZERO);
        extFields.put("brandId", itemSkuExtRespDto.getBrandId());
        extFields.put("shopId", shopId);
        extFields.put("itemName", itemSkuExtRespDto.getItemName());
        extFields.put("skuCode", itemSkuExtRespDto.getSkuCode());
        extFields.put("skuDesc", itemSkuExtRespDto.getAttr());
        extFields.put("refundAmount", c.getChangeInventory().multiply(defaultMatchPrice).toString());
        itemReqDto.setExtFields(extFields);
        return itemReqDto;
    }
}

