/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.connector.comm.constant.Constants;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class StoreSyncConfig
implements CommandLineRunner {
    private final Logger logger = LoggerFactory.getLogger(StoreSyncConfig.class);
    @Resource
    private ITaskApi iTaskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Value(value="${scheduler.client.app_code:tcbj-openapi-platform}")
    private String appCode;
    @Value(value="${scheduler.client.syncStoreEventCron:0 0 0 * * ?}")
    private String syncStoreEventCron;
    @Value(value="${scheduler.client.syncStoreAreaEventCron:0 0 1 * * ?}")
    private String syncStoreAreaEventCron;
    @Value(value="${scheduler.client.ifOpenSyncStore:false}")
    private boolean ifOpenSyncStore;

    public void run(String ... args) {
        this.logger.info(">>>>\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb\u521b\u5efa");
        if (!this.ifOpenSyncStore) {
            this.logger.info(">>>>\u4e0d\u521d\u59cb\u5316\u4efb\u52a1");
            return;
        }
        try {
            this.startSyncEvent("SyncStoreEvent", "\u5b9a\u65f6\u540c\u6b65\u8d62\u9500\u901a\u836f\u5e97\u4fe1\u606f\u6570\u636e\u8c03\u5ea6\u4efb\u52a1", this.syncStoreEventCron);
            this.startSyncEvent("SyncStoreAreaEvent", "\u5b9a\u65f6\u540c\u6b65\u8d62\u9500\u901a\u836f\u5e97\u533a\u57df\u4fe1\u606f\u6570\u636e\u8c03\u5ea6\u4efb\u52a1", this.syncStoreAreaEventCron);
            this.logger.info(">>>>\u8c03\u5ea6\u4efb\u52a1\u521b\u5efa\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void startSyncEvent(String code, String name, String cron) {
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode(code);
        dto.setBizName(name);
        dto.setScheduleExpression(cron);
        dto.setTaskName(name);
        dto.setTenantId(Constants.CONNECTOR_TENANT_ID);
        dto.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
        dto.setShardType("SINGLE");
        try {
            RestResponse restResponse = this.iTaskApi.addWithBiz(dto);
            if (null != restResponse && "0".equals(restResponse.getResultCode())) {
                RequestDto requestDto = new RequestDto();
                requestDto.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
                requestDto.setTenantId(Constants.CONNECTOR_TENANT_ID);
                this.iTaskApi.enableById((Long)restResponse.getData(), ObjectHelper.bean2Json((Object)requestDto));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

