/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.ICustomerSalesmanRelationService;
import com.dtyunxi.tcbj.app.open.dao.das.CustomerSalesmanRelationDas;
import com.dtyunxi.tcbj.app.open.dao.eo.CustomerSalesmanRelationEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerSalesmanApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.RCustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserExtQueryApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@DS(value="slave_1")
public class CustomerSalesmanRelationServiceImpl
implements ICustomerSalesmanRelationService {
    private Logger logger = LoggerFactory.getLogger(CustomerSalesmanRelationServiceImpl.class);
    @Autowired
    private CustomerSalesmanRelationDas customerSalesmanRelationDas;
    @Autowired
    private IUserExtQueryApi userExtQueryApi;
    @Autowired
    private ICustomerSalesmanApi customerSalesmanApi;
    @Value(value="${customer.salesman.relation.pageSize:10000}")
    private Integer pageSize;
    @Autowired
    private IBizOrganizationQueryApi organizationQueryApi;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;

    @Override
    public void syncCustomerSalesmanRelation(List<String> orgIds) {
        long start = System.currentTimeMillis();
        Integer pageNum = 1;
        List relationList = this.customerSalesmanRelationDas.queryPage(Integer.valueOf((pageNum - 1) * this.pageSize), Integer.valueOf(pageNum * this.pageSize), orgIds);
        while (CollectionUtils.isNotEmpty((Collection)relationList)) {
            this.handle(relationList);
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            relationList = this.customerSalesmanRelationDas.queryPage(Integer.valueOf((pageNum - 1) * this.pageSize), Integer.valueOf(pageNum * this.pageSize), orgIds);
            this.logger.info("\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5ba2\u6237\u5173\u7cfb\u540c\u6b65\u4e1a\u52a1\uff0c\u5f53\u524d\u9875\uff1a{}", (Object)pageNum);
        }
        this.logger.info("\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5ba2\u6237\u5173\u7cfb\u540c\u6b65\u4e1a\u52a1\uff0c\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public void centerHandleCustomerSalesmanRelation(CustomerSalesmanRelationEo relation) {
        this.logger.info("\u6279\u91cf\u540c\u6b65\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5173\u8054\u5173\u7cfb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)relation));
        if (relation == null || StringUtils.isEmpty((CharSequence)relation.getOrgId())) {
            this.logger.info("\u6279\u91cf\u540c\u6b65\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5173\u8054\u5173\u7cfb\uff0c\u96c6\u5408\u4e3a\u7a7a");
            return;
        }
        List relationList = this.customerSalesmanRelationDas.selectRelation(relation);
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            this.logger.info("\u67e5\u8be2\u89c6\u56fe\u4e1a\u52a1\u5458\u548c\u5c0fb\u7684\u5173\u7cfb\u4e3a\u7a7a");
            return;
        }
        this.handle(relationList);
    }

    @Override
    public Map<String, List<Long>> selectCodeList(List<String> orgIds) {
        ShopQueryDto shopQueryDto = new ShopQueryDto();
        shopQueryDto.setOrganizationCode(orgIds.get(0));
        RestResponse shopDtoRest = this.shopQueryApi.queryShopListNew(shopQueryDto);
        if (null == shopDtoRest.getData()) {
            return null;
        }
        ArrayList targetIds = CollectionUtils.isNotEmpty((Collection)((Collection)shopDtoRest.getData())) ? ((List)shopDtoRest.getData()).stream().map(ShopDto::getId).collect(Collectors.toList()) : new ArrayList();
        ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
        itemAuthReqDto.setTargetIdList(targetIds);
        itemAuthReqDto.setTargetType(Integer.valueOf(2));
        List itemAuthRespDtoList = (List)this.itemAuthQueryApi.queryByTargetIds(itemAuthReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)itemAuthRespDtoList)) {
            this.logger.info("\u5546\u54c1\u6388\u6743\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        List skuIds = itemAuthRespDtoList.stream().map(ItemAuthRespDto::getBusinessId).collect(Collectors.toList());
        List itemSkuRespDtoList = (List)this.itemQueryApi.queryItemSkus(skuIds).getData();
        if (CollectionUtils.isEmpty((Collection)itemSkuRespDtoList)) {
            this.logger.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        Map<Long, List<ItemAuthRespDto>> shopIdListMap = itemAuthRespDtoList.stream().collect(Collectors.groupingBy(ItemAuthRespDto::getTargetId));
        Map<Long, Long> skuIdMap = itemSkuRespDtoList.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, ItemSkuRespDto::getItemId));
        shopIdListMap.keySet().forEach(n -> {
            ArrayList itemIdList = Lists.newArrayList();
            List itemAuthRespDtos = (List)shopIdListMap.get(n);
            itemAuthRespDtos.forEach(item -> {
                Long itemId = (Long)skuIdMap.get(item.getBusinessId());
                itemIdList.add(itemId);
            });
            map.put(String.valueOf(n), itemIdList);
        });
        return map;
    }

    private void handle(List<CustomerSalesmanRelationEo> relationList) {
        this.logger.debug("\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5ba2\u6237\u5173\u7cfb\u540c\u6b65\u4e1a\u52a1\uff0c\u8425\u9500\u4e91\u540c\u6b65\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(relationList));
        HashMap xbCustomerCodeMap = Maps.newHashMap();
        List orgIds = relationList.stream().map(CustomerSalesmanRelationEo::getOrgId).distinct().collect(Collectors.toList());
        List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.getOrganizations(orgIds));
        this.logger.debug("\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5ba2\u6237\u5173\u7cfb\u540c\u6b65\u4e1a\u52a1\uff0c\u7ec4\u7ec7\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)organizationDtos));
        Map<String, OrganizationDto> orgMap = organizationDtos.stream().collect(Collectors.toMap(OrganizationDto::getCode, e -> e, (e1, e2) -> e1));
        for (CustomerSalesmanRelationEo customerSalesmanRelationEo : relationList) {
            if (!orgMap.containsKey(customerSalesmanRelationEo.getOrgId())) continue;
            OrganizationDto organizationDto = orgMap.get(customerSalesmanRelationEo.getOrgId());
            RCustomerSalesmanReqDto rCustomerSalesmanReqDto = new RCustomerSalesmanReqDto();
            rCustomerSalesmanReqDto.setCustomerCode(customerSalesmanRelationEo.getDealerId());
            rCustomerSalesmanReqDto.setOrgId(organizationDto.getId());
            if (xbCustomerCodeMap.containsKey(customerSalesmanRelationEo.getLogin())) {
                ((List)xbCustomerCodeMap.get(customerSalesmanRelationEo.getLogin())).add(rCustomerSalesmanReqDto);
                continue;
            }
            ArrayList list = Lists.newArrayList((Object[])new RCustomerSalesmanReqDto[]{rCustomerSalesmanReqDto});
            xbCustomerCodeMap.put(customerSalesmanRelationEo.getLogin(), list);
        }
        UserQueryReqDto userQueryReqDto = new UserQueryReqDto();
        userQueryReqDto.setUserNames(new ArrayList(xbCustomerCodeMap.keySet()));
        ArrayList list = Lists.newArrayList();
        List userRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.userExtQueryApi.queryUserByUserNames(userQueryReqDto));
        this.logger.debug("\u4e1a\u52a1\u5458\u4e0e\u5c0fb\u5ba2\u6237\u5173\u7cfb\u540c\u6b65\u4e1a\u52a1\uff0c\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)userRespDtos));
        for (UserRespDto userRespDto : userRespDtos) {
            CustomerSalesmanReqDto reqDto = new CustomerSalesmanReqDto();
            if (xbCustomerCodeMap.containsKey(userRespDto.getUserName())) {
                List rCustomerSalesmanReqDtos = (List)xbCustomerCodeMap.get(userRespDto.getUserName());
                reqDto.setCustomerSalesmanReqDtos(rCustomerSalesmanReqDtos);
            }
            reqDto.setOrgInfoId(userRespDto.getOrganizationInfoId());
            reqDto.setCode(userRespDto.getUserName());
            reqDto.setName(userRespDto.getUserName());
            reqDto.setUserId(userRespDto.getId());
            reqDto.setStatus(userRespDto.getStatus());
            reqDto.setTenantId(userRespDto.getTenantId());
            reqDto.setInstanceId(userRespDto.getInstanceId());
            reqDto.setSex(StringUtils.isNumeric((CharSequence)userRespDto.getSex()) ? Integer.valueOf(userRespDto.getSex()) : null);
            list.add(reqDto);
        }
        RestResponseHelper.extractData((RestResponse)this.customerSalesmanApi.batchAddSalesmanRelation((List)list));
    }
}

