/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.util.ReflectionUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class AssertUtil {
    public static void isTrue(boolean expression, String message) {
        AssertUtil.isTrue(expression, ExceptionCode.FAIL.getCode(), message);
    }

    public static void isFalse(boolean expression, String message) {
        AssertUtil.isTrue(!expression, ExceptionCode.FAIL.getCode(), message);
    }

    public static void isTrue(boolean expression, String code, String message) {
        if (!expression) {
            throw new BizException(code, message);
        }
    }

    public static void isTrues(boolean expression, String code, String message) {
        if (expression) {
            throw new BizException(code, message);
        }
    }

    public static void emptyValidated(Object obj, String ... fields) {
        AssertUtil.isTrue(obj != null, ExceptionCode.INVALID_PARAM.getCode(), ExceptionCode.INVALID_PARAM.getMsg());
        for (String field : fields) {
            Object fieldValue = ReflectionUtils.getFieldValue((Object)obj, (String)field);
            boolean expression = true;
            boolean bl = expression = fieldValue != null;
            if (expression) {
                if (fieldValue instanceof String) {
                    expression = StringUtils.isNotBlank((CharSequence)((String)fieldValue));
                } else if (fieldValue instanceof Short) {
                    expression = (Short)fieldValue > 0;
                } else if (fieldValue instanceof Integer) {
                    expression = (Integer)fieldValue > 0;
                } else if (fieldValue instanceof Long) {
                    expression = (Long)fieldValue > 0L;
                } else if (fieldValue instanceof Float) {
                    expression = ((Float)fieldValue).floatValue() > 0.0f;
                } else if (fieldValue instanceof Double) {
                    expression = (Double)fieldValue > 0.0;
                } else if (fieldValue instanceof BigDecimal) {
                    expression = ((BigDecimal)fieldValue).compareTo(BigDecimal.ZERO) > 0;
                } else if (fieldValue instanceof Collection) {
                    expression = !CollectionUtils.isEmpty((Collection)((Collection)fieldValue));
                } else if (fieldValue instanceof Map) {
                    expression = !CollectionUtils.isEmpty((Map)((Map)fieldValue));
                }
            }
            AssertUtil.isTrue(expression, ExceptionCode.INVALID_PARAM.getCode(), field + ExceptionCode.INVALID_PARAM.getMsg());
        }
    }

    public static <E> boolean isEquals(E e1, E e2) {
        return e1 == null && e2 == null || e1 != null && e1.equals(e2) || e2 != null && e2.equals(e1);
    }

    public static <E> boolean notEquals(E e1, E e2) {
        return !AssertUtil.isEquals(e1, e2);
    }

    public static void assertNotBlank(String s, String errorMessage) {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertNotCollection(Collection<?> list, String errorMessage) {
        if (CollectionUtil.isEmpty(list)) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertTrue(boolean b, String errorMessage) {
        if (!b) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertMaxLength(String s, int maxLength, String errorMessage) {
        if (s != null && s.length() > maxLength) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertNonnegativeInt(int n, String errorMessage) {
        if (n < 0) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertGreaterThanOrEqual(int a, int b, String errorMessage) {
        if (a < b) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertEqual(int a, int b, String errorMessage) {
        if (a != b) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertEqual(long a, long b, String errorMessage) {
        if (a != b) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertGreaterThanOrEqual(long a, long b, String errorMessage) {
        if (a < b) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertGreaterThanZero(int n, String errorMessage) {
        if (n < 1) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertGreaterThanZero(long n, String errorMessage) {
        if (n < 1L) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertNotNull(Object o, String errorMessage) {
        if (o == null) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertNotEmpty(@Nullable Collection<?> collection, String errorMessage) {
        AssertUtil.assertNotNull(collection, errorMessage);
        if (CollectionUtils.isEmpty(collection)) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertNotEmpty(@Nullable Map<?, ?> map, String errorMessage) {
        AssertUtil.assertNotNull(map, errorMessage);
        if (CollectionUtils.isEmpty(map)) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertNotEmpty(@Nullable Object[] array, String errorMessage) {
        AssertUtil.assertNotNull(array, errorMessage);
        if (ObjectUtils.isEmpty((Object[])array)) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static void assertHHmm(String str, String errorMessage) {
        if (errorMessage == null) {
            errorMessage = "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef[HH:mm]";
        }
        if (str == null) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
        if (!Pattern.matches("^(20|21|22|23|[0-1]\\d):[0-5]\\d$", str)) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), errorMessage);
        }
    }

    public static boolean assertEmpty(Object obj, String ... fields) {
        try {
            AssertUtil.emptyValidated(obj, fields);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

