/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.wms;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.app.open.biz.wms.IWmsService;
import com.dtyunxi.tcbj.app.open.dao.das.WarehouseWmsDas;
import com.dtyunxi.tcbj.app.open.dao.eo.WarehouseWmsEo;
import com.dtyunxi.tcbj.center.openapi.common.wms.WmsBaseDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.enums.ExternalWmsServiceEnum;
import com.dtyunxi.tcbj.openapi.qimen.weizhi.common.QimenPropertiesConfig;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Service;

@Service
public class WmsSelector
implements BeanFactoryAware {
    private final Map<String, IWmsService> serviceMap = new ConcurrentHashMap<String, IWmsService>(10);
    @Resource
    private WarehouseWmsDas warehouseWmsDas;
    @Resource
    private QimenPropertiesConfig qimenPropertiesConfig;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Optional.of(((ConfigurableListableBeanFactory)beanFactory).getBeansOfType(IWmsService.class)).filter(CollUtil::isNotEmpty).map(Map::values).ifPresent(beans -> beans.forEach(bean -> this.serviceMap.put(bean.getType(), (IWmsService)bean)));
    }

    public IWmsService selector(WmsBaseDto baseDto) {
        baseDto.setWmsRelevance(Optional.ofNullable(baseDto.getSystemCode()).orElseGet(() -> Optional.ofNullable(((ExtQueryChainWrapper)this.warehouseWmsDas.filter(true).eq((Object)"warehouse_code", (Object)baseDto.getWarehouseCode())).one()).map(WarehouseWmsEo::getWmsRelevance).orElseThrow(() -> new BizException("\u4ed3\u5e93\u672a\u914d\u7f6e!"))));
        ExternalWmsServiceEnum serviceEnum = Optional.ofNullable(ExternalWmsServiceEnum.getByCode((String)Optional.ofNullable(baseDto.getSystemCode()).orElse(baseDto.getWmsRelevance()))).orElseThrow(() -> new BizException("\u65e0\u6cd5\u9002\u914d\u7684\u7cfb\u7edf"));
        if (serviceEnum == ExternalWmsServiceEnum.QIMEN_WMS) {
            QimenPropertiesConfig.Properties byPcpChannel = this.qimenPropertiesConfig.findByPcpChannel(baseDto.getWmsRelevance());
            baseDto.setCustomerId(byPcpChannel.getQimenCustomerId());
            baseDto.setOwnerCode("TCBJ");
        }
        return this.serviceMap.get(serviceEnum.getServiceCode());
    }
}

