/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.OrganizationColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAndOrgInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="centerHandleOrgServiceImpl")
public class CenterHandleOrgServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleOrgServiceImpl.class);
    @Autowired
    private IOrganizationApi organizationApi;
    @Autowired
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Autowired
    private IBizOrganizationQueryApi bizOrganizationQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.ORG.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636e\u5206\u53d1:{}", (Object)modelInfoReqDto.toString());
        List maps = JSONArray.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        logger.info("\u7ec4\u7ec7\u6a21\u578b\u6570\u636emap\u8f6c\u6362\u7ed3\u679c:{}", (Object)maps.toString());
        ArrayList<DataDistributeRespDto> respDtoList = new ArrayList<DataDistributeRespDto>();
        for (Map map : maps) {
            OrganizationInfoDto infoDto = new OrganizationInfoDto();
            OrganizationDto organizationDto = new OrganizationDto();
            DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
            dataDistributeRespDto.setType(DataDistributeRespEnum.SUCCESS.getCode());
            String uuid = String.valueOf(map.get(CustomerEnum.CIDP_TASK_UUID.getCode()));
            dataDistributeRespDto.setTask_id(uuid);
            String code = map.get(OrganizationColumnEnum.ORGCODE.name()).toString();
            try {
                ArrayList<String> listCode = new ArrayList<String>();
                listCode.add(code);
                RestResponse organizations = this.bizOrganizationQueryApi.getOrganizations(listCode);
                OrgAndOrgInfoReqDto orgAndOrgInfoReqDto = this.enumCopyObject(infoDto, organizationDto, map);
                if (((List)organizations.getData()).size() > 0) {
                    for (OrganizationDto datum : (List)organizations.getData()) {
                        this.organizationApi.modifyOrgAndOrgInfo(datum.getId(), orgAndOrgInfoReqDto);
                        dataDistributeRespDto.setType(DataDistributeRespEnum.SUCCESS.getCode());
                        dataDistributeRespDto.setReason("\u4fee\u6539\u7ec4\u7ec7\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e3a:" + code);
                        respDtoList.add(dataDistributeRespDto);
                    }
                    continue;
                }
                orgAndOrgInfoReqDto.setOrganizationDto(organizationDto);
                orgAndOrgInfoReqDto.setOrganizationInfoDto(infoDto);
                RestResponse longRestResponse = this.organizationApi.addOrgAndOrgInfo(orgAndOrgInfoReqDto);
                dataDistributeRespDto.setReason("\u65b0\u589e\u7ec4\u7ec7\u6210\u529f\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e3a:{}" + code);
                respDtoList.add(dataDistributeRespDto);
            }
            catch (Exception e) {
                logger.info("\u540c\u6b65\u7ec4\u7ec7\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
                dataDistributeRespDto.setType(DataDistributeRespEnum.FAILURE.getCode());
                dataDistributeRespDto.setReason("\u7ec4\u7ec7\u7f16\u7801\u4e3a:" + code + "\u7684\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                respDtoList.add(dataDistributeRespDto);
            }
        }
        return respDtoList;
    }

    public OrgAndOrgInfoReqDto enumCopyObject(OrganizationInfoDto infoDto, OrganizationDto organizationDto, Map map) {
        OrgAndOrgInfoReqDto orgAndOrgInfoReqDto = new OrgAndOrgInfoReqDto();
        String code = map.get(OrganizationColumnEnum.ORGCODE.name()).toString();
        infoDto.setOrgCode(code);
        if (StringUtils.isNotEmpty((CharSequence)String.valueOf(map.get(OrganizationColumnEnum.ORGNAME.name())))) {
            infoDto.setOrgName(String.valueOf(map.get(OrganizationColumnEnum.ORGNAME.name())));
        }
        infoDto.setSimpleName(String.valueOf(map.get(OrganizationColumnEnum.SHORTNAME.name())));
        infoDto.setOrgType(String.valueOf(map.get(OrganizationColumnEnum.ORGTYPE.name())));
        infoDto.setCreditCode(String.valueOf(map.get(OrganizationColumnEnum.ORGANIZATIONCODE.name())));
        infoDto.setAddress(String.valueOf(map.get(OrganizationColumnEnum.ADDRESS.name())));
        infoDto.setPhoneNum(String.valueOf(map.get(OrganizationColumnEnum.PHONE.name())));
        infoDto.setPostcode(String.valueOf(map.get(OrganizationColumnEnum.POSTCODE.name())));
        organizationDto.setCode(code);
        organizationDto.setType(String.valueOf(map.get(OrganizationColumnEnum.ORGTYPE.name())));
        organizationDto.setName(String.valueOf(map.get(OrganizationColumnEnum.ORGNAME.name())));
        organizationDto.setName_i1(String.valueOf(map.get(OrganizationColumnEnum.SHORTNAME.name())));
        orgAndOrgInfoReqDto.setOrganizationDto(organizationDto);
        orgAndOrgInfoReqDto.setOrganizationInfoDto(infoDto);
        return orgAndOrgInfoReqDto;
    }
}

