/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.processor;

import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="STRING_CODE_CHECK_PUSH")
public class StringCodeCheckProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(StringCodeCheckProcessor.class);
    @Resource
    private ICacheService cacheService;

    public MessageResponse process(MessageVo message) {
        try {
            String orderNo = (String)message.getData();
            ArrayList orderList = Lists.newArrayList();
            String data = (String)this.cacheService.getCache("string_code_check_cache_key", "string_code_check_cache_key", String.class);
            if (StringUtils.isNotBlank((CharSequence)data)) {
                orderList.addAll(JSONArray.parseArray((String)data, String.class));
            }
            orderList.add(orderNo);
            this.cacheService.setCache("string_code_check_cache_key", "string_code_check_cache_key", (Object)orderList);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.info("\u4e32\u7801\u6821\u9a8c\u5355\u53f7\u4fdd\u5b58\u7f13\u5b58\u6d88\u8d39\u5931\u8d25:{}", (Object)e.getMessage());
            e.printStackTrace();
            return MessageResponse.ERROR;
        }
    }
}

