/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.alibaba.excel.util.DateUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.app.open.biz.service.ILimitsService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.LimsQualityInfoPredictReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="syncReportInspectedEvent")
@Scope(value="prototype")
public class SyncReportInspectedEvent
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(SyncReportInspectedEvent.class);
    private static final String SYNC_REPORT_INSPECTED_START_TIME = "sync_report_inspected_start_time";
    @Value(value="${scheduler.client.syncStartTime:2021-01-01 00:00:00}")
    private String syncStartTime;
    @Value(value="${scheduler.client.aheadStartTime:-11}")
    private Integer aheadStartTime;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ILimitsService limitsService;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("\u3010-----------------------\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u5f85\u68c0\u62a5\u544a\u6570\u636e\u5f00\u59cb--------------\u3011");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        if (!this.cacheService.setIfAbsent("syncReportInspectedEvent", (Object)1, 1800).booleanValue()) {
            return true;
        }
        try {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u5f85\u68c0\u62a5\u544a\u6570\u636e\u5f00\u59cb");
            long startTime = System.currentTimeMillis();
            this.task(taskMsg.getContent());
            long endTime = System.currentTimeMillis();
            logger.info("SyncReportInspectedEvent\u3010\u52a1\u540c\u6b65\u5f85\u68c0\u62a5\u544a\u6570\u636e\u3011\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u5f85\u68c0\u62a5\u544a\u6570\u636e\u5f00\u59cb\u5f02\u5e38", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.cacheService.delCache("syncReportInspectedEvent");
        }
        return true;
    }

    private void task(String startDate) {
        String startTime = (String)this.cacheService.getCache(SYNC_REPORT_INSPECTED_START_TIME, String.class);
        if (StringUtils.isBlank((CharSequence)startTime)) {
            startTime = this.syncStartTime;
        }
        if (StringUtils.isNotBlank((CharSequence)startDate)) {
            startTime = startDate;
        }
        startTime = this.getLimitDate(startTime);
        LimsQualityInfoPredictReqDto reqDto = new LimsQualityInfoPredictReqDto();
        reqDto.setStartDate(startTime);
        String time = this.limitsService.syncReportInspectedForPsi(reqDto);
        if (StringUtils.isNotBlank((CharSequence)time)) {
            this.cacheService.setCache(SYNC_REPORT_INSPECTED_START_TIME, (Object)time);
        }
    }

    private String getLimitDate(String startTime) {
        try {
            Date date = DateUtils.parseDate((String)startTime, (String)"yyyy-MM-dd HH:mm:ss");
            Calendar instance = Calendar.getInstance();
            instance.setTime(date);
            instance.add(12, this.aheadStartTime);
            startTime = DateUtils.format((Date)instance.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
            return startTime;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return startTime;
        }
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u3010-----------------------\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u5f85\u68c0\u62a5\u544a\u6570\u636e\u7ed3\u675f--------------\u3011");
    }
}

