/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.WarehouseDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.google.common.base.Functions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SyncLogicWarehouseJob")
@Scope(value="prototype")
public class SyncLogicWarehouseJob
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SyncLogicWarehouseJob.class);
    @Resource
    private IExternalOutService externalOutService;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private ICsLogicWarehouseApi csLogicWarehouseApi;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("\u62c9\u53d6sap\u903b\u8f91\u4ed3\u4fe1\u606f\u5f00\u59cb......");
    }

    public boolean execute(TaskMsg taskMsg) {
        List<WarehouseDto> warehouseList = this.externalOutService.queryWarehouseList();
        List warehouseCodes = warehouseList.stream().map(WarehouseDto::getLgort).collect(Collectors.toList());
        List orgCodes = warehouseList.stream().map(WarehouseDto::getBukrs).collect(Collectors.toList());
        orgCodes.addAll(warehouseList.stream().map(WarehouseDto::getWerks).collect(Collectors.toList()));
        CsLogicWarehouseQueryDto queryDto = new CsLogicWarehouseQueryDto();
        queryDto.setWarehouseCodeList(warehouseCodes);
        List warehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseQueryApi.queryByParam(queryDto));
        logger.info("\u7269\u7406\u4ed3\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)warehouseRespDtoList));
        Map warehouseMap = warehouseRespDtoList.stream().collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, Functions.identity(), (n1, n2) -> n1));
        List orgDtoList = (List)this.organizationQueryExtApi.queryOrgDetailByThirdCode(orgCodes).getData();
        logger.info("\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)orgDtoList));
        Map orgListMap = null;
        if (CollectionUtils.isNotEmpty((Collection)orgDtoList)) {
            orgListMap = orgDtoList.stream().collect(Collectors.toMap(OrgAdvDetailRespDto::getThirdOrgId, Functions.identity(), (n1, n2) -> n1));
        }
        OrgAdvDetailRespDto orgDto = null;
        for (WarehouseDto dto : warehouseList) {
            OrgAdvDetailRespDto org = new OrgAdvDetailRespDto();
            OrgAdvDetailRespDto inventoryOrg = new OrgAdvDetailRespDto();
            try {
                CsLogicWarehouseRespDto warehouseRespDto = (CsLogicWarehouseRespDto)warehouseMap.get(dto.getLgort());
                if (orgListMap != null) {
                    orgDto = (OrgAdvDetailRespDto)orgListMap.get(dto.getWerks());
                    inventoryOrg = (OrgAdvDetailRespDto)orgListMap.get(dto.getBukrs());
                }
                if (!Objects.isNull(orgDto)) {
                    org = orgDto;
                }
                if (Objects.nonNull(warehouseRespDto)) {
                    if (StringUtils.isNotBlank((CharSequence)dto.getConfigdeprecationcode()) && warehouseRespDto.getWarehouseStatus().equals(dto.getConfigdeprecationcode()) && warehouseRespDto.getOrganizationCode().equals(dto.getBukrs()) && warehouseRespDto.getCargoEscheatageId().equals(dto.getWerks())) continue;
                    this.csLogicWarehouseApi.update(warehouseRespDto.getId(), this.getUpdateReqDto(dto, org, inventoryOrg));
                    continue;
                }
                this.csLogicWarehouseApi.add(this.getCreateReqDto(dto, org, inventoryOrg));
            }
            catch (Exception e) {
                logger.info("\u540c\u6b65\u4ed3\u5e93\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    private CsLogicWarehouseUpdateReqDto getUpdateReqDto(WarehouseDto dto, OrgAdvDetailRespDto org, OrgAdvDetailRespDto inventoryOrg) {
        CsLogicWarehouseUpdateReqDto warehouseUpdateReqDto = new CsLogicWarehouseUpdateReqDto();
        warehouseUpdateReqDto.setWarehouseName(dto.getLgobe());
        warehouseUpdateReqDto.setWarehouseStatus(dto.getConfigdeprecationcode());
        warehouseUpdateReqDto.setOrganizationName(inventoryOrg.getCompanyOrgName());
        warehouseUpdateReqDto.setOrganizationCode(inventoryOrg.getCompanyOrgCode());
        if (Objects.nonNull(inventoryOrg)) {
            warehouseUpdateReqDto.setOrganizationId(inventoryOrg.getId());
        }
        warehouseUpdateReqDto.setCargoEscheatageId(org.getCompanyOrgCode());
        warehouseUpdateReqDto.setCargoEscheatageName(org.getCompanyOrgName());
        logger.info("\u66f4\u65b0\u4ed3\u5e93\u5bf9\u8c61\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)warehouseUpdateReqDto));
        return warehouseUpdateReqDto;
    }

    private CsLogicWarehouseAddReqDto getCreateReqDto(WarehouseDto dto, OrgAdvDetailRespDto org, OrgAdvDetailRespDto inventoryOrg) {
        CsLogicWarehouseAddReqDto csLogicWarehouseAddReqDto = new CsLogicWarehouseAddReqDto();
        csLogicWarehouseAddReqDto.setWarehouseStatus("initial");
        csLogicWarehouseAddReqDto.setOrganizationName(inventoryOrg.getCompanyOrgName());
        csLogicWarehouseAddReqDto.setOrganizationCode(inventoryOrg.getCompanyOrgCode());
        if (Objects.nonNull(inventoryOrg)) {
            csLogicWarehouseAddReqDto.setOrganizationId(inventoryOrg.getId());
        }
        csLogicWarehouseAddReqDto.setWarehouseName(dto.getLgobe());
        csLogicWarehouseAddReqDto.setWarehouseCode(dto.getWerks());
        csLogicWarehouseAddReqDto.setCargoEscheatageId(org.getCompanyOrgCode());
        csLogicWarehouseAddReqDto.setCargoEscheatageName(org.getCompanyOrgName());
        csLogicWarehouseAddReqDto.setCreatePerson("MDM");
        csLogicWarehouseAddReqDto.setUpdatePerson("MDM");
        logger.info("\u65b0\u589e\u4ed3\u5e93\u5bf9\u8c61\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)csLogicWarehouseAddReqDto));
        return csLogicWarehouseAddReqDto;
    }
}

