/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.request.PcpSupplier;
import com.dtyunxi.tcbj.app.open.biz.enums.PcpSupplierColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.ICsInventorySupplierApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventorySupplierReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsInventorySupplierRespDto;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="SapCenterHandleSupplierServiceImpl")
public class SapCenterHandleSupplierServiceImpl
implements ISapCenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(SapCenterHandleSupplierServiceImpl.class);
    @Resource
    private ICsInventorySupplierApi csInventorySupplierApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.SUPPLIER.name();
    }

    @Override
    public void handle(Map<String, Object> reqDto) {
        logger.info("\u4f9b\u5e94\u5546\u6570\u636e\u5206\u53d1:{}", (Object)JSON.toJSONString(reqDto));
        long startTime = System.currentTimeMillis();
        String obj = JSONObject.toJSONString((Object)reqDto.get("HEADER"));
        JSONObject header = JSONObject.parseObject((String)obj);
        String aitemstr = JSONObject.toJSONString((Object)reqDto.get("AITEMS"));
        JSONArray aitems = JSONObject.parseArray((String)aitemstr);
        String bitemstr = JSONObject.toJSONString((Object)reqDto.get("BITEMS"));
        JSONArray bitems = JSONObject.parseArray((String)bitemstr);
        String citemstr = JSONObject.toJSONString((Object)reqDto.get("CITEMS"));
        JSONArray citems = JSONObject.parseArray((String)citemstr);
        String pitemstr = JSONObject.toJSONString((Object)reqDto.get("PITEMS"));
        JSONArray pitems = JSONObject.parseArray((String)pitemstr);
        ArrayList<PcpSupplier> pcpWarehousesList = new ArrayList<PcpSupplier>();
        PcpSupplier supplier = new PcpSupplier();
        supplier.setSupplierCode(header.getString("PARTNER"));
        supplier.setSupplierName(header.getString("NAME_ORG1"));
        supplier.setCreditCode(header.getString("IDNUMBER"));
        supplier.setSupplierUnit(header.getString("BU_SORT1"));
        supplier.setOldSupplierCode(header.getString("BU_SORT2"));
        supplier.setPostCode(aitems.getJSONObject(0).getString("POST_CODE1"));
        supplier.setPhoneNum(aitems.getJSONObject(0).getString("TEL_NUMBER"));
        supplier.setLegalName(aitems.getJSONObject(0).getString("NAME_CO"));
        supplier.setLinkman(aitems.getJSONObject(0).getString("NAME_CO"));
        supplier.setMobilePhone(aitems.getJSONObject(0).getString("MOB_NUMBER"));
        supplier.setProvinceCode(aitems.getJSONObject(0).getString("REGION"));
        supplier.setCityCode(aitems.getJSONObject(0).getString("CITY1"));
        supplier.setDistrictCode(aitems.getJSONObject(0).getString("CITY2"));
        supplier.setAddress(aitems.getJSONObject(0).getString("STREET"));
        if (pitems.size() > 0) {
            Object status = pitems.getJSONObject(0).get((Object)"SPERZ");
            if (status == null) {
                supplier.setStatus(1);
            }
        } else {
            supplier.setStatus(0);
        }
        pcpWarehousesList.add(supplier);
        List supplierCodeList = pcpWarehousesList.stream().map(PcpSupplier::getSupplierCode).collect(Collectors.toList());
        CsInventorySupplierReqDto csInventorySupplierReqDto = new CsInventorySupplierReqDto();
        csInventorySupplierReqDto.setSupplierCodeList(supplierCodeList);
        List csInventorySupplierRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csInventorySupplierApi.queryParam(csInventorySupplierReqDto));
        Map supplierMap = csInventorySupplierRespDtos.stream().collect(Collectors.toMap(CsInventorySupplierRespDto::getSupplierCode, Functions.identity(), (n1, n2) -> n1));
        for (PcpSupplier dto : pcpWarehousesList) {
            try {
                CsInventorySupplierRespDto supplierRespDto = (CsInventorySupplierRespDto)supplierMap.get(dto.getSupplierCode());
                if (Objects.nonNull(supplierRespDto)) {
                    CsInventorySupplierReqDto modifyReqDto = new CsInventorySupplierReqDto();
                    modifyReqDto.setId(supplierRespDto.getId());
                    modifyReqDto.setEasOrgCode(dto.getOrgCode());
                    CubeBeanUtils.copyProperties((Object)modifyReqDto, (Object)dto, (String[])new String[0]);
                    logger.info(JSON.toJSONString((Object)modifyReqDto));
                    this.csInventorySupplierApi.modifyCsInventorySupplier(modifyReqDto);
                    logger.info("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a" + modifyReqDto.getSupplierCode() + "\u66f4\u65b0\u6210\u529f");
                    continue;
                }
                CsInventorySupplierReqDto addReqDto = new CsInventorySupplierReqDto();
                CubeBeanUtils.copyProperties((Object)addReqDto, (Object)dto, (String[])new String[0]);
                logger.info(JSON.toJSONString((Object)addReqDto));
                this.csInventorySupplierApi.addCsInventorySupplier(addReqDto);
                logger.info("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a" + addReqDto.getSupplierCode() + "\u65b0\u589e\u6210\u529f");
            }
            catch (Exception e) {
                logger.info("\u540c\u6b65\u4f9b\u5e94\u5546\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u3010PCP\u4f9b\u5e94\u5546\u65b0\u589e\u540c\u6b65\u3011\u8017\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        logger.info("\u3010PCP\u4f9b\u5e94\u5546\u65b0\u589e\u540c\u6b65\u3011\u7ed3\u675f\u540c\u6b65--------->");
    }

    private String validaData(List<Map> dataMap) {
        if (dataMap == null || dataMap.size() <= 0) {
            return "\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (Map map : dataMap) {
            for (Object s : map.keySet()) {
                if (Objects.isNull(s)) {
                    return "\u540c\u6b65\u6570\u636e\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a";
                }
                PcpSupplierColumnEnum pcpSupplierColumnEnum = PcpSupplierColumnEnum.getByField(s.toString());
                if (pcpSupplierColumnEnum == null || pcpSupplierColumnEnum.validate(s.toString()).booleanValue()) continue;
                return String.format("%s\u4e0d\u80fd\u4e3a\u7a7a", pcpSupplierColumnEnum.getFieldName());
            }
        }
        return null;
    }
}

