/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.dto.request.SapMaterialInfoReqDto;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.UpdateItemDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapModelTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.IItemExtendApi;
import com.dtyunxi.yundt.cube.center.item.api.IPcpItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemSkuApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.query.IPcpItemQueryApi;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SapCenterHandleProductInfoServiceImpl
implements ISapCenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(SapCenterHandleProductInfoServiceImpl.class);
    @Resource
    private IItemApi iItemApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemSkuApi iItemSkuApi;
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource
    private IPcpItemApi pcpItemApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private IPcpItemQueryApi iPcpItemQueryApi;
    @Resource
    private IItemExtendQueryApi itemExtendQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IItemExtendQueryApi iItemExtendQueryApi;
    @Resource
    private IItemExtendApi itemExtendApi;
    @Autowired
    private IUnitQueryApi unitQueryApi;

    @Override
    public String getModelType() {
        return SapModelTypeEnum.MATERIAL.getValue();
    }

    @Override
    public void handle(Map<String, Object> map) {
        logger.info("sap-ocs \u4ea7\u54c1\u4fe1\u606f\u4e3b\u6570\u636e-\u6570\u636e\u5206\u53d1:{}", (Object)JSON.toJSONString(map));
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty(map), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-map \u4e3a\u7a7a!");
        SapMaterialInfoReqDto reqDto = this.productInfoPropertyConvert(map);
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)reqDto), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-reqDto \u4e3a\u7a7a!");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getCode()), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-MATNR \u7269\u6599\u7f16\u7801 \u4e3a\u7a7a!");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getName()), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-MAKTX  \u7269\u6599\u540d\u79f0 \u4e3a\u7a7a!");
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)reqDto.getOldLongCode()), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-BISMT \u65e7\u7f16\u7801 \u4e3a\u7a7a!");
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)reqDto.getMaterialType()), (String)"1000001", (String)"SAP\u6570\u636e\u540c\u6b65-MTART  \u7269\u6599\u7c7b\u578b\u4e3a\u7a7a!");
        if ("ZFIN".equals(reqDto.getMaterialType()) || "ZSFG".equals(reqDto.getMaterialType()) || "ZGEN".equals(reqDto.getMaterialType())) {
            Long itemId = this.sapSaveItem(reqDto);
            this.sapSaveItemSku(reqDto, itemId);
            this.broadcastToOtherSystems(reqDto);
        } else {
            logger.info("syncDataFormSap->syncDataFormSapProductInfo\u540c\u6b65\u5546\u54c1\u4fe1\u606f,\u7269\u6599\u7c7b\u578b\u975e ZFIN  ZSFG ZGEN  \u8df3\u8fc7\u3002\u3002\u3002\u540c\u6b65\u5546\u54c1\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr(map));
        }
    }

    private void broadcastToOtherSystems(SapMaterialInfoReqDto reqDto) {
        ArrayList<PcpItemRespDto> itemExtendRespDtoList = new ArrayList<PcpItemRespDto>();
        ArrayList<UpdateItemDto> updateItemDtoList = new ArrayList<UpdateItemDto>();
        UpdateItemDto updateItemDto = new UpdateItemDto();
        updateItemDto.setCode(reqDto.getCode());
        updateItemDto.setName(reqDto.getName());
        updateItemDtoList.add(updateItemDto);
        if (CollectionUtil.isNotEmpty(updateItemDtoList)) {
            MessageVo messageVo;
            ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
            List itemCodeList = updateItemDtoList.stream().map(UpdateItemDto::getCode).collect(Collectors.toList());
            itemExtendReqDto.setItemCodeList(itemCodeList);
            List csInventorySupplierRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(itemExtendReqDto));
            logger.info("SapCenterHandleProductInfoServiceImpl \u540c\u6b65\u5546\u54c1\u67e5\u8be2\u5230\u6570\u636e:{}", (Object)JSON.toJSONString((Object)csInventorySupplierRespDtos));
            for (ItemExtendRespDto dto : csInventorySupplierRespDtos) {
                if (dto.getId() == null) continue;
                PcpItemRespDto pcpItemRespDto = (PcpItemRespDto)RestResponseHelper.extractData((RestResponse)this.iPcpItemQueryApi.queryByPrimaryKey(dto.getId()));
                itemExtendRespDtoList.add(pcpItemRespDto);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemExtendRespDtoList)) {
                messageVo = new MessageVo();
                messageVo.setData((Object)JSON.toJSONString(itemExtendRespDtoList));
                this.commonsMqService.sendSingleMessage("PRODUCT_INFORMATION_RECEIVING_LOG", (Object)messageVo);
            }
            logger.info("\u5e7f\u64ad\u540c\u6b65\u5546\u54c1\u6d88\u606f\uff0c\u4f9b\u5176\u4ed6\u4e2d\u5fc3\u66f4\u65b0\u5546\u54c1\u540d\u79f0\u7b49\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(updateItemDtoList));
            try {
                messageVo = new MessageVo();
                messageVo.setData((Object)JSON.toJSONString(updateItemDtoList));
                this.commonsMqService.publishMessage("PCP_PUBLIC_SYNC_ITEM", (Object)messageVo);
            }
            catch (Exception e) {
                logger.error("\u5e7f\u64ad\u540c\u6b65\u5546\u54c1\u6d88\u606f\uff0c\u4f9b\u5176\u4ed6\u4e2d\u5fc3\u66f4\u65b0\u5546\u54c1\u540d\u79f0\u7b49\u4fe1\u606f\u5f02\u5e38");
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sapSaveItemSku(SapMaterialInfoReqDto reqDto, Long itemId) {
        ItemBundleReqDto itemBundleReqDto = new ItemBundleReqDto();
        List skuRespDtos = (List)this.iItemSkuQueryApi.queryBySkuCode((List)Lists.newArrayList((Object[])new String[]{reqDto.getCode()})).getData();
        logger.info("SapCenterHandleProductInfoServiceImpl \u67e5\u8be2\u5546\u54c1sku\u4fe1\u606f:{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)skuRespDtos));
        if (CollectionUtil.isNotEmpty((Collection)skuRespDtos)) {
            UnitRespDto unitRespDto;
            logger.info("SapCenterHandleProductInfoServiceImpl \u5546\u54c1sku\u5df2\u5b58\u5728\uff01code:{}", (Object)reqDto.getCode());
            ItemSkuRespDto itemSkuRespDto = (ItemSkuRespDto)skuRespDtos.get(0);
            BeanUtils.copyProperties((Object)itemSkuRespDto, (Object)itemBundleReqDto);
            itemBundleReqDto.setBarCode(StringUtils.isEmpty((CharSequence)reqDto.getBarcode()) ? null : reqDto.getBarcode());
            itemBundleReqDto.setName(reqDto.getName());
            itemBundleReqDto.setId(itemSkuRespDto.getId());
            String unitCode = reqDto.getUnitCode();
            String unitName = reqDto.getUnitName();
            itemBundleReqDto.setAttr("{\"\u9ed8\u8ba4\":\"" + unitName + "\"}");
            if (StringUtils.isNotBlank((CharSequence)unitCode) && ObjectUtil.isNotEmpty((Object)(unitRespDto = (UnitRespDto)this.unitQueryApi.queryByCode(unitCode).getData()))) {
                itemBundleReqDto.setUnit(unitRespDto.getId().toString());
            }
            ArrayList bundleReqDtos = Lists.newArrayList();
            bundleReqDtos.add(itemBundleReqDto);
            this.iItemSkuApi.modifyItemSku((List)bundleReqDtos);
        } else {
            UnitRespDto unitRespDto;
            itemBundleReqDto.setItemId(itemId);
            itemBundleReqDto.setBarCode(StringUtils.isEmpty((CharSequence)reqDto.getBarcode()) ? null : reqDto.getBarcode());
            itemBundleReqDto.setVolumeUnit(StringUtils.isEmpty((CharSequence)reqDto.getVolumeUnit()) ? null : reqDto.getVolumeUnit());
            itemBundleReqDto.setGrossWeight(StringUtils.isEmpty((CharSequence)reqDto.getNetWeight()) ? null : BigDecimal.valueOf(Double.parseDouble(reqDto.getNetWeight())));
            String unitCode = reqDto.getUnitCode();
            String unitName = reqDto.getUnitName();
            itemBundleReqDto.setAttr("{\"\u9ed8\u8ba4\":\"" + unitName + "\"}");
            if (StringUtils.isNotBlank((CharSequence)unitCode) && ObjectUtil.isNotEmpty((Object)(unitRespDto = (UnitRespDto)this.unitQueryApi.queryByCode(unitCode).getData()))) {
                itemBundleReqDto.setUnit(unitRespDto.getId().toString());
            }
            itemBundleReqDto.setName(reqDto.getName());
            itemBundleReqDto.setMinPackage(Integer.valueOf(1));
            itemBundleReqDto.setCargoCode(reqDto.getCode());
            itemBundleReqDto.setCode(reqDto.getCode());
            itemBundleReqDto.setCreatePerson("SAP");
            itemBundleReqDto.setTenantId(this.requestBaseData.getTenantId());
            itemBundleReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("SapCenterHandleProductInfoServiceImpl =================> \u65b0\u589e\u5546\u54c1sku\u5165\u53c2 : {}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)itemBundleReqDto));
            ArrayList prices = Lists.newArrayList();
            ItemPriceReqDto itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u5212\u7ebf\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            itemPriceReqDto.setPrice(new BigDecimal(99999.9));
            itemPriceReqDto.setPriceType("PRICE");
            prices.add(itemPriceReqDto);
            itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u552e\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            itemPriceReqDto.setPrice(new BigDecimal(99999.9));
            itemPriceReqDto.setPriceType("RETAIL_PRICE");
            prices.add(itemPriceReqDto);
            itemBundleReqDto.setPrices((List)prices);
            this.iItemSkuApi.addItemSku((List)Lists.newArrayList((Object[])new ItemBundleReqDto[]{itemBundleReqDto}));
        }
    }

    private SapMaterialInfoReqDto productInfoPropertyConvert(Map map) {
        SapMaterialInfoReqDto reqDto = new SapMaterialInfoReqDto();
        if (ObjectUtil.isNotEmpty((Object)map)) {
            JSONObject parsedObj = JSONUtil.parseObj((String)JSONUtil.toJsonStr((Object)map.get("HEADER").toString()));
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"BISMT"))) {
                reqDto.setOldLongCode(parsedObj.get((Object)"BISMT").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"MATNR"))) {
                reqDto.setCode(parsedObj.get((Object)"MATNR").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"MAKTX"))) {
                reqDto.setName(parsedObj.get((Object)"MAKTX").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"ZBRAND"))) {
                reqDto.setBrand(parsedObj.get((Object)"ZBRAND").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"MSTAE"))) {
                reqDto.setStatus(parsedObj.get((Object)"MSTAE").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"ZPRD_TYPE"))) {
                reqDto.setType(parsedObj.get((Object)"ZPRD_TYPE").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"MTART"))) {
                reqDto.setMaterialType(parsedObj.get((Object)"MTART").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"ZDOS_FORM"))) {
                reqDto.setDosageForm(parsedObj.get((Object)"ZDOS_FORM").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"ZBARCODE"))) {
                reqDto.setBarcode(parsedObj.get((Object)"ZBARCODE").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"MEINS"))) {
                reqDto.setUnitCode(parsedObj.get((Object)"MEINS").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"MSEHL"))) {
                reqDto.setUnitName(parsedObj.get((Object)"MSEHL").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"ZMIN_VOL"))) {
                reqDto.setVolumeUnit(parsedObj.get((Object)"ZMIN_VOL").toString());
            }
            if (ObjectUtil.isNotEmpty((Object)parsedObj.get((Object)"ZMIN_WGT"))) {
                reqDto.setNetWeight(parsedObj.get((Object)"ZMIN_WGT").toString());
            }
        }
        return reqDto;
    }

    private Long sapSaveItem(SapMaterialInfoReqDto reqDto) {
        Long itemId = null;
        List itemRespDtoList = (List)this.itemQueryApi.queryByItemLongCodes((List)Lists.newArrayList((Object[])new String[]{reqDto.getCode()})).getData();
        if (CollectionUtils.isNotEmpty((Collection)itemRespDtoList)) {
            ItemReqDto itemReqDto = new ItemReqDto();
            Long id = ((ItemRespDto)itemRespDtoList.get(0)).getId();
            itemReqDto.setName(reqDto.getName());
            itemReqDto.setId(id);
            itemReqDto.setUpdatePerson("SAP");
            this.iItemApi.modifyItem(itemReqDto);
            PcpItemReqDto pcpItemReqDto = new PcpItemReqDto();
            pcpItemReqDto.setLongCode(reqDto.getCode());
            this.pcpItemApi.modifyPcpItem(pcpItemReqDto);
        } else {
            ItemChangeApplyDto changApply = new ItemChangeApplyDto();
            BrandRespDto brandRespDto = (BrandRespDto)this.brandQueryApi.queryCode(reqDto.getBrand()).getData();
            if (ObjectUtils.isNotEmpty((Object)brandRespDto)) {
                changApply.setBrandId(brandRespDto.getId());
            }
            changApply.setBrand(reqDto.getBrand());
            changApply.setStatus(Integer.valueOf(2));
            changApply.setItemCode(reqDto.getCode());
            changApply.setLongCode(reqDto.getCode());
            changApply.setOldLongCode(reqDto.getOldLongCode());
            changApply.setItemName(reqDto.getName());
            changApply.setDisplayName(reqDto.getName());
            changApply.setDirId(Long.valueOf(1288630386802423099L));
            changApply.setDirName("\u9ed8\u8ba4\u7c7b\u76ee");
            changApply.setLongCode(reqDto.getCode());
            changApply.setType(Integer.valueOf(1));
            if (StringUtils.isNotBlank((CharSequence)reqDto.getMaterialType())) {
                if ("ZFIN".equals(reqDto.getMaterialType())) {
                    changApply.setSubType(Integer.valueOf(1));
                }
                if ("ZSFG".equals(reqDto.getMaterialType())) {
                    changApply.setSubType(Integer.valueOf(4));
                }
                if ("ZGEN".equals(reqDto.getMaterialType())) {
                    changApply.setSubType(Integer.valueOf(3));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqDto.getType()) && ("14".equals(reqDto.getType()) || "15".equals(reqDto.getType()))) {
                changApply.setSubType(Integer.valueOf(2));
            }
            changApply.setSellerId(Long.valueOf(0L));
            changApply.setCreatePerson("SAP");
            changApply.setUpdatePerson("SAP");
            changApply.setDosageForm(reqDto.getDosageForm());
            changApply.setTenantId(this.requestBaseData.getTenantId());
            changApply.setInstanceId(this.requestBaseData.getInstanceId());
            itemId = (Long)this.iItemApi.addItem(changApply).getData();
        }
        return itemId;
    }
}

