/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapModelTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.IEasCostOrgApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EasCostOrgReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCostOrgRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEasCostOrgQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapCenterHandleCostOrgServiceImpl
implements ISapCenterHandleService {
    private static final Logger logger = LoggerFactory.getLogger(SapCenterHandleCostOrgServiceImpl.class);
    @Resource
    private IEasCostOrgQueryApi easCostOrgQueryApi;
    @Resource
    private IEasCostOrgApi easCostOrgApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private RequestBaseData requestBaseData;
    private static final Long DEFAULT_ORG_PARENT_ID = 1252411810853067012L;

    @Override
    public String getModelType() {
        return SapModelTypeEnum.COSTORG.getValue();
    }

    @Override
    public void handle(Map<String, Object> reqDto) {
        logger.info("\u8d22\u52a1\u7ec4\u7ec7\u540c\u6b65\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString(reqDto));
        String orgCode = (String)reqDto.get("orgCode");
        String orgName = (String)reqDto.get("orgName");
        this.addCostOrg(orgCode, orgName);
        this.addSalesOrg(orgCode, orgName);
    }

    private long addCostOrg(String orgCode, String orgName) {
        logger.info("addCostOrg {} {}", (Object)orgCode, (Object)orgName);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(orgCode);
        List list = (List)RestResponseHelper.extractData((RestResponse)this.easCostOrgQueryApi.queryListCodes(codes));
        if (list == null || list.isEmpty()) {
            EasCostOrgReqDto costOrgReqDto = new EasCostOrgReqDto();
            costOrgReqDto.setEasId(orgCode);
            costOrgReqDto.setEasOrgCode(orgCode);
            costOrgReqDto.setOrgName(orgName);
            costOrgReqDto.setOrgType("\u516c\u53f8");
            costOrgReqDto.setCostCenter("1");
            costOrgReqDto.setOrgStatus("0");
            return (Long)RestResponseHelper.extractData((RestResponse)this.easCostOrgApi.addEasCostOrg(costOrgReqDto));
        }
        return ((EasCostOrgRespDto)list.get(0)).getId();
    }

    private Long addSalesOrg(String orgCode, String orgName) {
        logger.info("addSalesOrg {} {}", (Object)orgCode, (Object)orgName);
        OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
        orgAdvQueryReqDto.setCode(orgCode);
        OrganizationDto organization = (OrganizationDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOneByOrgCode(null, orgCode));
        if (organization == null) {
            OrgAdvAddReqDto orgAdvAddReqDto = new OrgAdvAddReqDto();
            orgAdvAddReqDto.setCode(orgCode);
            orgAdvAddReqDto.setName(orgName);
            orgAdvAddReqDto.setType("2");
            orgAdvAddReqDto.setTenantId(this.requestBaseData.getTenantId());
            orgAdvAddReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            orgAdvAddReqDto.setParentId(DEFAULT_ORG_PARENT_ID);
            return ((OrgAdvOpRespDto)this.organizationExtApi.add(orgAdvAddReqDto).getData()).getOrgId();
        }
        return organization.getId();
    }
}

