/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalDataService;
import com.dtyunxi.tcbj.app.open.biz.utils.AddressResolutionUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.yyj.YyjOrderReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpOrderApi;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderPcpExtendReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformExceptionCode;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpDictQueryApi;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpRegionQueryApi;
import com.yunxi.dg.base.center.basicdata.dto.request.PcpRegionReqDto;
import com.yunxi.dg.base.center.basicdata.dto.response.PcpRegionRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class ExternalDataServiceImpl
implements IExternalDataService {
    private static final Logger log = LoggerFactory.getLogger(ExternalDataServiceImpl.class);
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;
    @Autowired
    private IPcpOrderApi pcpOrderApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IPcpDictQueryApi pcpDictApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseApi;
    @Value(value="${yundt.com.default.warehouseCode:true}")
    private Boolean isDefaultShareWarehouseCode;

    @Override
    public Map<String, PcpRegionRespDto> queryAndCheckOrderAddressInfo(Map<String, Object> dto) {
        PlatformOrderAddrReqDto orderAddrDto = new PlatformOrderAddrReqDto();
        Object addrReqDto = dto.get("platformOrderAddrReqDto");
        BeanUtil.copyProperties((Object)addrReqDto, (Object)orderAddrDto, (String[])new String[0]);
        String cityCode = orderAddrDto.getCityCode();
        String provinceCode = orderAddrDto.getProvinceCode();
        String countyCode = orderAddrDto.getCountyCode();
        HashMap<String, PcpRegionRespDto> pcpRegionRespDtoMap = new HashMap<String, PcpRegionRespDto>();
        PcpRegionRespDto provinceAreaDto = null;
        if (StringUtils.isNotEmpty((CharSequence)provinceCode)) {
            provinceAreaDto = (PcpRegionRespDto)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByCode(provinceCode));
            if (provinceAreaDto == null) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_NULL.buildBizException(new Object[]{"\u7701", provinceCode});
            }
            pcpRegionRespDtoMap.put(provinceCode, provinceAreaDto);
        }
        PcpRegionRespDto countryAreaDto = null;
        if (StringUtils.isNotBlank((CharSequence)countyCode)) {
            countryAreaDto = (PcpRegionRespDto)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByCode(countyCode));
            if (countryAreaDto == null) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_NULL.buildBizException(new Object[]{"\u533a", countyCode});
            }
            pcpRegionRespDtoMap.put(countyCode, countryAreaDto);
        }
        if (StringUtils.isNotEmpty((CharSequence)cityCode)) {
            PcpRegionRespDto cityAreaDto = (PcpRegionRespDto)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByCode(cityCode));
            if (cityAreaDto == null) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_NULL.buildBizException(new Object[]{"\u5e02", cityCode});
            }
            pcpRegionRespDtoMap.put(cityCode, cityAreaDto);
            if (StringUtils.isBlank((CharSequence)cityAreaDto.getParentCode())) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_WRONG_0.buildBizException(new Object[]{cityAreaDto.getCode()});
            }
            if (Objects.nonNull(countryAreaDto) && StringUtils.isBlank((CharSequence)countryAreaDto.getParentCode())) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_WRONG_0.buildBizException(new Object[]{countryAreaDto.getCode()});
            }
            if (Objects.nonNull(countryAreaDto) && !countryAreaDto.getParentCode().equals(cityAreaDto.getCode())) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_WRONG_1.buildBizException(new Object[]{countryAreaDto.getCode(), cityAreaDto.getCode()});
            }
            if (!cityAreaDto.getParentCode().equals(provinceAreaDto.getCode())) {
                throw PlatformExceptionCode.QUERY_ORDER_INFO_ADDRESS_CODE_WRONG_1.buildBizException(new Object[]{cityAreaDto.getCode(), provinceAreaDto.getCode()});
            }
        }
        return pcpRegionRespDtoMap;
    }

    @Override
    public void queryAndCheckAddressNameInfo(Map<String, Object> dto) {
        PlatformOrderAddrReqDto orderAddrDto = new PlatformOrderAddrReqDto();
        Object addrReqDto = dto.get("platformOrderAddrReqDto");
        if (Objects.isNull(addrReqDto)) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        BeanUtil.copyProperties((Object)addrReqDto, (Object)orderAddrDto, (String[])new String[0]);
        String receiveAddress = orderAddrDto.getReceiveAddress();
        if (StringUtils.isEmpty((CharSequence)receiveAddress)) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5730\u5740\u8be6\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        List<Map<String, String>> addressResolutionList = AddressResolutionUtil.addressResolution(receiveAddress);
        if (CollectionUtils.isEmpty(addressResolutionList)) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5730\u5740\u8be6\u7ec6\u4fe1\u606f\u89e3\u6790\u5f02\u5e38"});
        }
        Map<String, String> addrMap = addressResolutionList.get(0);
        String province = addrMap.get("province");
        String city = addrMap.get("city");
        String county = addrMap.get("county");
        ArrayList addressList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)province)) {
            addressList.add(province);
        }
        if (StringUtils.isNotEmpty((CharSequence)city)) {
            addressList.add(city);
        }
        if (StringUtils.isNotEmpty((CharSequence)county)) {
            addressList.add(county);
        }
        if (CollectionUtils.isEmpty((Collection)addressList)) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5730\u5740\u8be6\u7ec6\u4fe1\u606f\u7701\u5e02\u533a\u7f3a\u5931"});
        }
        PcpRegionReqDto pcpRegionReqDto = new PcpRegionReqDto();
        pcpRegionReqDto.setNameList((List)addressList);
        log.info("\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)pcpRegionReqDto));
        List addressAreaList = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto));
        if (CollectionUtils.isEmpty((Collection)addressAreaList)) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5730\u5740\u8be6\u7ec6\u4fe1\u606f\u7701\u5e02\u533aPCP\u7cfb\u7edf\u4e0d\u5b58\u5728"});
        }
        log.info("\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)addressAreaList));
        Map<String, List<PcpRegionRespDto>> addressMap = addressAreaList.stream().collect(Collectors.groupingBy(PcpRegionRespDto::getName));
        if (CollectionUtils.isEmpty((Collection)addressMap.get(province)) || addressMap.get(province).size() > 1) {
            throw new BizException("-1", "\u7701\u4efd\u5339\u914d\u6709\u8bef\uff1a" + province);
        }
        orderAddrDto.setProvinceCode(addressMap.get(province).get(0).getCode());
        if (CollectionUtils.isEmpty((Collection)addressMap.get(city))) {
            throw new BizException("-1", "\u5e02\u5339\u914d\u6709\u8bef\uff1a" + city);
        }
        List cityList = addressMap.get(city).stream().filter(f -> f.getParentCode().equals(orderAddrDto.getProvinceCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cityList) || cityList.size() > 1) {
            throw new BizException("-1", "\u5e02\u5339\u914d\u5b58\u5728\u591a\u4e2a\uff1a" + city);
        }
        orderAddrDto.setCityCode(((PcpRegionRespDto)cityList.get(0)).getCode());
        List countyList = addressMap.get(county).stream().filter(f -> f.getParentCode().equals(orderAddrDto.getCityCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(countyList) || countyList.size() > 1) {
            throw new BizException("-1", "\u533a\u5339\u914d\u6709\u8bef\uff1a" + county);
        }
        PcpRegionRespDto countyDto = (PcpRegionRespDto)countyList.get(0);
        orderAddrDto.setCountyCode(countyDto.getCode());
        dto.put("platformOrderAddrReqDto", orderAddrDto);
    }

    @Override
    public void setAddressCountyName(Map<String, Object> dto) {
        PlatformOrderAddrReqDto orderAddrDto = new PlatformOrderAddrReqDto();
        Object addrReqDto = dto.get("platformOrderAddrReqDto");
        BeanUtil.copyProperties((Object)addrReqDto, (Object)orderAddrDto, (String[])new String[0]);
        if (StringUtils.isNotEmpty((CharSequence)orderAddrDto.getCounty())) {
            return;
        }
        String province = orderAddrDto.getProvince();
        String city = orderAddrDto.getCity();
        String county = orderAddrDto.getCounty();
        ArrayList addressList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)province)) {
            addressList.add(province);
        }
        if (StringUtils.isNotEmpty((CharSequence)city)) {
            addressList.add(city);
        }
        PcpRegionReqDto pcpRegionReqDto = new PcpRegionReqDto();
        pcpRegionReqDto.setNameList((List)addressList);
        log.info("\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)pcpRegionReqDto));
        List addressAreaList = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto));
        if (CollectionUtils.isEmpty((Collection)addressAreaList)) {
            log.info("\u5730\u5740\u4fe1\u606f\u7701\u5e02PCP\u7cfb\u7edf\u4e0d\u5b58\u5728");
            return;
        }
        Map<String, String> addressMap = addressAreaList.stream().collect(Collectors.toMap(PcpRegionRespDto::getName, PcpRegionRespDto::getCode, (k1, k2) -> k1));
        String cityCode = addressMap.get(city);
        pcpRegionReqDto = new PcpRegionReqDto();
        pcpRegionReqDto.setParentCode(cityCode);
        log.info("\u67e5\u8be2\u533a\u57df\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)pcpRegionReqDto));
        List countyAddressAreaList = (List)RestResponseHelper.extractData((RestResponse)this.pcpRegionQueryApi.queryByList(pcpRegionReqDto));
        if (CollectionUtils.isEmpty((Collection)countyAddressAreaList)) {
            log.info("\u5e02\u7ea7\u522b\u4e0b\u533a\u4fe1\u606fPCP\u7cfb\u7edf\u4e0d\u5b58\u5728");
            return;
        }
        log.info("\u5e02\u7ea7\u522b\u4e0b\u533a\u4fe1\u606f={}", JSON.toJSON((Object)countyAddressAreaList));
        String receiveAddress = orderAddrDto.getReceiveAddress();
        for (PcpRegionRespDto countyDto : countyAddressAreaList) {
            if (!StringUtils.isNotEmpty((CharSequence)receiveAddress) || Objects.isNull(countyDto.getName()) || Objects.isNull(countyDto.getCode()) || !receiveAddress.contains(countyDto.getName()) || addressMap.containsValue(countyDto.getCode())) continue;
            county = countyDto.getName();
            break;
        }
        orderAddrDto.setCounty(county);
        dto.put("platformOrderAddrReqDto", orderAddrDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addYyjPcpOrderProcess(List<YyjOrderReqDto> yyjOrderReqDtos) {
        List organizationDtoList;
        log.info("\u8fdb\u5165\u5904\u7406\u8425\u517b\u5bb6\u8ba2\u5355\uff0c\u6761\u6570\uff1a{}\uff0cyyjOrderReqDtos\uff1a{}", (Object)yyjOrderReqDtos.size(), (Object)JSONObject.toJSONString(yyjOrderReqDtos));
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        List<String> customerCodes = yyjOrderReqDtos.stream().filter(order -> StringUtils.isNotEmpty((CharSequence)order.getEasCustomerCode())).map(order -> order.getEasCustomerCode()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customerCodes)) {
            customerRespDtoMap = this.checkCustomer(customerCodes);
        }
        Map<Object, Object> orgInfoMap = new HashMap();
        List easOrgIdList = yyjOrderReqDtos.stream().filter(order -> StringUtils.isNotEmpty((CharSequence)order.getEasOrgId())).map(order -> order.getEasOrgId()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(easOrgIdList) && CollectionUtils.isNotEmpty((Collection)(organizationDtoList = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgDetailByThirdCode(easOrgIdList))))) {
            orgInfoMap = organizationDtoList.stream().collect(Collectors.toMap(OrgAdvDetailRespDto::getThirdOrgId, Function.identity(), (k1, k2) -> k1));
        }
        final ArrayList pcpOrderReqDtos = Lists.newArrayList();
        for (YyjOrderReqDto orderReqDto : yyjOrderReqDtos) {
            if (StringUtils.isBlank((CharSequence)orderReqDto.getThirdOrgId())) {
                orderReqDto.setThirdOrgId(orderReqDto.getEasOrgId());
            }
            log.info("\u8fdb\u5165\u5904\u7406\u8425\u517b\u5bb6\u8ba2\u5355info:{}", (Object)JSONObject.toJSONString((Object)orderReqDto));
            PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
            BeanUtil.copyProperties((Object)orderReqDto, (Object)pcpOrderReqDto, (String[])new String[0]);
            if (this.isYyjParentOrder(pcpOrderReqDto)) {
                pcpOrderReqDto.setPlatformOrderStatus(PlatformOrderStatusEnum.SUBMIT.getCode());
            }
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(orderReqDto.getEasCustomerCode());
            OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)orgInfoMap.get(orderReqDto.getEasOrgId());
            log.debug("\u3010\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f\u3011organizationDto={}", (Object)JSON.toJSONString((Object)orgAdvDetailRespDto));
            if (Objects.nonNull(orgAdvDetailRespDto)) {
                pcpOrderReqDto.setOrganizationId(orgAdvDetailRespDto.getId());
                pcpOrderReqDto.setOrganizationCode(orgAdvDetailRespDto.getCode());
                pcpOrderReqDto.setOrganizationName(orgAdvDetailRespDto.getName());
            }
            pcpOrderReqDto.setCustomerId(customerRespDto.getId());
            pcpOrderReqDto.setThirdOrgID(orderReqDto.getThirdOrgId());
            pcpOrderReqDto.setEasOrgId(orderReqDto.getEasOrgId());
            pcpOrderReqDto.setThirdPartyId(orderReqDto.getCustomerCode());
            pcpOrderReqDto.setCustomerCode(customerRespDto.getCode());
            pcpOrderReqDto.setCustomerName(customerRespDto.getName());
            String msgStr = JSON.toJSONString((Object)orderReqDto);
            PlatformOrderPcpExtendReqDto orderExt = new PlatformOrderPcpExtendReqDto();
            BeanUtil.copyProperties((Object)orderReqDto, (Object)orderExt, (String[])new String[0]);
            orderExt.setCspExtendJson(msgStr);
            PlatformOrderAddrReqDto orderAddrDto = orderReqDto.getPlatformOrderAddrReqDto();
            List itemList = orderReqDto.getItemReqDtoList().stream().map(items -> {
                PlatformOrderItemReqDto dto = new PlatformOrderItemReqDto();
                BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
                dto.setCspItemExtendJson(JSON.toJSONString((Object)items));
                if (Objects.isNull(dto.getPrice())) {
                    dto.setPrice(dto.getSaleUnitPrice());
                }
                return dto;
            }).collect(Collectors.toList());
            pcpOrderReqDto.setPlatformOrderPcpExtendReqDto(orderExt);
            pcpOrderReqDto.setPlatformOrderAddrReqDto(orderAddrDto);
            pcpOrderReqDto.setItemReqDtoList(itemList);
            if (orderReqDto.getChildOrderNum() != null) {
                pcpOrderReqDto.getExtFields().put("childOrderNum", orderReqDto.getChildOrderNum());
            }
            if (this.isDefaultShareWarehouseCode.booleanValue()) {
                DictDto dictDto = (DictDto)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", "YYJ_VIRTUAL_WAREHOUSE").getData();
                log.info("\u83b7\u53d6\u8425\u517b\u5bb6\u7ec4\u7ec7\u5bf9\u5e94\u4f9b\u8d27\u4ed3:{}", (Object)JSON.toJSONString((Object)dictDto));
                if (Objects.nonNull(dictDto)) {
                    Map map = (Map)JSON.parseObject((String)dictDto.getValue(), Map.class);
                    if (StringUtils.isNotBlank((CharSequence)orderReqDto.getEasOrgId()) && map.containsKey(String.valueOf(orderReqDto.getEasOrgId()))) {
                        pcpOrderReqDto.setStoragePlace((String)map.get(orderReqDto.getEasOrgId()));
                    }
                }
            }
            pcpOrderReqDtos.add(pcpOrderReqDto);
        }
        final String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                CompletableFuture.runAsync(() -> {
                    MDC.put((String)"yes.req.requestId", (String)reqId);
                    log.info("\u5f02\u6b65\u5904\u7406\u8425\u517b\u5bb6\u6e20\u9053\u5355");
                    ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                    try {
                        if (StringUtils.isNotEmpty((CharSequence)((PcpOrderReqDto)pcpOrderReqDtos.get(0)).getPlatformParentOrderNo())) {
                            Thread.sleep(10000L);
                        }
                        log.info("\u65b0\u589e\u8425\u517b\u5bb6\u6e20\u9053\u5355pcpOrderReqDtos:{}", (Object)JSONObject.toJSONString((Object)pcpOrderReqDtos));
                        RestResponseHelper.extractData((RestResponse)ExternalDataServiceImpl.this.pcpOrderApi.addPcpYyjOrderProcess(pcpOrderReqDtos));
                    }
                    catch (Exception e) {
                        log.info("\u5f02\u6b65\u5904\u7406\u8425\u517b\u5bb6\u6e20\u9053\u5355\u5f02\u5e38:{}", (Object)e.getMessage());
                        log.error("{},{}", (Object)e.getMessage(), (Object)e);
                    }
                });
            }
        });
    }

    private Map<String, CustomerRespDto> checkCustomer(List<String> thirdPartyId) {
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(thirdPartyId));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u83b7\u53d6\u4e0d\u5230" + thirdPartyId + "\u7684\u5ba2\u6237\u4fe1\u606f"});
        }
        Map<String, CustomerRespDto> customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity()));
        for (String customerCode : thirdPartyId) {
            CustomerRespDto customerRespDto = customerRespDtoMap.get(customerCode);
            log.info("\u3010\u83b7\u53d6\u5230\u5ba2\u6237\u4fe1\u606f\u3011customerRespDto={}", (Object)JSON.toJSONString((Object)customerRespDto));
        }
        return customerRespDtoMap;
    }

    private boolean isYyjParentOrder(PcpOrderReqDto pcpOrderReqDto) {
        return StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformParentOrderNo());
    }

    @Override
    public void checkChannelWarehouse(Map<String, Object> dtoMap) {
        if (!dtoMap.containsKey("channelWarehouseCode")) {
            return;
        }
        String channelWarehouse = (String)dtoMap.get("channelWarehouseCode");
        ChannelWarehouseRespDto channelWarehouseRespDto = (ChannelWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.channelWarehouseApi.queryByWarehouseCode(channelWarehouse));
        if (Objects.isNull(channelWarehouseRespDto)) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u6e20\u9053\u4ed3:" + channelWarehouse + "\u4fe1\u606f\u4e0d\u5b58\u5728"});
        }
        if (!Objects.equals(channelWarehouseRespDto.getWarehouseStatus(), CsValidFlagEnum.ENABLE.getCode())) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u6e20\u9053\u4ed3:" + channelWarehouse + "\u672a\u542f\u7528"});
        }
    }
}

