/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.tcbj.app.open.biz.enums.CustomerMaterialRelEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.DictColumnEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.util.RandomCodeUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.api.IPcpRegionApi;
import com.yunxi.dg.base.center.basicdata.dto.request.PcpRegionReqDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="centerHandleDictImpl")
public class CenterHandleDictImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleDictImpl.class);
    @Resource
    private IPcpRegionApi pcpRegionApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.DIC_D011.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u884c\u653f\u533a\u57df\u6570\u636e\u540c\u6b65\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)modelInfoReqDto));
        List list = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        ArrayList<DataDistributeRespDto> responseList = new ArrayList<DataDistributeRespDto>();
        ArrayList pcpRegionReqDtos = Lists.newArrayList();
        for (Map map : list) {
            try {
                PcpRegionReqDto pcpRegionReqDto = new PcpRegionReqDto();
                String code = (String)map.get(DictColumnEnum.CODE.name());
                pcpRegionReqDto.setCode(code);
                pcpRegionReqDto.setParentCode((String)map.get(DictColumnEnum.PCODE.name()));
                pcpRegionReqDto.setName((String)map.get(DictColumnEnum.NAME.name()));
                pcpRegionReqDto.setLevelId(this.getLevelIdByCode(code));
                responseList.add(this.dataResp(map.get(DictColumnEnum.CIDP_TASK_UUID.name()) == null ? RandomCodeUtil.generateTextCode((int)10, (int)0) : (String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.SUCCESS.getCode(), DataDistributeRespEnum.SUCCESS.getValue()));
            }
            catch (Exception e) {
                logger.info("\u7701\u5e02\u533a\u6570\u636e\u5904\u7406\u5f02\u5e38:{}  [{}]", (Object)map, (Object)e);
                e.printStackTrace();
                responseList.add(this.dataResp(map.get(DictColumnEnum.CIDP_TASK_UUID.name()) == null ? RandomCodeUtil.generateTextCode((int)10, (int)0) : (String)map.get(CustomerMaterialRelEnum.CIDP_TASK_UUID.name()), DataDistributeRespEnum.FAILURE.getCode(), e.getMessage()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)pcpRegionReqDtos)) {
            this.pcpRegionApi.batchOperation((List)pcpRegionReqDtos);
        }
        logger.info("\u884c\u653f\u533a\u57df\u6570\u636e\u540c\u6b65\u7ed3\u675f:{}", (Object)JSONObject.toJSONString(responseList));
        return responseList;
    }

    private Integer getLevelIdByCode(String code) {
        if (code.length() == 2) {
            return 0;
        }
        if (code.length() == 4) {
            return 1;
        }
        return 2;
    }

    private DataDistributeRespDto dataResp(String taskId, String type, String reason) {
        DataDistributeRespDto dataDistributeRespDto = new DataDistributeRespDto();
        dataDistributeRespDto.setTask_id(taskId);
        dataDistributeRespDto.setType(type);
        dataDistributeRespDto.setReason(reason);
        return dataDistributeRespDto;
    }
}

