/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.mq.dispatch.processor;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.tcbj.app.open.biz.mq.dispatch.vo.MqDispatchRegistryVo;
import com.dtyunxi.tcbj.app.open.biz.service.IMqLogService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.MqLogReqDto;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.SpringBeanUtil;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitRedirectProcessor
implements IMessageProcessor<MQMessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(RabbitRedirectProcessor.class);
    private final MqDispatchRegistryVo mqDispatchRegistryVo;
    private final AmqpTemplate amqpTemplate;

    public RabbitRedirectProcessor(MqDispatchRegistryVo mqDispatchRegistryVo, AmqpTemplate amqpTemplate) {
        this.mqDispatchRegistryVo = mqDispatchRegistryVo;
        this.amqpTemplate = amqpTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(MQMessageVo message) {
        logger.info("====================================\u5f00\u59cb========================================");
        logger.info("\u63a5\u6536\u5230\u76ee\u524d\u8f6c\u53d1\u6d88\u606f:{}, {}, ", (Object)JSONObject.toJSONString((Object)message), (Object)this.mqDispatchRegistryVo.getLogInfo());
        logger.info("\u6d88\u606f\u4f53\uff1a{}", (Object)this.unpackMessageStr(message));
        try {
            Message sendMsg = this.getMessage(message);
            this.amqpTemplate.send(this.mqDispatchRegistryVo.getTargetConsumer(), this.mqDispatchRegistryVo.getTargetTag(), sendMsg);
        }
        catch (Throwable throwable) {
            logger.error(throwable.getMessage(), throwable);
        }
        finally {
            try {
                logger.info("\u589e\u52a0MQ\u64cd\u4f5c\u8bb0\u5f55:{}", (Object)JacksonUtil.toJson((Object)this.mqDispatchRegistryVo));
                MqLogReqDto mqLogReqDto = new MqLogReqDto();
                mqLogReqDto.setReceiveTag(this.mqDispatchRegistryVo.getTag());
                mqLogReqDto.setReceiveTopic(this.mqDispatchRegistryVo.getTopic());
                mqLogReqDto.setReceiveConsumer(this.mqDispatchRegistryVo.getConsumer());
                mqLogReqDto.setSendTag(this.mqDispatchRegistryVo.getTargetTag());
                mqLogReqDto.setSendTopic(this.mqDispatchRegistryVo.getTargetTopic());
                mqLogReqDto.setSendConsumer(this.mqDispatchRegistryVo.getTargetConsumer());
                mqLogReqDto.setMessage(JacksonUtil.toJson((Object)message.getMessageKey()));
                mqLogReqDto.setResultMessage(JacksonUtil.toJson((Object)message));
                mqLogReqDto.setInstanceId(Long.valueOf(1254039287584232622L));
                mqLogReqDto.setTenantId(Long.valueOf(1L));
                logger.info("\u4fdd\u5b58MQ\u64cd\u4f5cDto\uff1a{}", (Object)JacksonUtil.toJson((Object)mqLogReqDto));
                IMqLogService mqLogService = (IMqLogService)SpringBeanUtil.getBean((String)"mqLogService");
                mqLogService.add(mqLogReqDto);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("====================================\u7ed3\u675f========================================");
        return MessageResponse.SUCCESS;
    }

    private Message getMessage(MQMessageVo message) {
        MessageProperties messageProperties = this.getMessageProperties(message);
        return ((RabbitTemplate)this.amqpTemplate).getMessageConverter().toMessage((Object)this.unpackMessageStr(message), messageProperties);
    }

    private MessageProperties getMessageProperties(MQMessageVo message) {
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("application/json");
        messageProperties.setMessageId(message.getMessageId());
        return messageProperties;
    }

    public String unpackMessageStr(MQMessageVo message) {
        Object messageBody;
        if (message.getSerializeCode().isJdkSerializer()) {
            messageBody = message.getSerializeCode().deSerialize(message.getMessageBody(), null);
        } else {
            String clazzJson = message.getUserProperty("mqMessageBodyClassInfo");
            if (StringUtils.isEmpty((CharSequence)clazzJson)) {
                messageBody = message.getSerializeCode().deSerialize(message.getMessageBody(), this.getMsgType());
            } else {
                Class msgType = (Class)JacksonUtil.readValue((String)clazzJson, Class.class);
                messageBody = message.getSerializeCode().deSerialize(message.getMessageBody(), (Type)msgType);
            }
        }
        return (String)messageBody;
    }
}

