/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.MaterialApplyAddReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.external.MaterialApplyItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class MaterialApplyUtils {
    public static void compareItemAndSubItem(MaterialApplyAddReqDto dto) {
        List itemList = Optional.ofNullable(dto.getItemList()).orElse(Collections.emptyList());
        List subItemList = Optional.ofNullable(dto.getSubItemList()).orElse(Collections.emptyList());
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<MatchKey, MaterialApplyItem> itemMap = new HashMap<MatchKey, MaterialApplyItem>();
        for (MaterialApplyItem item2 : itemList) {
            itemMap.put(new MatchKey(item2), item2);
        }
        for (MaterialApplyItem subItem : subItemList) {
            MatchKey key = new MatchKey(subItem);
            MaterialApplyItem materialApplyItem = (MaterialApplyItem)itemMap.get(key);
            if (materialApplyItem != null) {
                subItem.setCostCenterOrgUnit(materialApplyItem.getCostCenterOrgUnit());
                subItem.setUnit(materialApplyItem.getUnit());
                continue;
            }
            String errorMsg = String.format("\u672a\u627e\u5230\u5339\u914d\u7684\u4e3b\u9879\u6570\u636e\uff0c\u65e0\u6cd5\u586b\u5145\u5b57\u6bb5\u3002\u9884\u7559\u5355\u53f7\uff1a%s\uff0c\u7269\u6599\u7f16\u7801\uff1a%s\uff0c\u6279\u6b21\uff1a%s\uff0c\u4ed3\u5e93\u4ee3\u7801\uff1a%s", key.reservationNo, key.skuCode, key.batch, key.warehouseCode);
            errors.add(errorMsg);
        }
        if (!errors.isEmpty()) {
            throw new BizException("1000", ((Object)errors).toString());
        }
        Map<MatchKey, Integer> totalQtyByMain = itemList.stream().collect(Collectors.groupingBy(item -> new MatchKey((MaterialApplyItem)item), Collectors.mapping(MaterialApplyItem::getQuantity, Collectors.reducing(0, Integer::sum))));
        Map<MatchKey, Integer> totalQtyBySub = subItemList.stream().collect(Collectors.groupingBy(item -> new MatchKey((MaterialApplyItem)item), Collectors.mapping(MaterialApplyItem::getQuantity, Collectors.reducing(0, Integer::sum))));
        for (Map.Entry entry : totalQtyByMain.entrySet()) {
            Integer subQty;
            MatchKey key = (MatchKey)entry.getKey();
            Integer mainQty = (Integer)entry.getValue();
            if (mainQty.compareTo(subQty = totalQtyBySub.getOrDefault(key, 0)) == 0) continue;
            String errorMsg = String.format("\u9884\u7559\u5355\u53f7 %s\u3001\u7269\u6599\u7f16\u7801 %s\u3001\u6279\u6b21 %s\u3001\u4ed3\u5e93\u4ee3\u7801 %s \u7684\u4e3b\u9879\u7533\u8bf7\u6570\u91cf\u4e0e\u5b50\u9879\u7533\u8bf7\u6570\u91cf\u4e0d\u4e00\u81f4\u3002\u4e3b\u9879\u603b\u6570\u91cf\uff1a%s\uff0c\u5b50\u9879\u603b\u6570\u91cf\uff1a%s", key.reservationNo, key.skuCode, key.batch, key.warehouseCode, mainQty, subQty);
            errors.add(errorMsg);
        }
        Map<String, Integer> totalQtyBySkuMain = itemList.stream().collect(Collectors.groupingBy(MaterialApplyItem::getSkuCode, Collectors.mapping(MaterialApplyItem::getQuantity, Collectors.reducing(0, Integer::sum))));
        Map<String, Integer> map = subItemList.stream().collect(Collectors.groupingBy(MaterialApplyItem::getSkuCode, Collectors.mapping(MaterialApplyItem::getQuantity, Collectors.reducing(0, Integer::sum))));
        for (Map.Entry<String, Integer> entry : totalQtyBySkuMain.entrySet()) {
            Integer subQty;
            String skuCode = entry.getKey();
            Integer mainQty = entry.getValue();
            if (mainQty.compareTo(subQty = map.getOrDefault(skuCode, 0)) == 0) continue;
            String errorMsg = String.format("\u7269\u6599\u7f16\u7801 %s \u7684\u4e3b\u9879\u7533\u8bf7\u603b\u6570\u91cf\u4e0e\u5b50\u9879\u7533\u8bf7\u603b\u6570\u91cf\u4e0d\u4e00\u81f4\u3002\u4e3b\u9879\u603b\u6570\u91cf\uff1a%s\uff0c\u5b50\u9879\u603b\u6570\u91cf\uff1a%s", skuCode, mainQty, subQty);
            errors.add(errorMsg);
        }
        if (!errors.isEmpty()) {
            throw new BizException("-1", ((Object)errors).toString());
        }
    }

    static class MatchKey {
        private String reservationNo;
        private String skuCode;
        private String batch;
        private String warehouseCode;

        public MatchKey(MaterialApplyItem item) {
            this.reservationNo = item.getReservationNo();
            this.skuCode = item.getSkuCode();
            this.batch = item.getBatch();
            this.warehouseCode = item.getWarehouseCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MatchKey)) {
                return false;
            }
            MatchKey key = (MatchKey)o;
            return Objects.equals(this.reservationNo, key.reservationNo) && Objects.equals(this.skuCode, key.skuCode) && Objects.equals(this.batch, key.batch) && Objects.equals(this.warehouseCode, key.warehouseCode);
        }

        public int hashCode() {
            return Objects.hash(this.reservationNo, this.skuCode, this.batch, this.warehouseCode);
        }
    }
}

