/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.apiimpl.external;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalOutSapApi;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.DeliveryOrderSignReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.InventoryMoveReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.InventoryStoMoveReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.InventoryStoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.SalesOrderCreateReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.SapSaleOrderRespDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.StockPostingReqDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalOutSapApiImpl
implements IExternalOutSapApi {
    private static final Logger log = LoggerFactory.getLogger(ExternalOutSapApiImpl.class);
    @Autowired
    private IExternalOutService externalOutService;

    public RestResponse<SapSaleOrderRespDto> salesOrderCreate(SalesOrderCreateReqDto dto) {
        SapSaleOrderRespDto respDto = this.externalOutService.sapSalesOrderCreate(dto);
        return new RestResponse((Object)respDto);
    }

    public RestResponse<Void> deliveryOrderSign(DeliveryOrderSignReqDto dto) {
        this.externalOutService.sapDeliveryOrderSign(dto);
        return RestResponse.VOID;
    }

    public RestResponse<String> inventoryMove(InventoryMoveReqDto dto) {
        String orderNo = this.externalOutService.sapInventoryMove(dto);
        try {
            this.externalOutService.sapInventoryMoveCallBack(dto, orderNo);
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return new RestResponse((Object)orderNo);
    }

    public RestResponse<String> inventoryStoMove(InventoryStoMoveReqDto dto) {
        String orderNo = this.externalOutService.sapInventoryStoMove(dto);
        return new RestResponse((Object)orderNo);
    }

    public RestResponse<String> inventorySto(InventoryStoReqDto dto) {
        String orderNo = this.externalOutService.sapInventorySto(dto);
        return new RestResponse((Object)orderNo);
    }

    public RestResponse<String> stockPosting(StockPostingReqDto dto) {
        String respDto = this.externalOutService.sapStockPosting(dto);
        return new RestResponse((Object)respDto);
    }
}

