/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.external.CspHttpResponseDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateCspOrderRespDto;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CspResponseHelper {
    private static final Logger log = LoggerFactory.getLogger(CspResponseHelper.class);

    private CspResponseHelper() {
    }

    public static <T> T check(CspHttpResponseDto responseDto, Class<T> target) {
        CspResponseHelper.newCspCheck(responseDto);
        if (ObjectUtil.isNotEmpty((Object)responseDto.getData())) {
            return (T)JSON.parseObject((String)JSON.toJSONString((Object)responseDto.getData()), target);
        }
        return null;
    }

    public static void check(CspHttpResponseDto responseDto) {
        log.info("CSP\u63a5\u53e3\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)responseDto));
        if (ObjectUtil.isEmpty((Object)responseDto)) {
            throw new BizException("CSP\u54cd\u5e94\u5f02\u5e38\uff01");
        }
        if (StringUtils.isBlank((CharSequence)responseDto.getStatus()) || !responseDto.getStatus().equals("200")) {
            StringBuilder errorStr = new StringBuilder("CSP\u8bf7\u6c42\u5931\u8d25\uff1a");
            if (StringUtils.isNotBlank((CharSequence)responseDto.getStatus())) {
                errorStr.append(responseDto.getStatus());
            }
            if (ObjectUtil.isNotEmpty((Object)responseDto.getData())) {
                errorStr.append(JSON.toJSONString((Object)responseDto.getData()));
            }
            throw new BizException(errorStr.toString());
        }
    }

    public static void check(CSPUpdateCspOrderRespDto responseDto) {
        if (ObjectUtil.isEmpty((Object)responseDto)) {
            throw new BizException("CSP\u54cd\u5e94\u5f02\u5e38\uff01");
        }
        if (responseDto.getCode() != 0) {
            throw new BizException("CSP\u8bf7\u6c42\u5931\u8d25\uff1a" + responseDto.getMsg());
        }
    }

    public static void newCspCheck(CspHttpResponseDto responseDto) {
        log.info("CSP\u63a5\u53e3\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)responseDto));
        if (ObjectUtil.isEmpty((Object)responseDto)) {
            throw new BizException("CSP\u54cd\u5e94\u5f02\u5e38\uff01");
        }
        if (StringUtils.isBlank((CharSequence)responseDto.getCode()) || !responseDto.getCode().equals("200")) {
            StringBuilder errorStr = new StringBuilder("CSP\u8bf7\u6c42\u5931\u8d25\uff1a");
            if (StringUtils.isNotBlank((CharSequence)responseDto.getMsg())) {
                errorStr.append(responseDto.getMsg());
            }
            if (ObjectUtil.isNotEmpty((Object)responseDto.getData())) {
                errorStr.append(JSON.toJSONString((Object)responseDto.getData()));
            }
            throw new BizException(errorStr.toString());
        }
    }
}

