/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler.external;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.scheduler.config.TaskConfigEnum;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TaskCreater {
    private static final Logger log = LoggerFactory.getLogger(TaskCreater.class);
    @Resource
    private ITaskApi taskApi;
    @Resource
    private Environment environment;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    @Value(value="${scheduler.client.retryYwzxSysten:0 0/5 * * * ?}")
    private String retryYwzxSysten;
    @Value(value="${scheduler.client.retryYwzx:0/10 * * * * ?}")
    private String retryYwzx;

    @PostConstruct
    public void initTask() {
        try {
            this.createTryUnconfirmedTask();
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    private void createTryUnconfirmedTask() {
        this.initTask(TaskConfigEnum.RETRY_YWZX, this.retryYwzx);
        this.initTask(TaskConfigEnum.RETRY_YWZX_SYSTEN, this.retryYwzxSysten);
    }

    public void initTask(TaskConfigEnum taskConfigEnum, String cron) {
        RestResponse enbaleResponse;
        log.info("\u5f00\u59cb\u521d\u59cb\u5316\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u3011,scheduleExpression:{}", (Object)cron);
        if (StringUtils.isEmpty((CharSequence)cron)) {
            log.warn("\u521d\u59cb\u5316\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u3011\u5931\u8d25,\u5e93\u5b58\u4e2d\u5fc3\u914d\u7f6e\u6587\u4ef6\u672a\u914d\u7f6e\u4efb\u52a1\u6267\u884c\u8868\u8fbe\u5f0f\uff01");
            return;
        }
        AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
        appBizQueryReqDto.setAppCode(this.environment.getProperty("scheduler.client.app_code"));
        appBizQueryReqDto.setBizCode(taskConfigEnum.getBizCode());
        String filter = ObjectHelper.bean2Json((Object)appBizQueryReqDto);
        List appBizQueryRespDtos = ((PageInfo)this.appBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1)).getData()).getList();
        if (CollectionUtils.isEmpty((Collection)appBizQueryRespDtos)) {
            log.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u3011\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316\u2026\u2026");
            this.createDeliverThresholdTask(taskConfigEnum, cron);
            return;
        }
        log.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u3011\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u66f4\u65b0\u2026\u2026");
        AppBizQueryRespDto origAppBiz = (AppBizQueryRespDto)appBizQueryRespDtos.get(0);
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setAppBizId(origAppBiz.getId());
        taskQueryReqDto.setTaskName(origAppBiz.getBizName());
        String taskFilter = ObjectHelper.bean2Json((Object)taskQueryReqDto);
        PageInfo taskPageInfo = (PageInfo)this.taskQueryApi.queryByPage(taskFilter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null == taskPageInfo || CollectionUtils.isEmpty((Collection)taskPageInfo.getList())) {
            throw new BizException("\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u5b9a\u65f6\u4efb\u52a1\u3011\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        TaskQueryRespDto origTask = (TaskQueryRespDto)taskPageInfo.getList().get(0);
        String status = origTask.getStatus();
        if (cron.equals(origTask.getScheduleExpression())) {
            log.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u3011\u914d\u7f6e\u4e0d\u53d8\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\u3002");
            if (EnableEnum.DISABLE.getCodeEn().equals(status)) {
                enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
                log.info("\u539f\u5b9a\u65f6\u4efb\u52a1\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u3011\u672a\u542f\u7528\uff0c\u542f\u7528\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
            }
        }
        if (EnableEnum.ENABLE.getCodeEn().equals(status)) {
            RestResponse disableResponse = this.taskApi.disableById(origTask.getId(), "{}");
            log.info("\u7981\u7528\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u3011\u6210\u529f\uff0c{}", (Object)JSON.toJSONString((Object)disableResponse));
        }
        if (!cron.equals(origTask.getScheduleExpression())) {
            TaskUpdateReqDto taskUpate = new TaskUpdateReqDto();
            taskUpate.setScheduleExpression(cron);
            taskUpate.setInstanceId(Long.valueOf(-1L));
            taskUpate.setTenantId(Long.valueOf(-1L));
            RestResponse updateResponse = this.taskApi.modifyById(origTask.getId(), taskUpate);
            log.info("\u66f4\u65b0\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)updateResponse));
        }
        enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
        log.info("\u542f\u7528\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
    }

    private void createDeliverThresholdTask(TaskConfigEnum taskConfigEnum, String cron) {
        log.info("\u5f00\u59cb\u521b\u5efa\u3010\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u3011\u2026\u2026");
        TaskAndBizCreateReqDto taskAndBizCreate = new TaskAndBizCreateReqDto();
        taskAndBizCreate.setAppCode(this.environment.getProperty("scheduler.client.app_code"));
        taskAndBizCreate.setBizCode(taskConfigEnum.getBizCode());
        taskAndBizCreate.setBizName(taskConfigEnum.getBizName());
        taskAndBizCreate.setParams("");
        taskAndBizCreate.setScheduleExpression(cron);
        taskAndBizCreate.setShardType("SINGLE");
        taskAndBizCreate.setTaskName(taskConfigEnum.getTaskName());
        taskAndBizCreate.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreate.setTenantId(Long.valueOf(-1L));
        RestResponse addResult = this.taskApi.addWithBiz(taskAndBizCreate);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
        log.info("\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff01");
    }
}

