/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.storage;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.storage.IStorageHelper;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="storageHelper")
public class StorageHelper
implements IStorageHelper {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICsInventoryExposedApi inventoryExposedApi;
    @Resource
    private ICsInventoryExposedApi csInventoryExposedApi;

    @Override
    public void subVirStorage(OrderReqDto orderReqDto) {
        ArrayList needSubVirList = Lists.newArrayList();
        for (TradeItemReqDto orderItemInfoDto : orderReqDto.getOrderItems()) {
            ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
            itemStorageReqDto.setBalance(Long.valueOf(-Long.valueOf(orderItemInfoDto.getItemNum().intValue()).longValue()));
            itemStorageReqDto.setShopId(Long.valueOf(orderItemInfoDto.getShopId()));
            itemStorageReqDto.setItemType(orderItemInfoDto.getItemType());
            itemStorageReqDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
            HashMap<String, String> extFields = new HashMap<String, String>();
            Assert.notNull((Object)orderItemInfoDto.getCargoSerial(), (String)"\u8be5\u503c\u4e3a\u7a7a:CargoCode,\u65e0\u6cd5\u6263\u51cf\u5e93\u5b58", (Object[])new Object[0]);
            extFields.put("cargoCode", orderItemInfoDto.getCargoSerial());
            itemStorageReqDto.setExtFields(extFields);
            needSubVirList.add(itemStorageReqDto);
        }
    }

    @Override
    public void rollbackVirSotrage(String orderNo) {
        this.logger.info("\u53d6\u6d88\u5360\u7528\u63a5\u53e3\u5c40\u8bf7\u6c42\u53c2\u6570:{}", (Object)orderNo);
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            this.logger.info("\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a\uff0c\u53d6\u6d88\u56de\u6eda\u5e93\u5b58\uff01");
            return;
        }
        CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto = new CsInventoryReleasePreemptOperateReqDto();
        releasePreemptOperateReqDto.setSourceNo(orderNo);
        releasePreemptOperateReqDto.setSourceType(CsInventorySourceTypeEnum.IN_SALE_RELEASE.getCode());
        RestResponseHelper.extractData((RestResponse)this.inventoryExposedApi.releaseInventoryByPreemption(releasePreemptOperateReqDto));
    }

    private RestResponse<String> placeOrderPreempt(TcbjProOccupyReqDto tcbjProOccupyReqDto) {
        this.logger.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58,orderNo:{}", (Object)tcbjProOccupyReqDto.getOrderNo());
        RestResponse result = RestResponse.SUCCEED;
        List tcbjProOccupyItemReqDtoList = tcbjProOccupyReqDto.getTcbjProOccupyItemReqDtos();
        CsInventoryOperateReqDto csInventoryOperateReqDto = new CsInventoryOperateReqDto();
        csInventoryOperateReqDto.setSourceNo(tcbjProOccupyReqDto.getOrderNo());
        csInventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        csInventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        for (TcbjProOccupyItemReqDto itemReqDto : tcbjProOccupyItemReqDtoList) {
            CsInventoryOperateCargoReqDto operateCargoReqDto = new CsInventoryOperateCargoReqDto();
            operateCargoReqDto.setWarehouseCode(itemReqDto.getWarehouseCode());
            operateCargoReqDto.setCargoCode(itemReqDto.getCargoCode());
            operateCargoReqDto.setBatch(itemReqDto.getBatch());
            operateCargoReqDto.setActivityId(itemReqDto.getActivityId());
            operateCargoReqDto.setChangeInventory(new BigDecimal(itemReqDto.getNum()));
            operateCargoReqDtoList.add(operateCargoReqDto);
        }
        csInventoryOperateReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
        this.logger.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58,csInventoryOperateReqDto:{}", (Object)JSON.toJSONString((Object)csInventoryOperateReqDto));
        RestResponse preemptInventoryResp = this.csInventoryExposedApi.preemptInventory(csInventoryOperateReqDto);
        this.logger.info("placeOrderPreempt==>\u4e0b\u5355\u9884\u5360\u5e93\u5b58,preemptInventoryResp:{}", (Object)JSON.toJSONString((Object)preemptInventoryResp));
        Boolean preemptResult = (Boolean)RestResponseHelper.extractData((RestResponse)preemptInventoryResp);
        if (!preemptResult.booleanValue()) {
            result = RestResponse.FAILED;
        }
        return result;
    }
}

