/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsOutNoticeOrderDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsOutNoticeOrderDetailRespDto;
import com.dtyunxi.tcbj.api.query.ICsOutNoticeOrderDetailQueryApi;
import com.dtyunxi.tcbj.app.open.biz.apiimpl.query.StringCodeQueryApiImpl;
import com.dtyunxi.tcbj.app.open.biz.service.IStringCodeSelfCheckService;
import com.dtyunxi.tcbj.app.open.biz.service.IStringCodeService;
import com.dtyunxi.tcbj.app.open.biz.utils.AssertUtil;
import com.dtyunxi.tcbj.app.open.dao.das.StringCodeSelfDas;
import com.dtyunxi.tcbj.app.open.dao.eo.StringCodeSelfEo;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.StringCodeCheckReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.StringCodeSelfCheckReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.StringCodeCheckRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.StringCodeRespDto;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StringCodeSelfCheckServiceImpl
implements IStringCodeSelfCheckService {
    private static final Logger logger = LoggerFactory.getLogger(StringCodeSelfCheckServiceImpl.class);
    private static final String CHECK_ORDER_KEY = "StringCodeCheckEvent:thirdNo";
    @Resource
    private ICsOutNoticeOrderDetailQueryApi csOutNoticeOrderDetailQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private StringCodeQueryApiImpl stringCodeQueryApiImpl;
    @Resource
    private IStringCodeService stringCodeService;
    @Resource
    private StringCodeSelfDas stringCodeSelfDas;

    @Override
    public void check(StringCodeSelfCheckReqDto reqDto) {
        logger.info("\u4e32\u7801\u81ea\u68c0\uff1a{}", (Object)JacksonUtil.toJson((Object)reqDto));
        CsOutNoticeOrderDetailReqDto detailReqDto = new CsOutNoticeOrderDetailReqDto();
        detailReqDto.setRelevanceNoList(reqDto.getRelevanceNos());
        detailReqDto.setEasVerifyTimeStartDate(reqDto.getStartDate());
        detailReqDto.setEasVerifyTimeEndDate(reqDto.getEndDate());
        List list = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderDetailQueryApi.querySaleByPagePost(detailReqDto));
        AssertUtil.isTrues(CollectionUtil.isEmpty((Collection)list), "-1", "\u627e\u4e0d\u5230\u901a\u77e5\u660e\u7ec6");
        this.checkExecute(list);
    }

    private void checkExecute(List<CsOutNoticeOrderDetailRespDto> detailRespDtoList) {
        logger.info("StringCodeSelfCheckServiceImpl\uff0ccheckExecute\uff1a{}", (Object)JacksonUtil.toJson(detailRespDtoList));
        detailRespDtoList.stream().collect(Collectors.groupingBy(CsOutNoticeOrderDetailRespDto::getDocumentNo)).forEach((k, v) -> {
            logger.info("\u6839\u636e\u7ed3\u679c\u5355\u5206\u7ec4\u6267\u884c\u6821\u9a8c\uff1a{}", k);
            String thirdNo = this.getThirdNo((CsOutNoticeOrderDetailRespDto)v.get(0));
            List<StringCodeCheckReqDto> checkDtoList = v.stream().map(m -> {
                StringCodeCheckReqDto reqDto = new StringCodeCheckReqDto();
                reqDto.setDocumentNo(m.getDocumentNo());
                reqDto.setEasSaleOrderNo(thirdNo);
                reqDto.setNum(Integer.valueOf(m.getDoneQuantity().intValue()));
                reqDto.setItemLongCode(m.getSkuCode());
                reqDto.setBatch(m.getBatch());
                reqDto.setSyncView(false);
                return reqDto;
            }).collect(Collectors.toList());
            logger.info("\u6839\u636e\u7ed3\u679c\u5355\u5206\u7ec4\u6267\u884c\u6821\u9a8c\uff0ccheckDtoList\uff1a{}", (Object)JacksonUtil.toJson(checkDtoList));
            this.doCheck(checkDtoList);
        });
    }

    private void doCheck(List<StringCodeCheckReqDto> list) {
        logger.info("StringCodeSelfCheckServiceImpl\uff0c\u5408\u5e76\u524d\uff1a{}", (Object)JacksonUtil.toJson(list));
        list = new ArrayList(list.stream().collect(Collectors.toMap(k -> k.getEasSaleOrderNo() + "_" + k.getItemLongCode(), Function.identity(), (o, o1) -> {
            o.setNum(Integer.valueOf(o.getNum() + o1.getNum()));
            return o;
        })).values());
        logger.info("StringCodeSelfCheckServiceImpl\uff0c\u5408\u5e76\u540e\uff1a{}", (Object)JacksonUtil.toJson(list));
        ArrayList respList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respList, list, StringCodeCheckRespDto.class);
        List queryNos = respList.stream().filter(r -> !r.isCheckResult()).map(StringCodeCheckReqDto::getEasSaleOrderNo).distinct().collect(Collectors.toList());
        List<StringCodeRespDto> stringCodeRespDtoList = this.loadViewStringCode((String)queryNos.get(0));
        if (CollectionUtil.isNotEmpty(stringCodeRespDtoList)) {
            this.save(stringCodeRespDtoList);
        } else {
            logger.info("\u65e0\u4e32\u7801\u6570\u636e");
        }
    }

    private void save(List<StringCodeRespDto> dtoList) {
        logger.info("\u4fdd\u5b58\u4e32\u7801\u81ea\u68c0\u6570\u636e\uff1a{}", (Object)JacksonUtil.toJson(dtoList));
        List easCodes = dtoList.stream().map(StringCodeRespDto::getEasCode).collect(Collectors.toList());
        List selfEos = ((ExtQueryChainWrapper)this.stringCodeSelfDas.filter().in((Object)"eas_code", easCodes)).list();
        if (CollectionUtil.isNotEmpty((Collection)selfEos)) {
            this.stringCodeSelfDas.logicDeleteByIds(selfEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
        ArrayList stringCodeSelfEos = new ArrayList();
        DtoHelper.dtoList2EoList(dtoList, stringCodeSelfEos, StringCodeSelfEo.class);
        this.stringCodeSelfDas.insertBatch(stringCodeSelfEos);
    }

    private List<StringCodeRespDto> loadViewStringCode(String r) {
        List<StringCodeRespDto> stringCodeList = this.stringCodeService.queryByStringNo(r);
        if (CollectionUtil.isEmpty(stringCodeList) && CollectionUtil.isEmpty(stringCodeList = this.stringCodeService.queryByEasNo(r))) {
            return Collections.emptyList();
        }
        return stringCodeList;
    }

    private String getThirdNo(CsOutNoticeOrderDetailRespDto i) {
        return Optional.ofNullable(this.cacheService.hget(CHECK_ORDER_KEY, i.getDocumentNo(), String.class)).orElseGet(() -> {
            CsOutNoticeOrderRespDto data = (CsOutNoticeOrderRespDto)this.csOutNoticeOrderQueryApi.queryByDocumentNo(i.getDocumentNo()).getData();
            String thirdNo = this.getThirdNo(data);
            return thirdNo;
        });
    }

    private String getThirdNo(CsOutNoticeOrderRespDto noticeOrderRespDto) {
        switch (CsPcpBusinessTypeEnum.getByCode((String)noticeOrderRespDto.getBusinessType())) {
            case INTERNAL_DEAL: 
            case INTERNAL_DEAL_RETURN: {
                return Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(noticeOrderRespDto.getRelevanceNo()))).map(CsTransferOrderRespDto::getExternalPurchaseOrderNo).orElse(noticeOrderRespDto.getExternalOrderNo());
            }
            case ALLOT_OUT: 
            case MAIYOU_ALLOT_OUT: 
            case ALLOT_IN_ONLY: 
            case ALLOT_OUT_ONLY: 
            case ALLOT_SALE: 
            case ALLOT_SALE_BH: {
                return Optional.ofNullable(noticeOrderRespDto.getExternalOrderNo()).filter(StringUtils::isNotEmpty).orElse(noticeOrderRespDto.getRelevanceNo());
            }
            case OTHER_OUT: 
            case OTHER_IN: 
            case REPLENISH_ORDER: 
            case INSPECTION_QUALIFIED: {
                return noticeOrderRespDto.getRelevanceNo();
            }
            case ALLOT_LOSE_EFFICACY: {
                return noticeOrderRespDto.getDocumentNo();
            }
            case NUTRITION_INTEGRAL: 
            case OTHER_OUT_STOCK: 
            case AGENCY_ORDER: 
            case SHOPPE_ORDER: 
            case INTEGRAL_ORDER: 
            case REPLENISHMENT_ORDER: 
            case ACTIVITY_ORDER: 
            case INTERNAL_DISTRIBUTION: 
            case SECONDARY_DISTRIBUTION: 
            case COMPENSATION_ORDER: 
            case QUALITY_REFUNDING_ORDER: 
            case PRESALE_ORDER: 
            case CUSTOMER_REFUNDING_ORDER: 
            case CLAIM_POSTING: 
            case CLAIM_REISSUE: 
            case COMMON_ORDER: {
                BizSaleOrderRespDto data = (BizSaleOrderRespDto)Optional.ofNullable(this.saleOrderQueryApi.queryByOrderNo(noticeOrderRespDto.getRelevanceNo()).getData()).orElse(new BizSaleOrderRespDto());
                return this.getThirdOrderNo(noticeOrderRespDto.getRelevanceNo(), data);
            }
        }
        return noticeOrderRespDto.getExternalOrderNo();
    }

    private String getThirdOrderNo(String relevanceNo, BizSaleOrderRespDto order) {
        return Optional.ofNullable(order.getSplitPlatformNo()).filter(r -> StringUtils.isNotBlank((CharSequence)r) && StringUtils.isNotBlank((CharSequence)order.getEasOrderNo())).orElseGet(() -> Optional.ofNullable(order.getEasOrderNo()).filter(StringUtils::isNotBlank).orElse(relevanceNo));
    }
}

