/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.wms.adaptor;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.utils.RestUtil;
import com.dtyunxi.tcbj.app.open.biz.wms.IWmsService;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalOutQimenWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.qimen.constant.QimenOrderTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.DeliveryorderCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.EntryorderCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.OrderCancelRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.ReturnorderCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.SingleitemSynchronizeRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.StockoutCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.StoreprocessCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.SupplierSynchronizeRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.enums.ExternalWmsServiceEnum;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsCustomerReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsItemLine;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOrderCancelReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsOrderMergeReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsReturnOrderCreateReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockOutOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.response.WmsBaseRespDto;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.IWarehouseAreaMappingApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseAreaMappingReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseAreaMappingRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.WarehouseAreaMappingTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.qimen.api.request.EntryorderCreateRequest;
import com.qimen.api.request.ReturnorderCreateRequest;
import com.qimen.api.request.SingleitemSynchronizeRequest;
import com.qimen.api.request.StockoutCreateRequest;
import com.qimen.api.response.OrderCancelResponse;
import com.yunxi.dg.base.center.basicdata.api.query.IPcpRegionQueryApi;
import com.yunxi.dg.base.center.basicdata.dto.response.PcpRegionRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class QimenWmsAdaptor
implements IWmsService {
    private static Logger logger = LoggerFactory.getLogger(QimenWmsAdaptor.class);
    @Resource
    private IExternalOutQimenWmsApi externalOutQimenWmsApi;
    @Resource
    private IPcpRegionQueryApi areaQueryApi;
    @Resource
    private RestTemplate restTemplate;
    @Autowired
    ISaleOrderQueryApi saleOrderQueryApi;
    @Autowired
    private IWarehouseAreaMappingApi iWarehouseAreaMappingApi;
    @Autowired
    ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private ICsOutPlannedOrderQueryApi csOutPlannedOrderQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Value(value="${wms.wz.merge.base-url:http://192.168.1.47:8080}")
    private String mereBaseUrl;

    @Override
    public String getType() {
        return ExternalWmsServiceEnum.QIMEN_WMS.getServiceCode();
    }

    @Override
    public WmsBaseRespDto entryOrderCreate(WmsStockEntryOrderReqDto reqDto) {
        Assert.isTrue((CsPcpBusinessTypeEnum.getByCode((String)reqDto.getBusinessType()) != null ? 1 : 0) != 0, (String)ExceptionCode.FAIL.getCode(), (String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b");
        switch (CsPcpBusinessTypeEnum.getByCode((String)reqDto.getBusinessType())) {
            case PURCHASE: 
            case OUTSOURCE: 
            case PRODUCTION: 
            case OTHER_IN: 
            case PURCHASE_REFUND: 
            case OUTSOURCE_REFUND: {
                this.externalOutQimenWmsApi.entryorderCreate(this.transferEntryOrderCreateDto(reqDto));
                break;
            }
            default: {
                this.externalOutQimenWmsApi.entryorderCreate(this.transferEntryOrderCreateDto(reqDto));
            }
        }
        return null;
    }

    private ReturnorderCreateRequestDto transferReturnOrderCreateDto(WmsStockEntryOrderReqDto reqDto) {
        ReturnorderCreateRequestDto returnorderCreateRequestDto = new ReturnorderCreateRequestDto();
        returnorderCreateRequestDto.setCustomerId(reqDto.getCustomerId());
        ReturnorderCreateRequestDto.ReturnOrder returnOrder = this.buildReturnOrder(reqDto);
        returnorderCreateRequestDto.setReturnOrder(returnOrder);
        returnorderCreateRequestDto.setExtendPropsDto(this.getReturnExtendProps(reqDto));
        returnorderCreateRequestDto.setOrderLines(reqDto.getItemLines().stream().map(item -> {
            ReturnorderCreateRequestDto.OrderLine orderLine = new ReturnorderCreateRequestDto.OrderLine();
            orderLine.setOrderLineNo(item.getTradeOrderItemId());
            orderLine.setOwnerCode(reqDto.getOwnerCode());
            orderLine.setItemCode(this.parseItemCode(item.getItemCode(), item.getCargoCode()));
            orderLine.setItemId(item.getCargoCode());
            orderLine.setItemName(item.getCargoName());
            orderLine.setPlanQty(Long.valueOf(item.getPlanQuantity().longValue()));
            orderLine.setBatchCode(item.getBatch());
            orderLine.setProductCode(item.getBatch());
            orderLine.setProduceCode(item.getBatch());
            orderLine.setProductDate(item.getProductDate());
            orderLine.setExpireDate(item.getArrivalDate());
            orderLine.setActualPrice(item.getPrice().toString());
            orderLine.setAmount(item.getAmount().toString());
            orderLine.setExtCode(item.getIntegral() != false ? "1" : "0");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("je", Optional.ofNullable(item.getAmount()).orElse(BigDecimal.ZERO).toString());
            map.put("barCode", item.getCargoCode());
            map.put("dj", Optional.ofNullable(item.getSkuPrice()).orElse(BigDecimal.ZERO).toString());
            map.put("isPointsExchange", item.getIntegral() != false ? 1 : 0);
            orderLine.setExtendProps(map);
            return orderLine;
        }).collect(Collectors.toList()));
        Map orderLineExtendPropsMap = reqDto.getItemLines().stream().map(item -> {
            ReturnorderCreateRequestDto.OrderLineExtendProps props = new ReturnorderCreateRequestDto.OrderLineExtendProps();
            props.setOrderLineNo(item.getTradeOrderItemId());
            props.setBarcode(item.getBarcode());
            props.setGoodsBarcode(item.getBarcode());
            props.setBarcode(item.getBarcode());
            props.setCkCode(reqDto.getWmsRelevance());
            return props;
        }).collect(Collectors.toMap(ReturnorderCreateRequestDto.OrderLineExtendProps::getOrderLineNo, Function.identity()));
        returnorderCreateRequestDto.setOrderLineExtendPropsMap(orderLineExtendPropsMap);
        return returnorderCreateRequestDto;
    }

    private ReturnorderCreateRequestDto.ExtendProps getReturnExtendProps(WmsStockEntryOrderReqDto reqDto) {
        ReturnorderCreateRequestDto.ExtendProps extendProps = new ReturnorderCreateRequestDto.ExtendProps();
        extendProps.setInboundLogicWarehouse(reqDto.getLogicWarehouseCode());
        extendProps.setInboundOwnerCode(Optional.ofNullable(reqDto.getOrganizationCode()).orElse("TCBJ"));
        extendProps.setInboundLogicWarehouseName(reqDto.getLogicWarehouseName());
        extendProps.setInboundPhysicsWarehouseCode(reqDto.getWarehouseCode());
        extendProps.setBusinessType(reqDto.getBusinessType());
        extendProps.setEasCode(reqDto.getThirdOrderNo());
        return extendProps;
    }

    private ReturnorderCreateRequestDto.ReturnOrder buildReturnOrder(WmsStockEntryOrderReqDto reqDto) {
        ReturnorderCreateRequestDto.ReturnOrder returnOrder = new ReturnorderCreateRequestDto.ReturnOrder();
        returnOrder.setOrderType(this.getOrderType(reqDto.getBusinessType()));
        returnOrder.setOwnerCode(reqDto.getOwnerCode());
        returnOrder.setReturnOrderCode(reqDto.getDocumentNo());
        returnOrder.setWarehouseCode(reqDto.getLogicWarehouseCode());
        returnOrder.setPreDeliveryOrderCode(reqDto.getRelevanceNo());
        returnOrder.setSupplierCode(Optional.ofNullable(reqDto.getSupplierCode()).orElse(Optional.ofNullable(reqDto.getOrganizationCode()).orElse("0102")));
        returnOrder.setSupplierName(reqDto.getOrganizationName());
        returnOrder.setLogisticsCode(reqDto.getLogisticsCode());
        returnOrder.setLogisticsName(reqDto.getLogisticsName());
        returnOrder.setExpressCode(reqDto.getExpressCode());
        returnOrder.setBuyerNick(reqDto.getBuyerNick());
        returnOrder.setShopNick(reqDto.getShopName());
        returnOrder.setSourcePlatformCode(reqDto.getChannelCode());
        returnOrder.setSourcePlatformName(reqDto.getChannelName());
        returnOrder.setSenderInfo(this.buildReturnSenderInfo(reqDto));
        return returnOrder;
    }

    private ReturnorderCreateRequest.SenderInfo buildReturnSenderInfo(WmsStockEntryOrderReqDto reqDto) {
        ReturnorderCreateRequest.SenderInfo senderInfo = new ReturnorderCreateRequest.SenderInfo();
        senderInfo.setName(reqDto.getContacts());
        senderInfo.setArea(Optional.ofNullable(reqDto.getDistrict()).orElseGet(() -> this.getAreaByCode(reqDto.getAreaCode())));
        senderInfo.setProvince(Optional.ofNullable(reqDto.getProvince()).orElseGet(() -> this.getAreaByCode(reqDto.getProvinceCode())));
        senderInfo.setCity(Optional.ofNullable(reqDto.getCity()).orElseGet(() -> this.getAreaByCode(reqDto.getCityCode())));
        senderInfo.setDetailAddress(reqDto.getDetailAddress());
        senderInfo.setMobile(reqDto.getPhone());
        senderInfo.setTel(reqDto.getPhone());
        senderInfo.setZipCode(reqDto.getPostalCode());
        senderInfo.setCountryCode(reqDto.getCountryCode());
        return senderInfo;
    }

    private String getAreaByCode(String areaCode) {
        return Optional.ofNullable(areaCode).filter(StringUtils::isNotEmpty).map(code -> Optional.ofNullable(RestUtil.checkResponse(this.areaQueryApi.queryByCode(code))).orElse(new PcpRegionRespDto()).getName()).orElse("");
    }

    private EntryorderCreateRequestDto transferEntryOrderCreateDto(WmsStockEntryOrderReqDto reqDto) {
        EntryorderCreateRequestDto createRequestDto = new EntryorderCreateRequestDto();
        createRequestDto.setEntryOrder(this.buildEntryOrder(reqDto));
        createRequestDto.setExtendProps(this.getEntryExtendProps(reqDto));
        createRequestDto.setOrderLines(reqDto.getItemLines().stream().map(item -> {
            EntryorderCreateRequestDto.OrderLine orderLine = new EntryorderCreateRequestDto.OrderLine();
            orderLine.setOrderLineNo(item.getTradeOrderItemId());
            orderLine.setItemCode(this.parseItemCode(item.getItemCode(), item.getCargoCode()));
            orderLine.setItemId(item.getCargoCode());
            orderLine.setItemName(item.getCargoName());
            orderLine.setPlanQty(Long.valueOf(item.getPlanQuantity().longValue()));
            orderLine.setBatchCode(item.getBatch());
            orderLine.setProductCode(item.getBatch());
            orderLine.setProduceCode(item.getBatch());
            orderLine.setProductDate(item.getProductDate());
            orderLine.setExpireDate(item.getArrivalDate());
            orderLine.setActualPrice(item.getPrice().toString());
            orderLine.setAmount(item.getAmount().toString());
            orderLine.setExtCode(item.getIntegral() != false ? "1" : "0");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("je", Optional.ofNullable(item.getAmount()).orElse(BigDecimal.ZERO).toString());
            map.put("barCode", item.getCargoCode());
            map.put("dj", Optional.ofNullable(item.getSkuPrice()).orElse(BigDecimal.ZERO).toString());
            map.put("isPointsExchange", item.getIntegral() != false ? 1 : 0);
            orderLine.setExtendProps(map);
            return orderLine;
        }).collect(Collectors.toList()));
        createRequestDto.setCustomerId(reqDto.getCustomerId());
        return createRequestDto;
    }

    private EntryorderCreateRequestDto.EntryOrder buildEntryOrder(WmsStockEntryOrderReqDto reqDto) {
        EntryorderCreateRequestDto.EntryOrder entryOrder = new EntryorderCreateRequestDto.EntryOrder();
        entryOrder.setEntryOrderCode(reqDto.getDocumentNo());
        entryOrder.setPurchaseOrderCode(reqDto.getThirdOrderNo());
        entryOrder.setOwnerCode(reqDto.getOwnerCode());
        entryOrder.setWarehouseCode(reqDto.getLogicWarehouseCode());
        entryOrder.setOutBizCode(reqDto.getDocumentNo());
        entryOrder.setOrderCreateTime(reqDto.getOrderCreateTime());
        entryOrder.setOrderType(this.getOrderType(reqDto.getBusinessType()));
        entryOrder.setExpectStartTime(reqDto.getExpectStartTime());
        entryOrder.setRemark(reqDto.getRemark());
        entryOrder.setSupplierCode(Optional.ofNullable(reqDto.getOrganizationCode()).orElse("0102"));
        entryOrder.setSupplierName(reqDto.getOrganizationName());
        entryOrder.setSenderInfo(this.buildSenderInfo(reqDto));
        return entryOrder;
    }

    private EntryorderCreateRequest.SenderInfo buildSenderInfo(WmsStockEntryOrderReqDto reqDto) {
        EntryorderCreateRequest.SenderInfo senderInfo = new EntryorderCreateRequest.SenderInfo();
        senderInfo.setName(reqDto.getContacts());
        senderInfo.setArea(Optional.ofNullable(reqDto.getDistrict()).orElseGet(() -> this.getAreaByCode(reqDto.getAreaCode())));
        senderInfo.setProvince(Optional.ofNullable(reqDto.getProvince()).orElseGet(() -> this.getAreaByCode(reqDto.getProvinceCode())));
        senderInfo.setCity(Optional.ofNullable(reqDto.getCity()).orElseGet(() -> this.getAreaByCode(reqDto.getCityCode())));
        senderInfo.setDetailAddress(reqDto.getDetailAddress());
        senderInfo.setMobile(reqDto.getPhone());
        senderInfo.setTel(reqDto.getPhone());
        senderInfo.setZipCode(reqDto.getPostalCode());
        senderInfo.setCountryCode(reqDto.getCountryCode());
        return senderInfo;
    }

    private String getOrderType(String orderType) {
        return orderType;
    }

    @Override
    public WmsBaseRespDto stockOutCreate(WmsStockOutOrderReqDto reqDto) {
        CsOutNoticeOrderRespDto respDto;
        logger.info("\u51fa\u5e93\u5355\u521b\u5efa\u63a8\u9001WMS\uff0cstockOutCreate\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        CsOutNoticeOrderQueryDto queryDto = new CsOutNoticeOrderQueryDto();
        queryDto.setDocumentNo(reqDto.getDocumentNo());
        List list = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByParam(queryDto));
        if (CollectionUtils.isNotEmpty((Collection)list) && "ono_cancel".equals((respDto = (CsOutNoticeOrderRespDto)list.get(0)).getOrderStatus())) {
            logger.info("\u51fa\u5e93\u5355\uff1a{}\u72b6\u6001\u5df2\u53d6\u6d88", (Object)reqDto.getDocumentNo());
            return null;
        }
        CsPcpBusinessTypeEnum typeEnum = CsPcpBusinessTypeEnum.getByCode((String)reqDto.getBusinessType());
        Assert.isTrue((typeEnum != null ? 1 : 0) != 0, (String)ExceptionCode.FAIL.getCode(), (String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b");
        switch (typeEnum) {
            case PURCHASE_REFUND: 
            case ORDER_SALES_OUT: 
            case ORDER_SALES_REFUND: 
            case OTHER_OUT: 
            case ALLOT_OUT: 
            case INTERNAL_DEAL: 
            case ALLOT_BC_EFFICACY: 
            case ALLOT_LOSE_EFFICACY: 
            case INSPECTION_QUALIFIED: 
            case INTERNAL_DEAL_RETURN: 
            case MAIYOU_ALLOT_OUT: {
                this.externalOutQimenWmsApi.stockoutCreate(this.transferStockoutCreateDto(reqDto));
                break;
            }
            case ACTIVITY_ORDER: 
            case INTEGRAL_ORDER: 
            case SPECIAL_CHANNEL_ORDER: {
                this.externalOutQimenWmsApi.deliveryOrderCreate(this.transferDeliveryCreateDto(reqDto));
                break;
            }
            default: {
                this.externalOutQimenWmsApi.stockoutCreate(this.transferStockoutCreateDto(reqDto));
            }
        }
        return null;
    }

    @Override
    public WmsBaseRespDto singleItemSynchronize(WmsStockReqDto wmsStockReqDto) {
        return new WmsBaseRespDto(JSONObject.toJSONString((Object)this.externalOutQimenWmsApi.singleItemSynchronize(this.transferSingleItemDto(wmsStockReqDto))));
    }

    @Override
    public WmsBaseRespDto cancel(WmsOrderCancelReqDto wmsOrderCancelReqDto) {
        try {
            OrderCancelResponse cancel = (OrderCancelResponse)this.externalOutQimenWmsApi.cancel(this.transferCancelDto(wmsOrderCancelReqDto)).getData();
            return new WmsBaseRespDto(cancel.isSuccess(), cancel.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new WmsBaseRespDto(false, e.getMessage());
        }
    }

    @Override
    public WmsBaseRespDto orderMerge(WmsOrderMergeReqDto reqDto) {
        RestResponse restResponse = this.externalOutQimenWmsApi.orderMerge(reqDto);
        JSONObject data = (JSONObject)Optional.ofNullable(restResponse.getData()).orElse(new JSONObject());
        return new WmsBaseRespDto(Objects.equals(data.getString("status"), "success"), data.getString("msg"));
    }

    private OrderCancelRequestDto transferCancelDto(WmsOrderCancelReqDto wmsOrderCancelReqDto) {
        OrderCancelRequestDto orderCancelRequestDto = new OrderCancelRequestDto();
        orderCancelRequestDto.setOrderId(wmsOrderCancelReqDto.getOrderCode());
        orderCancelRequestDto.setOrderCode(wmsOrderCancelReqDto.getOrderCode());
        orderCancelRequestDto.setOwnerCode("TCBJ");
        orderCancelRequestDto.setWarehouseCode(wmsOrderCancelReqDto.getWarehouseCode());
        orderCancelRequestDto.setOrderType(wmsOrderCancelReqDto.getOrderType());
        orderCancelRequestDto.setCustomerId(wmsOrderCancelReqDto.getCustomerId());
        return orderCancelRequestDto;
    }

    private SingleitemSynchronizeRequestDto transferSingleItemDto(WmsStockReqDto wmsStockReqDto) {
        SingleitemSynchronizeRequestDto singleitemSynchronizeRequestDto = new SingleitemSynchronizeRequestDto();
        singleitemSynchronizeRequestDto.setOwnerCode(wmsStockReqDto.getOwnerCode());
        singleitemSynchronizeRequestDto.setWarehouseCode(wmsStockReqDto.getWarehouseCode());
        singleitemSynchronizeRequestDto.setActionType("add");
        singleitemSynchronizeRequestDto.setItem(this.buildItem(wmsStockReqDto));
        singleitemSynchronizeRequestDto.setCustomerId(wmsStockReqDto.getCustomerId());
        singleitemSynchronizeRequestDto.setExtendPropsDto(this.buildItemExtend(wmsStockReqDto));
        return singleitemSynchronizeRequestDto;
    }

    private SingleitemSynchronizeRequestDto.ExtendProps buildItemExtend(WmsStockReqDto wmsStockReqDto) {
        SingleitemSynchronizeRequestDto.ExtendProps extendProps = new SingleitemSynchronizeRequestDto.ExtendProps();
        BeanUtil.copyProperties((Object)wmsStockReqDto, (Object)extendProps, (String[])new String[0]);
        extendProps.setImeiCodeFlag(Objects.equals(wmsStockReqDto.getImeiCodeFlag(), "Y") ? "True" : "False");
        extendProps.setOldStandardApproval(wmsStockReqDto.getOldApproval());
        extendProps.setCfProducers(wmsStockReqDto.getCfproducers());
        extendProps.setBigRatio(BigDecimalUtils.parse(null == wmsStockReqDto.getBigRatio() ? null : wmsStockReqDto.getBigRatio().toString()));
        extendProps.setSmallRatio(BigDecimalUtils.parse(null == wmsStockReqDto.getSmallRatio() ? null : wmsStockReqDto.getSmallRatio().toString()));
        extendProps.setMiddleRatio(BigDecimalUtils.parse(null == wmsStockReqDto.getMiddleRatio() ? null : wmsStockReqDto.getMiddleRatio().toString()));
        extendProps.setOldItemName(wmsStockReqDto.getOldItemName());
        if (!Objects.isNull(wmsStockReqDto.getEnableDate())) {
            extendProps.setEnableDate(DateUtil.format((Date)wmsStockReqDto.getEnableDate()));
        }
        if (!Objects.isNull(wmsStockReqDto.getDisableDate())) {
            extendProps.setDisableDate(DateUtil.format((Date)wmsStockReqDto.getDisableDate()));
        }
        return extendProps;
    }

    private SingleitemSynchronizeRequest.Item buildItem(WmsStockReqDto wmsStockReqDto) {
        SingleitemSynchronizeRequest.Item item = new SingleitemSynchronizeRequest.Item();
        item.setItemId(String.valueOf(wmsStockReqDto.getId()));
        item.setItemCode(wmsStockReqDto.getLongCode());
        item.setUnit(wmsStockReqDto.getUnit());
        item.setItemName(wmsStockReqDto.getName());
        item.setBarCode(wmsStockReqDto.getBarCode());
        item.setBrandName(wmsStockReqDto.getBrandName());
        item.setItemType(String.valueOf(wmsStockReqDto.getType()));
        item.setBrandCode(wmsStockReqDto.getBrandCode());
        item.setApprovalNumber(wmsStockReqDto.getStandardApproval());
        item.setStockUnit(wmsStockReqDto.getUnit());
        item.setIsSNMgmt(Objects.equals(wmsStockReqDto.getImeiCodeFlag(), "Y") ? "True" : "False");
        item.setPcs(wmsStockReqDto.getSpecification());
        item.setWidth(Optional.ofNullable(wmsStockReqDto.getWidth()).map(r -> r.toString()).orElse(""));
        item.setLength(Optional.ofNullable(wmsStockReqDto.getLength()).map(r -> r.toString()).orElse(""));
        item.setHeight(Optional.ofNullable(wmsStockReqDto.getHeight()).map(r -> r.toString()).orElse(""));
        item.setVolume(Optional.ofNullable(wmsStockReqDto.getVolume()).map(r -> r.toString()).orElse(""));
        item.setGrossWeight(Optional.ofNullable(wmsStockReqDto.getGrossWeight()).map(r -> r.toString()).orElse(""));
        item.setNetWeight(Optional.ofNullable(wmsStockReqDto.getNetWeight()).map(r -> r.toString()).orElse(""));
        item.setCategoryName(wmsStockReqDto.getDosageForm());
        item.setShelfLife(Optional.ofNullable(wmsStockReqDto.getExpirationDate()).filter(StringUtils::isNotBlank).map(r -> Objects.equals("\u5e74", wmsStockReqDto.getExpirationUnit()) ? Long.valueOf(wmsStockReqDto.getExpirationDate()) * 12L : Long.valueOf(wmsStockReqDto.getExpirationDate())).orElse(0L));
        item.setIsValid(Objects.equals(wmsStockReqDto.getStatus(), 1) ? "Y" : "N");
        item.setIsLiquid(wmsStockReqDto.getDosageForm());
        item.setSize(wmsStockReqDto.getSpecification());
        return item;
    }

    private DeliveryorderCreateRequestDto transferDeliveryCreateDto(WmsStockOutOrderReqDto reqDto) {
        DeliveryorderCreateRequestDto deliveryorderCreateRequestDto = new DeliveryorderCreateRequestDto();
        deliveryorderCreateRequestDto.setCustomerId(reqDto.getCustomerId());
        deliveryorderCreateRequestDto.setDeliveryOrder(this.buildDeliveryDeliveryOrder(reqDto));
        deliveryorderCreateRequestDto.setExtendProps(this.getDeliveryExtendProps(reqDto));
        deliveryorderCreateRequestDto.setOrderLines(reqDto.getItemLines().stream().map(item -> {
            DeliveryorderCreateRequestDto.OrderLine orderLine = new DeliveryorderCreateRequestDto.OrderLine();
            orderLine.setOrderLineNo(item.getTradeOrderItemId());
            orderLine.setItemCode(this.parseItemCode(item.getItemCode(), item.getCargoCode()));
            orderLine.setItemId(item.getCargoCode());
            orderLine.setItemName(item.getCargoName());
            orderLine.setPlanQty(item.getPlanQuantity().toString());
            orderLine.setBatchCode(item.getBatch());
            orderLine.setProductCode(item.getBatch());
            orderLine.setProduceCode(item.getBatch());
            orderLine.setProductDate(item.getProductDate());
            orderLine.setExpireDate(item.getArrivalDate());
            orderLine.setActualPrice(item.getPrice().toString());
            orderLine.setAmount(item.getAmount().toString());
            orderLine.setExtCode(item.getIntegral() != false ? "1" : "0");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("je", Optional.ofNullable(item.getAmount()).orElse(BigDecimal.ZERO).toString());
            map.put("barCode", item.getCargoCode());
            map.put("dj", Optional.ofNullable(item.getSkuPrice()).orElse(BigDecimal.ZERO).toString());
            map.put("isPointsExchange", item.getIntegral() != false ? 1 : 0);
            orderLine.setExtendProps(map);
            return orderLine;
        }).collect(Collectors.toList()));
        return deliveryorderCreateRequestDto;
    }

    private String parseItemCode(String itemCode, String cargoCode) {
        return Optional.ofNullable(itemCode).orElseGet(() -> cargoCode.substring(cargoCode.lastIndexOf(".") + 1));
    }

    private Map getDeliveryExtendProps(WmsStockOutOrderReqDto reqDto) {
        return this.getStockoutExtendProps(reqDto);
    }

    private StockoutCreateRequestDto transferStockoutCreateDto(WmsStockOutOrderReqDto reqDto) {
        StockoutCreateRequestDto stockoutCreateRequestDto = new StockoutCreateRequestDto();
        stockoutCreateRequestDto.setCustomerId(reqDto.getCustomerId());
        stockoutCreateRequestDto.setDeliveryOrder(this.buildDeliveryOrder(reqDto));
        stockoutCreateRequestDto.setExtendProps(this.getStockoutExtendProps(reqDto));
        stockoutCreateRequestDto.setOrderLines(reqDto.getItemLines().stream().map(item -> {
            StockoutCreateRequestDto.OrderLine orderLine = new StockoutCreateRequestDto.OrderLine();
            orderLine.setOrderLineNo(item.getTradeOrderItemId());
            orderLine.setOwnerCode(reqDto.getOwnerCode());
            orderLine.setItemCode(this.parseItemCode(item.getItemCode(), item.getCargoCode()));
            orderLine.setItemId(item.getCargoCode());
            orderLine.setItemName(item.getCargoName());
            orderLine.setPlanQty(item.getPlanQuantity().toString());
            orderLine.setBatchCode(item.getBatch());
            orderLine.setProductCode(item.getBatch());
            orderLine.setProduceCode(item.getBatch());
            orderLine.setProductDate(item.getProductDate());
            orderLine.setExpireDate(item.getArrivalDate());
            orderLine.setActualPrice(item.getPrice().toString());
            orderLine.setAmount(item.getAmount().toString());
            orderLine.setExtCode(item.getIntegral() != false ? "1" : "0");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("je", Optional.ofNullable(item.getAmount()).orElse(BigDecimal.ZERO).toString());
            map.put("barCode", item.getCargoCode());
            map.put("dj", Optional.ofNullable(item.getSkuPrice()).orElse(BigDecimal.ZERO).toString());
            map.put("isPointsExchange", item.getIntegral() != false ? 1 : 0);
            map.put("intransitInfo", item.getIntransitInfo());
            orderLine.setExtendProps(map);
            return orderLine;
        }).collect(Collectors.toList()));
        return stockoutCreateRequestDto;
    }

    private Map getStockoutExtendProps(WmsStockOutOrderReqDto reqDto) {
        StockoutCreateRequestDto.ExtendProps extendProps = new StockoutCreateRequestDto.ExtendProps();
        extendProps.setOutboundLogicWarehouse(reqDto.getLogicWarehouseCode());
        extendProps.setOutboundLogicWarehouseName(reqDto.getLogicWarehouseName());
        extendProps.setOutboundPhysicsWarehouseCode(reqDto.getWarehouseCode());
        extendProps.setOutboundOwnerCode(Optional.ofNullable(reqDto.getOrganizationCode()).orElse("TCBJ"));
        extendProps.setKmhMasterOrderCode(reqDto.getKmhMasterOrderCode());
        extendProps.setSettlementOrg(reqDto.getSapCkdm());
        extendProps.setSettlementOrgName(reqDto.getSettlementOrgName());
        extendProps.setKmhOrderSplitNum(reqDto.getOrderSplitNum());
        extendProps.setEasOrigOrderNo(reqDto.getThirdOrigOrderNo());
        extendProps.setSaleCustomerCode(reqDto.getSaleCustomerCode());
        extendProps.setSaleCustomerName(reqDto.getSaleCustomerName());
        extendProps.setMasterOrderCode(reqDto.getMasterOrderCode());
        extendProps.setMasterOrderSpiltNum(reqDto.getMasterOrderSpiltNum());
        Optional.ofNullable(reqDto.getReceiverInfo()).ifPresent(re -> {
            extendProps.setInboundOwnerCode(Optional.ofNullable(re.getOrganizationCode()).orElse("TCBJ"));
            extendProps.setInboundLogicWarehouse(re.getLogicWarehouseCode());
            extendProps.setInboundLogicWarehouseName(re.getLogicWarehouseName());
            extendProps.setInboundPhysicsWarehouseCode(re.getWarehouseCode());
        });
        if (CsPcpBusinessTypeEnum.PRODUCTION_MATERIALS.getCode().equals(reqDto.getBusinessType())) {
            CsOutPlannedOrderPageQueryDto queryDto = new CsOutPlannedOrderPageQueryDto();
            queryDto.setOrderNo(reqDto.getRelevanceNo());
            queryDto.setOrderType(reqDto.getBusinessType());
            List list = (List)RestResponseHelper.extractData((RestResponse)this.csOutPlannedOrderQueryApi.queryList(queryDto));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                CsOutPlannedOrderRespDto respDto = (CsOutPlannedOrderRespDto)list.get(0);
                extendProps.setInboundLogicWarehouse(respDto.getProductionWarehouseCode());
            }
        }
        extendProps.setSapCkdm(reqDto.getOrganizationCode());
        extendProps.setEasCode(reqDto.getThirdOrderNo());
        extendProps.setKmhOrderTag(CollectionUtils.isNotEmpty((Collection)reqDto.getOrderTagList()) && (reqDto.getOrderTagList().contains("GS001") || reqDto.getOrderTagList().contains("YPH")) ? "1" : "0");
        extendProps.setCkCode(reqDto.getWarehouseCode());
        extendProps.setBusinessType(reqDto.getBusinessType());
        extendProps.setFinancialPrint(String.valueOf(Optional.ofNullable(reqDto.getFinancialPrint()).orElse(0)));
        extendProps.setReportsPrint(reqDto.getReportsPrint());
        extendProps.setExtraMaterial(reqDto.getExtraMaterial());
        extendProps.setReceiveCustomerCode(reqDto.getReceiveCustomerCode());
        if (StringUtils.isBlank((CharSequence)extendProps.getReceiveCustomerCode())) {
            extendProps.setReceiveCustomerCode(Optional.ofNullable(reqDto.getReceiverInfo()).map(WmsStockOutOrderReqDto.ReceiverInfo::getCustomerCode).orElse(""));
        }
        extendProps.setReceiveCustomerName(reqDto.getReceiveCustomerName());
        extendProps.setClaimCustomerCode(reqDto.getClaimCustomerCode());
        extendProps.setOmsordercode(reqDto.getRelevanceNo());
        extendProps.setDbCrmOrderNo(reqDto.getDbCrmOrderNo());
        extendProps.setOmsOrderMasterCode(reqDto.getSaleOrderNo());
        extendProps.setSaleschannel(reqDto.getOrderSrc());
        extendProps.setIdLogicalAllot(reqDto.getIdLogicalAllot());
        extendProps.setCrmOrderNo(reqDto.getCrmOrderNo());
        extendProps.setOrderRemark(reqDto.getRemark());
        extendProps.setFCompanyOrg(Optional.ofNullable(reqDto.getSettlementOrgName()).orElse(reqDto.getOrganizationName()));
        if (StringUtils.contains((CharSequence)extendProps.getOmsordercode(), (CharSequence)"DD")) {
            BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(extendProps.getOmsordercode()));
            if (null != saleOrderRespDto) {
                extendProps.setFCompanyOrg(saleOrderRespDto.getOrganizationName());
            }
            extendProps.setSettlementOrg(saleOrderRespDto.getOrganizationCode());
            extendProps.setSettlementOrgName(saleOrderRespDto.getOrganizationName());
        }
        if (Objects.equals(CsPcpBusinessTypeEnum.ALLOT_SALE.getCode(), reqDto.getBusinessType())) {
            CsTransferOrderRespDto csTransferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(reqDto.getRelevanceNo()));
            BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(csTransferOrderRespDto.getSaleOrderNo()));
            if (null != saleOrderRespDto) {
                extendProps.setFCompanyOrg(saleOrderRespDto.getOrganizationName());
                extendProps.setSettlementOrg(saleOrderRespDto.getOrganizationCode());
                extendProps.setSettlementOrgName(saleOrderRespDto.getOrganizationName());
            }
            if (ObjectUtil.isNotEmpty((Object)reqDto.getReceiverInfo()) && StringUtils.isNotEmpty((CharSequence)reqDto.getReceiverInfo().getProvinceCode()) && StringUtils.isNotEmpty((CharSequence)reqDto.getWarehouseCode())) {
                WarehouseAreaMappingRespDto warehouseAreaMappingRespDto;
                WarehouseAreaMappingReqDto warehouseAreaMappingReqDto = new WarehouseAreaMappingReqDto();
                warehouseAreaMappingReqDto.setSourceWarehouseCode(reqDto.getWarehouseCode());
                warehouseAreaMappingReqDto.setProvinceCode(reqDto.getReceiverInfo().getProvinceCode());
                warehouseAreaMappingReqDto.setStatus(YesNoHelper.YES);
                warehouseAreaMappingReqDto.setPageNum(Integer.valueOf(1));
                warehouseAreaMappingReqDto.setPageSize(Integer.valueOf(1));
                List areaMappingRespDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iWarehouseAreaMappingApi.queryByPage(warehouseAreaMappingReqDto))).getList();
                logger.info("\u67e5\u8be2\u5230\u53d1\u8d27\u89c4\u5219\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)areaMappingRespDtoList));
                if (CollectionUtils.isNotEmpty((Collection)areaMappingRespDtoList) && StringUtils.isNotEmpty((CharSequence)(warehouseAreaMappingRespDto = (WarehouseAreaMappingRespDto)areaMappingRespDtoList.get(0)).getRemark())) {
                    extendProps.setOrderRemark(String.format("%s;%s", warehouseAreaMappingRespDto.getRemark(), Optional.ofNullable(extendProps.getOrderRemark()).orElse("")));
                }
            }
        }
        extendProps.setFinanceAuditTime(reqDto.getFinanceAuditTime());
        extendProps.setIntransitInfo(reqDto.getIntransitInfo());
        return (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)extendProps), Map.class);
    }

    private Map getEntryExtendProps(WmsStockEntryOrderReqDto reqDto) {
        EntryorderCreateRequestDto.ExtendProps extendProps = new EntryorderCreateRequestDto.ExtendProps();
        extendProps.setInboundOwnerCode(Optional.ofNullable(reqDto.getOrganizationCode()).orElse("TCBJ"));
        extendProps.setInboundLogicWarehouse(reqDto.getLogicWarehouseCode());
        extendProps.setInboundLogicWarehouseName(reqDto.getLogicWarehouseName());
        extendProps.setInboundPhysicsWarehouseCode(reqDto.getWarehouseCode());
        extendProps.setRklxCode(reqDto.getOrganizationCode());
        extendProps.setSapCkdm(reqDto.getOrganizationCode());
        extendProps.setCkCode(reqDto.getWarehouseCode());
        extendProps.setBusinessType(reqDto.getBusinessType());
        extendProps.setEasCode(reqDto.getThirdOrderNo());
        extendProps.setCrmOrderNo(reqDto.getCrmOrderNo());
        extendProps.setFCompanyOrg(reqDto.getOrganizationName());
        extendProps.setReceiveCustomerName(reqDto.getReceiveCustomerName());
        extendProps.setOrderRemark(reqDto.getRemark());
        extendProps.setClaimCustomerCode(reqDto.getClaimCustomerCode());
        extendProps.setOrderLineDetails(reqDto.getExtensionExternal());
        Optional.ofNullable(reqDto.getCustomerCode()).ifPresent(code -> extendProps.setReceiveCustomerCode(reqDto.getCustomerCode()));
        return (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)extendProps), Map.class);
    }

    private StockoutCreateRequestDto.DeliveryOrder buildDeliveryOrder(WmsStockOutOrderReqDto reqDto) {
        StockoutCreateRequestDto.DeliveryOrder deliveryOrder = new StockoutCreateRequestDto.DeliveryOrder();
        deliveryOrder.setDeliveryOrderCode(reqDto.getDocumentNo());
        deliveryOrder.setOwnerCode(reqDto.getOwnerCode());
        deliveryOrder.setWarehouseCode(reqDto.getLogicWarehouseCode());
        deliveryOrder.setTargetWarehouseName(reqDto.getWarehouseName());
        deliveryOrder.setTransportMode("\u9001\u8d27");
        deliveryOrder.setCreateTime(reqDto.getCreateTime());
        deliveryOrder.setOrderType(this.getOrderType(reqDto.getBusinessType()));
        deliveryOrder.setSupplierCode(Optional.ofNullable(reqDto.getSupplierCode()).orElse(Optional.ofNullable(reqDto.getOrganizationCode()).orElse("0102")));
        deliveryOrder.setSupplierName(reqDto.getOrganizationName());
        deliveryOrder.setLogisticsCode(reqDto.getLogisticsCode());
        deliveryOrder.setLogisticsName(reqDto.getLogisticsName());
        deliveryOrder.setRemark((CollectionUtils.isNotEmpty((Collection)reqDto.getOrderTagList()) && reqDto.getOrderTagList().contains("GS001") ? "\u5f00\u95e8\u7ea2;" : "") + Optional.ofNullable(reqDto.getRemark()).filter(StringUtils::isNotBlank).orElse(""));
        if (Objects.equals(WarehouseAreaMappingTypeEnum.ALLOT_SALE.getCode(), reqDto.getBusinessType())) {
            this.getRemark(reqDto, deliveryOrder);
        }
        deliveryOrder.setReceiverInfo(this.buildReceiverInfo(reqDto));
        deliveryOrder.setSenderInfo(this.buildOutSenderInfo(reqDto));
        return deliveryOrder;
    }

    private void getRemark(WmsStockOutOrderReqDto reqDto, StockoutCreateRequestDto.DeliveryOrder deliveryOrder) {
        if (ObjectUtil.isNotEmpty((Object)reqDto.getReceiverInfo()) && StringUtils.isNotEmpty((CharSequence)reqDto.getReceiverInfo().getProvinceCode()) && StringUtils.isNotEmpty((CharSequence)reqDto.getWarehouseCode())) {
            WarehouseAreaMappingRespDto warehouseAreaMappingRespDto;
            WarehouseAreaMappingReqDto warehouseAreaMappingReqDto = new WarehouseAreaMappingReqDto();
            warehouseAreaMappingReqDto.setSourceWarehouseCode(reqDto.getWarehouseCode());
            warehouseAreaMappingReqDto.setProvinceCode(reqDto.getReceiverInfo().getProvinceCode());
            warehouseAreaMappingReqDto.setStatus(YesNoHelper.YES);
            warehouseAreaMappingReqDto.setPageNum(Integer.valueOf(1));
            warehouseAreaMappingReqDto.setPageSize(Integer.valueOf(1));
            List areaMappingRespDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.iWarehouseAreaMappingApi.queryByPage(warehouseAreaMappingReqDto))).getList();
            logger.info("\u67e5\u8be2\u5230\u53d1\u8d27\u89c4\u5219\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)areaMappingRespDtoList));
            if (CollectionUtils.isNotEmpty((Collection)areaMappingRespDtoList) && StringUtils.isNotEmpty((CharSequence)(warehouseAreaMappingRespDto = (WarehouseAreaMappingRespDto)areaMappingRespDtoList.get(0)).getRemark())) {
                deliveryOrder.setRemark(String.format("%s;%s", warehouseAreaMappingRespDto.getRemark(), Optional.ofNullable(deliveryOrder.getRemark()).orElse("")));
            }
        }
    }

    private DeliveryorderCreateRequestDto.DeliveryOrder buildDeliveryDeliveryOrder(WmsStockOutOrderReqDto reqDto) {
        DeliveryorderCreateRequestDto.DeliveryOrder deliveryOrder = new DeliveryorderCreateRequestDto.DeliveryOrder();
        deliveryOrder.setDeliveryOrderCode(reqDto.getDocumentNo());
        deliveryOrder.setWarehouseCode(reqDto.getLogicWarehouseCode());
        deliveryOrder.setCreateTime(reqDto.getCreateTime());
        deliveryOrder.setOwnerCode(reqDto.getOwnerCode());
        deliveryOrder.setTransportMode("\u9001\u8d27");
        deliveryOrder.setSourcePlatformCode(Optional.ofNullable(reqDto.getSourcePlatformCode()).orElse("OTHERS"));
        deliveryOrder.setOrderType(this.getOrderType(reqDto.getBusinessType()));
        deliveryOrder.setSupplierCode(Optional.ofNullable(reqDto.getOrganizationCode()).orElse("0102"));
        deliveryOrder.setSupplierName(reqDto.getOrganizationName());
        deliveryOrder.setLogisticsCode(reqDto.getLogisticsCode());
        deliveryOrder.setLogisticsName(reqDto.getLogisticsName());
        deliveryOrder.setRemark(CollectionUtils.isNotEmpty((Collection)reqDto.getOrderTagList()) && reqDto.getOrderTagList().contains("GS001") ? "\u5f00\u95e8\u7ea2;" : "" + reqDto.getRemark());
        deliveryOrder.setReceiverInfo(this.buildDeliveryReceiverInfo(reqDto));
        deliveryOrder.setSenderInfo(this.buildDeliveryOutSenderInfo(reqDto));
        return deliveryOrder;
    }

    private DeliveryorderCreateRequestDto.SenderInfo buildDeliveryOutSenderInfo(WmsStockOutOrderReqDto reqDto) {
        return Optional.ofNullable(reqDto.getSenderInfo()).map(orSenderInfo -> {
            DeliveryorderCreateRequestDto.SenderInfo senderInfo = new DeliveryorderCreateRequestDto.SenderInfo();
            senderInfo.setName(orSenderInfo.getContacts());
            senderInfo.setArea(Optional.ofNullable(orSenderInfo.getDistrict()).orElseGet(() -> this.getAreaByCode(orSenderInfo.getAreaCode())));
            senderInfo.setProvince(Optional.ofNullable(orSenderInfo.getProvince()).orElseGet(() -> this.getAreaByCode(orSenderInfo.getProvinceCode())));
            senderInfo.setCity(Optional.ofNullable(orSenderInfo.getCity()).orElseGet(() -> this.getAreaByCode(orSenderInfo.getCityCode())));
            senderInfo.setDetailAddress(orSenderInfo.getDetailAddress());
            senderInfo.setMobile(orSenderInfo.getPhone());
            senderInfo.setTel(orSenderInfo.getPhone());
            senderInfo.setZipCode(orSenderInfo.getPostalCode());
            senderInfo.setCountryCode(orSenderInfo.getCountryCode());
            return senderInfo;
        }).orElse(null);
    }

    private DeliveryorderCreateRequestDto.ReceiverInfo buildDeliveryReceiverInfo(WmsStockOutOrderReqDto reqDto) {
        DeliveryorderCreateRequestDto.ReceiverInfo receiverInfo = new DeliveryorderCreateRequestDto.ReceiverInfo();
        WmsStockOutOrderReqDto.ReceiverInfo ogReceiverInfo = reqDto.getReceiverInfo();
        receiverInfo.setName(ogReceiverInfo.getContacts());
        receiverInfo.setArea(Optional.ofNullable(ogReceiverInfo.getDistrict()).orElseGet(() -> this.getAreaByCode(ogReceiverInfo.getAreaCode())));
        receiverInfo.setProvince(Optional.ofNullable(ogReceiverInfo.getProvince()).orElseGet(() -> this.getAreaByCode(ogReceiverInfo.getProvinceCode())));
        receiverInfo.setCity(Optional.ofNullable(ogReceiverInfo.getCity()).orElseGet(() -> this.getAreaByCode(ogReceiverInfo.getCityCode())));
        receiverInfo.setDetailAddress(ogReceiverInfo.getDetailAddress());
        receiverInfo.setMobile(ogReceiverInfo.getPhone());
        receiverInfo.setTel(ogReceiverInfo.getPhone());
        receiverInfo.setZipCode(ogReceiverInfo.getPostalCode());
        receiverInfo.setCountryCode(ogReceiverInfo.getCountryCode());
        receiverInfo.setCompany(reqDto.getOrganizationName());
        if (!Optional.ofNullable(ogReceiverInfo.getDetailAddress()).orElse("").startsWith(Optional.ofNullable(receiverInfo.getProvince()).orElse(""))) {
            receiverInfo.setDetailAddress(receiverInfo.getProvince() + receiverInfo.getCity() + receiverInfo.getArea() + receiverInfo.getDetailAddress());
        }
        return receiverInfo;
    }

    private StockoutCreateRequest.SenderInfo buildOutSenderInfo(WmsStockOutOrderReqDto reqDto) {
        return Optional.ofNullable(reqDto.getSenderInfo()).map(orSenderInfo -> {
            StockoutCreateRequest.SenderInfo senderInfo = new StockoutCreateRequest.SenderInfo();
            senderInfo.setName(orSenderInfo.getContacts());
            senderInfo.setArea(Optional.ofNullable(orSenderInfo.getAreaCode()).orElseGet(() -> this.getAreaByCode(orSenderInfo.getAreaCode())));
            senderInfo.setProvince(Optional.ofNullable(orSenderInfo.getProvince()).orElseGet(() -> this.getAreaByCode(orSenderInfo.getProvinceCode())));
            senderInfo.setCity(Optional.ofNullable(orSenderInfo.getCity()).orElseGet(() -> this.getAreaByCode(orSenderInfo.getCityCode())));
            senderInfo.setDetailAddress(orSenderInfo.getDetailAddress());
            senderInfo.setMobile(orSenderInfo.getPhone());
            senderInfo.setTel(orSenderInfo.getPhone());
            senderInfo.setZipCode(orSenderInfo.getPostalCode());
            senderInfo.setCountryCode(orSenderInfo.getCountryCode());
            return senderInfo;
        }).orElse(null);
    }

    private StockoutCreateRequest.ReceiverInfo buildReceiverInfo(WmsStockOutOrderReqDto reqDto) {
        return Optional.ofNullable(reqDto.getReceiverInfo()).map(ogReceiverInfo -> {
            StockoutCreateRequest.ReceiverInfo receiverInfo = new StockoutCreateRequest.ReceiverInfo();
            receiverInfo.setName(ogReceiverInfo.getContacts());
            receiverInfo.setArea(Optional.ofNullable(ogReceiverInfo.getDistrict()).orElseGet(() -> this.getAreaByCode(ogReceiverInfo.getAreaCode())));
            receiverInfo.setProvince(Optional.ofNullable(ogReceiverInfo.getProvince()).orElseGet(() -> this.getAreaByCode(ogReceiverInfo.getProvinceCode())));
            receiverInfo.setCity(Optional.ofNullable(ogReceiverInfo.getCity()).orElseGet(() -> this.getAreaByCode(ogReceiverInfo.getCityCode())));
            receiverInfo.setDetailAddress(ogReceiverInfo.getDetailAddress());
            receiverInfo.setMobile(ogReceiverInfo.getPhone());
            receiverInfo.setTel(ogReceiverInfo.getPhone());
            receiverInfo.setZipCode(ogReceiverInfo.getPostalCode());
            receiverInfo.setCountryCode(ogReceiverInfo.getCountryCode());
            receiverInfo.setId(Optional.ofNullable(ogReceiverInfo.getCustomerCode()).orElse(ogReceiverInfo.getCustomerCode()));
            if (!Optional.ofNullable(ogReceiverInfo.getDetailAddress()).orElse("").startsWith(Optional.ofNullable(receiverInfo.getProvince()).orElse(""))) {
                receiverInfo.setDetailAddress(receiverInfo.getProvince() + receiverInfo.getCity() + receiverInfo.getArea() + receiverInfo.getDetailAddress());
            }
            return receiverInfo;
        }).orElse(null);
    }

    @Override
    public WmsBaseRespDto supplierSynchronize(WmsCustomerReqDto wmsCustomerReqDto) {
        return new WmsBaseRespDto(JSONObject.toJSONString((Object)this.externalOutQimenWmsApi.ocsToWms(this.transferSupplierToWmsDto(wmsCustomerReqDto))));
    }

    private SupplierSynchronizeRequestDto transferSupplierDto(WmsCustomerReqDto wmsCustomerReqDto) {
        logger.info("\u540c\u6b65\u5ba2\u6237\u4fe1\u606f==>{}", (Object)JSONObject.toJSONString((Object)wmsCustomerReqDto));
        SupplierSynchronizeRequestDto supplierSynchronizeRequestDto = new SupplierSynchronizeRequestDto();
        if (wmsCustomerReqDto.getId() != null && wmsCustomerReqDto.getId() > 0L) {
            supplierSynchronizeRequestDto.setActionType("update");
        } else {
            supplierSynchronizeRequestDto.setActionType("add");
        }
        supplierSynchronizeRequestDto.setCustomerId(wmsCustomerReqDto.getCustomerId());
        supplierSynchronizeRequestDto.setSupplierCode(wmsCustomerReqDto.getCode());
        supplierSynchronizeRequestDto.setSupplierName(wmsCustomerReqDto.getName());
        supplierSynchronizeRequestDto.setOwnerCode(wmsCustomerReqDto.getOwnerCode());
        supplierSynchronizeRequestDto.setWarehouseCode(wmsCustomerReqDto.getWarehouseCode());
        supplierSynchronizeRequestDto.setExtendPropsDto(this.buildSupplierExtend(wmsCustomerReqDto));
        return supplierSynchronizeRequestDto;
    }

    private SupplierSynchronizeRequestDto.ExtendProps buildSupplierExtend(WmsCustomerReqDto wmsCustomerReqDto) {
        SupplierSynchronizeRequestDto requestDto = new SupplierSynchronizeRequestDto();
        SupplierSynchronizeRequestDto.ExtendProps extendProps = new SupplierSynchronizeRequestDto.ExtendProps(requestDto);
        extendProps.setReportsPrint(wmsCustomerReqDto.getReportsPrint());
        extendProps.setShipmentEnterprise(wmsCustomerReqDto.getShipmentEnterprise());
        extendProps.setFinancialPrint(wmsCustomerReqDto.getFinancialPrint());
        extendProps.setExtraMaterial(wmsCustomerReqDto.getExtraMaterial());
        extendProps.setInformationRemarks(wmsCustomerReqDto.getInformationRemarks());
        extendProps.setThirdParentPartyId(wmsCustomerReqDto.getThirdParentPartyId());
        extendProps.setCustomerStatus(Integer.valueOf(1));
        if (Objects.nonNull(wmsCustomerReqDto.getStatusId()) && wmsCustomerReqDto.getStatusId().compareTo(1256288052502004816L) == 0) {
            extendProps.setCustomerStatus(Integer.valueOf(0));
        }
        return extendProps;
    }

    @Override
    public WmsBaseRespDto orderMergeToWms(WmsOrderMergeReqDto wmsOrderMergeReqDto) {
        return new WmsBaseRespDto(JSONObject.toJSONString((Object)this.externalOutQimenWmsApi.ocsToWms(this.mergeToWmsDto(wmsOrderMergeReqDto))));
    }

    @Override
    public WmsBaseRespDto returnOrderCreate(WmsReturnOrderCreateReqDto wmsReturnOrderCreateReqDto) {
        return new WmsBaseRespDto(JSONObject.toJSONString((Object)this.externalOutQimenWmsApi.returnOrderCreate(this.returnOrderToWmsDto(wmsReturnOrderCreateReqDto))));
    }

    private StoreprocessCreateRequestDto mergeToWmsDto(WmsOrderMergeReqDto orderMergeReqDto) {
        StoreprocessCreateRequestDto storeprocessCreateRequestDto = new StoreprocessCreateRequestDto();
        ReturnorderCreateRequest.ReturnOrder returnOrder = new ReturnorderCreateRequest.ReturnOrder();
        returnOrder.setReturnOrderCode(orderMergeReqDto.getOrderCode());
        returnOrder.setWarehouseCode(orderMergeReqDto.getWarehouseCode());
        returnOrder.setPreDeliveryOrderCode(orderMergeReqDto.getOrderCode());
        returnOrder.setLogisticsCode("SF");
        returnOrder.setOrderType(QimenOrderTypeEnum.MERGE_ORDER.getCode());
        storeprocessCreateRequestDto.setReturnOrder(returnOrder);
        storeprocessCreateRequestDto.setCustomerId(orderMergeReqDto.getCustomerId());
        storeprocessCreateRequestDto.setOrderLines((List)Lists.newArrayList());
        HashMap<String, Object> extendPropsMap = new HashMap<String, Object>();
        extendPropsMap.put("kmhMasterOrderCode", orderMergeReqDto.getOrderCode());
        extendPropsMap.put("kmhOrderSplitNum", orderMergeReqDto.getMergeOrderNum());
        extendPropsMap.put("orderType", QimenOrderTypeEnum.MERGE_ORDER.getCode());
        storeprocessCreateRequestDto.setExtendProps(extendPropsMap);
        return storeprocessCreateRequestDto;
    }

    private ReturnorderCreateRequestDto returnOrderToWmsDto(WmsReturnOrderCreateReqDto wmsReturnOrderCreateReqDto) {
        ReturnorderCreateRequestDto returnorderCreateRequestDto = new ReturnorderCreateRequestDto();
        returnorderCreateRequestDto.setCustomerId(wmsReturnOrderCreateReqDto.getCustomerId());
        ReturnorderCreateRequestDto.ReturnOrder returnOrder = new ReturnorderCreateRequestDto.ReturnOrder();
        returnOrder.setReturnOrderCode(wmsReturnOrderCreateReqDto.getExtendInfo().getDocumentNo());
        returnOrder.setOrderType(Optional.ofNullable(wmsReturnOrderCreateReqDto.getExtendInfo().getOrderType()).orElse("transport_order"));
        returnOrder.setWarehouseCode(wmsReturnOrderCreateReqDto.getExtendInfo().getPhysicWarehouseCode());
        returnorderCreateRequestDto.setReturnOrder(returnOrder);
        ArrayList orderLines = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)wmsReturnOrderCreateReqDto.getItemLines())) {
            for (WmsItemLine itemLine : wmsReturnOrderCreateReqDto.getItemLines()) {
                ReturnorderCreateRequestDto.OrderLine orderLine = new ReturnorderCreateRequestDto.OrderLine();
                orderLine.setOrderLineNo(itemLine.getTradeOrderItemId());
                orderLine.setOwnerCode(wmsReturnOrderCreateReqDto.getOwnerCode());
                orderLine.setItemCode(this.parseItemCode(itemLine.getItemCode(), itemLine.getCargoCode()));
                orderLine.setItemId(itemLine.getCargoCode());
                orderLine.setItemName(itemLine.getCargoName());
                orderLine.setPlanQty(Long.valueOf(itemLine.getPlanQuantity().longValue()));
                orderLine.setBatchCode(itemLine.getBatch());
                orderLine.setProductCode(itemLine.getBatch());
                orderLine.setProduceCode(itemLine.getBatch());
                orderLine.setProductDate(itemLine.getProductDate());
                orderLine.setExpireDate(itemLine.getArrivalDate());
                orderLine.setActualPrice(itemLine.getPrice().toString());
                orderLine.setAmount(itemLine.getAmount().toString());
                orderLine.setExtCode(itemLine.getIntegral() != false ? "1" : "0");
                orderLines.add(orderLine);
            }
        }
        returnorderCreateRequestDto.setOrderLines((List)orderLines);
        returnorderCreateRequestDto.setSenderInfo(returnorderCreateRequestDto.getSenderInfo());
        Map extendPropsMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)wmsReturnOrderCreateReqDto.getExtendInfo()), Map.class);
        returnorderCreateRequestDto.setExtendProps(extendPropsMap);
        return returnorderCreateRequestDto;
    }

    private StoreprocessCreateRequestDto transferSupplierToWmsDto(WmsCustomerReqDto wmsCustomerReqDto) {
        StoreprocessCreateRequestDto storeprocessCreateRequestDto = new StoreprocessCreateRequestDto();
        ReturnorderCreateRequest.ReturnOrder returnOrder = new ReturnorderCreateRequest.ReturnOrder();
        returnOrder.setReturnOrderCode(wmsCustomerReqDto.getCode());
        returnOrder.setWarehouseCode(wmsCustomerReqDto.getWarehouseCode());
        returnOrder.setPreDeliveryOrderCode(wmsCustomerReqDto.getCode());
        returnOrder.setLogisticsCode("SF");
        returnOrder.setOrderType(QimenOrderTypeEnum.CUSTOMER_INFO.getCode());
        storeprocessCreateRequestDto.setReturnOrder(returnOrder);
        storeprocessCreateRequestDto.setCustomerId(wmsCustomerReqDto.getCustomerId());
        storeprocessCreateRequestDto.setOrderLines((List)Lists.newArrayList());
        storeprocessCreateRequestDto.setExtendProps(this.buildSupplierExtendToMap(wmsCustomerReqDto));
        logger.info("\u540c\u6b65\u5ba2\u6237\u4fe1\u606f\u5171\u7528\u63a5\u53e3==>{}", (Object)JSONObject.toJSONString((Object)storeprocessCreateRequestDto));
        return storeprocessCreateRequestDto;
    }

    private Map<String, Object> buildSupplierExtendToMap(WmsCustomerReqDto wmsCustomerReqDto) {
        Map<String, Object> extendPropsMap = new HashMap();
        SupplierSynchronizeRequestDto requestDto = new SupplierSynchronizeRequestDto();
        SupplierSynchronizeRequestDto.ExtendProps extendProps = new SupplierSynchronizeRequestDto.ExtendProps(requestDto);
        extendProps.setReportsPrint(wmsCustomerReqDto.getReportsPrint());
        extendProps.setShipmentEnterprise(wmsCustomerReqDto.getShipmentEnterprise());
        extendProps.setFinancialPrint(wmsCustomerReqDto.getFinancialPrint());
        extendProps.setExtraMaterial(wmsCustomerReqDto.getExtraMaterial());
        extendProps.setInformationRemarks(wmsCustomerReqDto.getInformationRemarks());
        extendProps.setThirdParentPartyId(wmsCustomerReqDto.getThirdParentPartyId());
        extendProps.setCustomerStatus(Integer.valueOf(1));
        if (Objects.nonNull(wmsCustomerReqDto.getStatusId()) && wmsCustomerReqDto.getStatusId().compareTo(1256288052502004816L) == 0) {
            extendProps.setCustomerStatus(Integer.valueOf(0));
        }
        extendPropsMap = BeanUtil.beanToMap((Object)extendProps);
        String actionType = "add";
        if (wmsCustomerReqDto.getId() != null && wmsCustomerReqDto.getId() > 0L) {
            actionType = "update";
        }
        extendPropsMap.put("actionType", actionType);
        extendPropsMap.put("orderType", QimenOrderTypeEnum.CUSTOMER_INFO.getCode());
        extendPropsMap.put("supplierCode", wmsCustomerReqDto.getCode());
        extendPropsMap.put("supplierName", wmsCustomerReqDto.getName());
        return extendPropsMap;
    }
}

