/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.app.open.biz.service.IExternalOutService;
import com.dtyunxi.tcbj.app.open.biz.service.ISapCenterHandleService;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapModelTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.WarehouseDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.google.common.base.Functions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="SapCenterHandleWarehouseServiceImpl")
public class SapCenterHandleWarehouseServiceImpl
implements ISapCenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(SapCenterHandleWarehouseServiceImpl.class);
    @Resource
    private IExternalOutService externalOutService;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private ICsLogicWarehouseApi csLogicWarehouseApi;

    @Override
    public String getModelType() {
        return SapModelTypeEnum.WAREHOUSE.getValue();
    }

    @Override
    public void handle(Map<String, Object> reqDto) {
        List<WarehouseDto> warehouseList = this.externalOutService.queryWarehouseList();
        logger.info("\u62c9\u53d6sap\u903b\u8f91\u4ed3\u6761\u6570\uff1a{}\u6761", (Object)warehouseList.size());
        List warehouseCodes = warehouseList.stream().map(WarehouseDto::getLgort).filter(n -> StringUtils.isNotBlank((CharSequence)n)).distinct().collect(Collectors.toList());
        List orgCodes = warehouseList.stream().map(WarehouseDto::getZbukrs).filter(n -> StringUtils.isNotBlank((CharSequence)n)).distinct().collect(Collectors.toList());
        orgCodes.addAll(warehouseList.stream().map(WarehouseDto::getWerks).filter(n -> StringUtils.isNotBlank((CharSequence)n)).distinct().collect(Collectors.toList()));
        CsLogicWarehouseQueryDto queryDto = new CsLogicWarehouseQueryDto();
        queryDto.setWarehouseCodeList(warehouseCodes);
        List warehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseQueryApi.queryByParam(queryDto));
        logger.info("\u903b\u8f91\u4ed3\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)warehouseRespDtoList));
        Set duplicatedCodes = warehouseRespDtoList.stream().map(CsLogicWarehouseRespDto::getWarehouseCode).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!duplicatedCodes.isEmpty()) {
            logger.warn("\u4ee5\u4e0b warehouseCode \u5b58\u5728\u91cd\u590d\u8bb0\u5f55\uff0c\u5df2\u88ab\u6574\u7ec4\u8fc7\u6ee4: {}", duplicatedCodes);
        }
        Map warehouseMap = warehouseRespDtoList.stream().filter(dto -> dto.getWarehouseCode() != null).filter(dto -> !duplicatedCodes.contains(dto.getWarehouseCode())).collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, Function.identity()));
        List orgDtoList = (List)this.organizationQueryExtApi.queryOrgDetailByThirdCode(orgCodes).getData();
        logger.info("\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)orgDtoList));
        Map orgListMap = null;
        if (CollectionUtils.isNotEmpty((Collection)orgDtoList)) {
            orgListMap = orgDtoList.stream().collect(Collectors.toMap(OrgAdvDetailRespDto::getThirdOrgId, Functions.identity(), (n1, n2) -> n1));
        }
        for (WarehouseDto dto2 : warehouseList) {
            OrgAdvDetailRespDto inventoryOrg = new OrgAdvDetailRespDto();
            OrgAdvDetailRespDto costOrg = new OrgAdvDetailRespDto();
            try {
                CsLogicWarehouseRespDto warehouseRespDto = (CsLogicWarehouseRespDto)warehouseMap.get(dto2.getLgort());
                if (orgListMap != null) {
                    inventoryOrg = (OrgAdvDetailRespDto)orgListMap.get(dto2.getWerks());
                    costOrg = (OrgAdvDetailRespDto)orgListMap.get(dto2.getZbukrs());
                }
                if (Objects.nonNull(warehouseRespDto)) {
                    if (SapCenterHandleWarehouseServiceImpl.compareValues(warehouseRespDto.getOrganizationCode(), dto2.getWerks()) && SapCenterHandleWarehouseServiceImpl.compareValues(warehouseRespDto.getCargoEscheatageId(), dto2.getWerks()) && SapCenterHandleWarehouseServiceImpl.compareValues(warehouseRespDto.getCostOrg(), dto2.getZbukrs()) && SapCenterHandleWarehouseServiceImpl.compareValues(warehouseRespDto.getWarehouseCode(), dto2.getLgort()) && SapCenterHandleWarehouseServiceImpl.compareValues(warehouseRespDto.getWarehouseName(), dto2.getLgobe())) continue;
                    this.csLogicWarehouseApi.update(warehouseRespDto.getId(), this.getUpdateReqDto(dto2, inventoryOrg, costOrg));
                    continue;
                }
                this.csLogicWarehouseApi.add(this.getCreateReqDto(dto2, inventoryOrg, costOrg));
            }
            catch (Exception e) {
                logger.info("\u540c\u6b65\u4ed3\u5e93\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private CsLogicWarehouseUpdateReqDto getUpdateReqDto(WarehouseDto dto, OrgAdvDetailRespDto inventoryOrg, OrgAdvDetailRespDto costOrg) {
        CsLogicWarehouseUpdateReqDto warehouseUpdateReqDto = new CsLogicWarehouseUpdateReqDto();
        warehouseUpdateReqDto.setWarehouseName(dto.getLgobe());
        if (StringUtils.isNotBlank((CharSequence)dto.getConfigdeprecationcode())) {
            // empty if block
        }
        if (Objects.nonNull(inventoryOrg)) {
            warehouseUpdateReqDto.setOrganizationId(inventoryOrg.getId());
            warehouseUpdateReqDto.setOrganizationName(inventoryOrg.getName());
            warehouseUpdateReqDto.setOrganizationCode(inventoryOrg.getCode());
            warehouseUpdateReqDto.setCargoEscheatageId(inventoryOrg.getCode());
            warehouseUpdateReqDto.setCargoEscheatageName(inventoryOrg.getName());
        }
        if (Objects.nonNull(costOrg)) {
            warehouseUpdateReqDto.setCostOrgId(costOrg.getId());
            warehouseUpdateReqDto.setCostOrg(costOrg.getCode());
            warehouseUpdateReqDto.setCostOrgName(costOrg.getName());
        }
        logger.info("\u66f4\u65b0\u4ed3\u5e93\u5bf9\u8c61\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)warehouseUpdateReqDto));
        return warehouseUpdateReqDto;
    }

    private CsLogicWarehouseAddReqDto getCreateReqDto(WarehouseDto dto, OrgAdvDetailRespDto inventoryOrg, OrgAdvDetailRespDto costOrg) {
        CsLogicWarehouseAddReqDto csLogicWarehouseAddReqDto = new CsLogicWarehouseAddReqDto();
        csLogicWarehouseAddReqDto.setWarehouseStatus("initial");
        if (Objects.nonNull(inventoryOrg)) {
            csLogicWarehouseAddReqDto.setOrganizationId(inventoryOrg.getId());
            csLogicWarehouseAddReqDto.setOrganizationCode(inventoryOrg.getCode());
            csLogicWarehouseAddReqDto.setOrganizationName(inventoryOrg.getName());
            csLogicWarehouseAddReqDto.setCargoEscheatageId(inventoryOrg.getCode());
            csLogicWarehouseAddReqDto.setCargoEscheatageName(inventoryOrg.getName());
        }
        csLogicWarehouseAddReqDto.setWarehouseName(dto.getLgobe());
        csLogicWarehouseAddReqDto.setWarehouseCode(dto.getLgort());
        if (Objects.nonNull(costOrg)) {
            csLogicWarehouseAddReqDto.setCostOrgId(costOrg.getId());
            csLogicWarehouseAddReqDto.setCostOrg(costOrg.getCode());
            csLogicWarehouseAddReqDto.setCostOrgName(costOrg.getName());
        }
        csLogicWarehouseAddReqDto.setCreatePerson("SAP");
        csLogicWarehouseAddReqDto.setUpdatePerson("SAP");
        logger.info("\u65b0\u589e\u4ed3\u5e93\u5bf9\u8c61\u5904\u7406\uff1a{}", (Object)JSONObject.toJSONString((Object)csLogicWarehouseAddReqDto));
        return csLogicWarehouseAddReqDto;
    }

    private static <T> boolean compareValues(T value1, T value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }
}

