/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.tcbj.app.open.biz.config.FinanceZTConfig;
import com.dtyunxi.tcbj.app.open.biz.service.impl.ExternalClientAbstract;
import com.dtyunxi.tcbj.center.openapi.common.finance.dto.FinanceZTApiResponse;
import com.dtyunxi.tcbj.center.openapi.common.finance.dto.FinanceZTTokenRespDto;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FinanceZTService
extends ExternalClientAbstract<FinanceZTConfig> {
    private static final Logger logger = LoggerFactory.getLogger(FinanceZTService.class);
    private static final String APP_TOKEN_CACHE_KEY = "APP_TOKEN_CACHE_KEY";
    private static final String USER_TOKEN_CACHE_KEY = "USER_TOKEN_CACHE_KEY";
    private static final String FINANCE_ZT_REQ_LOCK = "FINANCE_ZT_REQ_LOCK";
    private static final String COMMON_CHECK = "COMMON_CHECK";
    private static final String BUSINESS_CHECK = "BUSINESS_CHECK";
    @Resource
    private FinanceZTConfig financeZTConfig;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executePost(String url, Map<String, Object> bodyParams, Class<T> tClass) {
        logger.info("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u670d\u52a1\u63a5\u53e3");
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock(FINANCE_ZT_REQ_LOCK, FINANCE_ZT_REQ_LOCK, 10);
            HashMap<String, String> headParams = new HashMap<String, String>();
            headParams.put("accessToken", this.getUserToken());
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("data", Lists.newArrayList((Object[])new Map[]{bodyParams}));
            T t = this.extractData(super.executePost(url, body, headParams, null), tClass, BUSINESS_CHECK);
            this.logOut((String)headParams.get("accessToken"));
            T t2 = t;
            return t2;
        }
        finally {
            if (null != mutex) {
                this.lockService.unlock(mutex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executePost(String url, TypeReference<T> typeReference) {
        logger.info("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u670d\u52a1\u63a5\u53e3");
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock(FINANCE_ZT_REQ_LOCK, FINANCE_ZT_REQ_LOCK, 10);
            HashMap<String, String> headParams = new HashMap<String, String>();
            headParams.put("accessToken", this.getUserToken());
            HashMap<String, Object> body = new HashMap<String, Object>();
            T t = this.extractData(super.executePost(url, body, headParams, null), typeReference, BUSINESS_CHECK);
            this.logOut((String)headParams.get("accessToken"));
            T t2 = t;
            return t2;
        }
        finally {
            if (null != mutex) {
                this.lockService.unlock(mutex);
            }
        }
    }

    private String getAppToken() {
        String cache = (String)this.cacheService.getCache(APP_TOKEN_CACHE_KEY, String.class);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            logger.info("\u8bfb\u53d6\u7f13\u5b58\u5e94\u7528\u4ee4\u724c\uff1a{}", (Object)cache);
            return cache;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appId", this.financeZTConfig.getAppId());
        params.put("appSecuret", this.financeZTConfig.getAppSecuret());
        params.put("accountId", this.financeZTConfig.getAccountId());
        logger.info("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u83b7\u53d6\u5e94\u7528\u4ee4\u724c\uff1a{}", (Object)JSON.toJSONString(params));
        FinanceZTTokenRespDto financeZTAppTokenRespDto = this.extractData(super.executePost(this.financeZTConfig.getAppTokenApi(), params), FinanceZTTokenRespDto.class, COMMON_CHECK);
        logger.info("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u83b7\u53d6\u5e94\u7528\u4ee4\u724c\u7ed3\u679c\uff1a{}", (Object)financeZTAppTokenRespDto);
        this.exceptionForIfTrue(ObjectUtil.isEmpty((Object)financeZTAppTokenRespDto) || StringUtils.isBlank((CharSequence)financeZTAppTokenRespDto.getAppToken()), String.format("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u83b7\u53d6\u5e94\u7528\u4ee4\u724c\u5f02\u5e38\uff1a%s", financeZTAppTokenRespDto.getErrorDesc()));
        this.setCache(APP_TOKEN_CACHE_KEY, financeZTAppTokenRespDto.getAppToken(), financeZTAppTokenRespDto.getExpireTime());
        return financeZTAppTokenRespDto.getAppToken();
    }

    private String getUserToken() {
        String cache = (String)this.cacheService.getCache(USER_TOKEN_CACHE_KEY, String.class);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            logger.info("\u8bfb\u53d6\u7f13\u5b58\u7528\u6237\u4ee4\u724c\uff1a{}", (Object)cache);
            return cache;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", this.financeZTConfig.getUser());
        params.put("apptoken", this.getAppToken());
        params.put("accountId", this.financeZTConfig.getAccountId());
        logger.info("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u83b7\u53d6\u7528\u6237\u4ee4\u724c\uff1a{}", (Object)JSON.toJSONString(params));
        FinanceZTTokenRespDto financeZTAppTokenRespDto = this.extractData(super.executePost(this.financeZTConfig.getLoginApi(), params), FinanceZTTokenRespDto.class, COMMON_CHECK);
        this.exceptionForIfTrue(ObjectUtil.isEmpty((Object)financeZTAppTokenRespDto) || StringUtils.isBlank((CharSequence)financeZTAppTokenRespDto.getAccessToken()), String.format("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u83b7\u53d6\u7528\u6237\u4ee4\u724c\u5f02\u5e38\uff1a%s", financeZTAppTokenRespDto.getErrorDesc()));
        this.setCache(USER_TOKEN_CACHE_KEY, financeZTAppTokenRespDto.getAccessToken(), financeZTAppTokenRespDto.getExpireTime());
        return financeZTAppTokenRespDto.getAccessToken();
    }

    private void logOut(String accessToken) {
        logger.info("\u9000\u51fa\u767b\u5f55\uff1a{}", (Object)accessToken);
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("access_token", accessToken);
            super.executePost(this.financeZTConfig.getLogoutApi(), map);
        }
        catch (Exception e) {
            logger.error("\u9000\u51fa\u767b\u5f55\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setCache(String key, String value, String expireTime) {
    }

    @Override
    void check(String result) {
    }

    private <T> T extractData(String result, Class<T> tClass, String checkType) {
        if (StringUtils.isNotBlank((CharSequence)checkType)) {
            if (checkType.equals(COMMON_CHECK)) {
                this.commonCheck(result);
            } else if (checkType.equals(BUSINESS_CHECK)) {
                this.businessCheck(result);
            }
        }
        FinanceZTApiResponse response = (FinanceZTApiResponse)JSON.parseObject((String)result, FinanceZTApiResponse.class);
        return (T)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), tClass);
    }

    private <T> T extractData(String result, TypeReference<T> typeReference, String checkType) {
        if (StringUtils.isNotBlank((CharSequence)checkType)) {
            if (checkType.equals(COMMON_CHECK)) {
                this.commonCheck(result);
            } else if (checkType.equals(BUSINESS_CHECK)) {
                this.businessCheck(result);
            }
        }
        FinanceZTApiResponse response = (FinanceZTApiResponse)JSON.parseObject((String)result, FinanceZTApiResponse.class);
        return (T)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), typeReference, (Feature[])new Feature[0]);
    }

    private void commonCheck(String result) {
        logger.info("commonCheck\uff1a{}", (Object)result);
        logger.info("\u8d22\u52a1\u4e2d\u53f0\u54cd\u5e94check\uff1a{}", (Object)JSON.toJSONString((Object)result));
        FinanceZTApiResponse response = (FinanceZTApiResponse)JSON.parseObject((String)result, FinanceZTApiResponse.class);
        this.exceptionForIfTrue(ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getState()), String.format("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u5f02\u5e38\uff1a%s", JSON.toJSONString((Object)result)));
        this.exceptionForIfTrue(!response.getState().equals("success"), String.format("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u5931\u8d25\uff1a%s\uff0c%s", response.getErrorMsg(), response.getErrorCode()));
        logger.info("\u8d22\u52a1\u4e2d\u53f0\u54cd\u5e94check\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response));
    }

    private void businessCheck(String result) {
        logger.info("businessCheck\uff1a{}", (Object)result);
        result = result.replace("\t", "");
        result = result.replace("\n", "");
        logger.info("\u8d22\u52a1\u4e2d\u53f0\u54cd\u5e94check\uff1a{}", (Object)result);
        FinanceZTApiResponse response = (FinanceZTApiResponse)JSON.parseObject((String)result, FinanceZTApiResponse.class);
        this.exceptionForIfTrue(ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getStatus()), String.format("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u5f02\u5e38\uff1a%s", result));
        this.exceptionForIfTrue(response.getStatus() == false, String.format("\u8bf7\u6c42\u8d22\u52a1\u4e2d\u53f0\u5931\u8d25\uff1a%s\uff0c%s", response.getErrorCode(), result));
        logger.info("\u8d22\u52a1\u4e2d\u53f0\u54cd\u5e94check\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response));
    }

    private void exceptionForIfTrue(boolean ifTrue, String msg) {
        if (ifTrue) {
            throw new BizException(msg);
        }
    }
}

