/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.core.util.HttpUtils;
import com.dtyunxi.tcbj.app.open.biz.config.MarketingCloudConfig;
import com.dtyunxi.tcbj.app.open.biz.dto.marketingcloud.AccessTokenRespDto;
import com.dtyunxi.tcbj.app.open.biz.dto.marketingcloud.HttpResponseDto;
import com.dtyunxi.tcbj.app.open.biz.dto.marketingcloud.ReturnObjectDto;
import com.dtyunxi.tcbj.app.open.biz.dto.marketingcloud.WarehouseTenantRespDto;
import com.dtyunxi.tcbj.app.open.biz.utils.HttpUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.YXYCurrInvQueryReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.YXYCurrInvQueryRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.YXYResponseDTO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MarketingCloudService {
    private static Logger logger = LoggerFactory.getLogger(MarketingCloudService.class);
    @Value(value="${marketing.cache.tokenKey:MARKETING-TOKEN}")
    private String tokenCacheKey;
    @Resource
    private MarketingCloudConfig marketingCloudConfig;
    @Resource
    private HttpUtil httpUtil;
    @Resource
    private ICacheService cacheService;
    @Value(value="${csp.bc.tokenUrl:https://uat-tang-sales.by-health.com/api/openapi/auth/getToken}")
    private String tokenUrl;

    public void createPurchaseOrder() {
    }

    public List<WarehouseTenantRespDto> getWarehouseTenantList(List<String> extTenantIds, String token) {
        ReturnObjectDto returnObject;
        logger.info("\u8bf7\u6c42\u8425\u9500\u4e91\u670d\u52a1\uff0c\u6839\u636e\u7ecf\u9500\u5546\u83b7\u53d6\u79df\u6237\u4e0e\u4ed3\u5e93\u5173\u8054\u4fe1\u606f\uff1a{}=={}", (Object)JSONObject.toJSONString(extTenantIds), (Object)token);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (token != null && !token.equals("")) {
            params.put("access_token", token);
        } else {
            params.put("access_token", this.getToken());
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("extTenantId", extTenantIds);
        HttpResponseDto rest = this.httpUtil.httpPost(this.marketingCloudConfig.getUrl(this.marketingCloudConfig.getTenantWarehouseRest()), params, jsonMap, HttpResponseDto.class);
        logger.info("\u8bf7\u6c42\u8425\u9500\u4e91\u670d\u52a1\uff0c\u6839\u636e\u7ecf\u9500\u5546\u83b7\u53d6\u79df\u6237\u4e0e\u4ed3\u5e93\u5173\u8054\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)rest));
        if (ObjectUtils.isNotEmpty((Object)rest) && ObjectUtils.isNotEmpty((Object)(returnObject = (ReturnObjectDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rest.getReturnObject()), ReturnObjectDto.class))) && ObjectUtils.isNotEmpty((Object)returnObject.getData())) {
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)returnObject.getData()), WarehouseTenantRespDto.class);
            return list;
        }
        return null;
    }

    public List<YXYCurrInvQueryRespDto> queryInCargoStorage(YXYCurrInvQueryReqDto reqDto, String token) {
        YXYResponseDTO returnObject;
        HashMap<String, Object> headerParams = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headerParams.put("access_token", token);
        } else {
            headerParams.put("access_token", this.getToken());
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.putAll((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqDto), Map.class));
        HttpResponseDto rest = this.httpUtil.httpPost(this.marketingCloudConfig.getUrl(this.marketingCloudConfig.getQueryCurrInvRest()), headerParams, jsonMap, HttpResponseDto.class);
        logger.info("\u8bf7\u6c42\u8425\u9500\u4e91\u670d\u52a1\uff0c\u67e5\u8be2\u5373\u65f6\u5e93\u5b58\u6570\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)rest));
        if (ObjectUtils.isNotEmpty((Object)rest) && ObjectUtils.isNotEmpty((Object)(returnObject = (YXYResponseDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rest.getReturnObject()), YXYResponseDTO.class))) && ObjectUtils.isNotEmpty((Object)returnObject.getReturnObject())) {
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)returnObject.getReturnObject()), YXYCurrInvQueryRespDto.class);
            return list;
        }
        return null;
    }

    public String getToken() {
        logger.info("\u8bf7\u6c42\u83b7\u53d6\u8425\u9500\u4e91token");
        String token = (String)this.cacheService.getCache(this.tokenCacheKey, String.class);
        logger.info("\u83b7\u53d6\u7f13\u5b58\uff1a{}", (Object)token);
        if (StringUtils.isBlank((CharSequence)token)) {
            String url = this.marketingCloudConfig.getUrl(this.marketingCloudConfig.getAccessTokenRest() + "?appId=" + this.marketingCloudConfig.getAppId() + "&appSecret=" + this.marketingCloudConfig.getAppSecret());
            logger.info(url);
            String result = HttpUtils.get((String)url);
            logger.info("\u8bf7\u6c42\u8425\u9500\u4e91\u670d\u52a1\uff0c\u83b7\u53d6token\uff1a{}, {}", (Object)url, (Object)JSONObject.toJSONString((Object)result));
            if (ObjectUtils.isNotEmpty((Object)result)) {
                HttpResponseDto rest = (HttpResponseDto)JSONObject.parseObject((String)result, HttpResponseDto.class);
                Assert.isTrue((boolean)rest.getErrorCode().equals("00"), (String)rest.getErrorCode(), (String)rest.getErrorMessage());
                AccessTokenRespDto dto = (AccessTokenRespDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rest.getReturnObject()), AccessTokenRespDto.class);
                token = dto.getAccess_token();
                this.setTokenCache(dto);
            } else {
                throw new BizException("-1", "\u83b7\u53d6\u8425\u9500\u4e91token\u5931\u8d25");
            }
        }
        return token;
    }

    private void setTokenCache(AccessTokenRespDto dto) {
        logger.info("\u8bbe\u7f6e\u8425\u9500\u4e91Token\u7f13\u5b58\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        try {
            if (ObjectUtils.isEmpty((Object)dto) || StringUtils.isBlank((CharSequence)dto.getAccess_token())) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getExpiredTime())) {
                Date endDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dto.getExpiredTime());
                long seconds = (endDate.getTime() - new Date().getTime()) / 1000L - 15L;
                logger.info("\u8bbe\u7f6e\u7f13\u5b58\u53c2\u6570\uff1a{},{},{}", new Object[]{this.tokenCacheKey, dto.getAccess_token(), seconds});
                boolean b = this.cacheService.setCache(this.tokenCacheKey, dto.getAccess_token(), (Object)seconds);
                if (b) {
                    logger.info("\u8bbe\u7f6e\u7f13\u5b58\u6210\u529f");
                } else {
                    logger.info("\u8bbe\u7f6e\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u8425\u9500\u4e91Token\u7f13\u5b58\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getToken(String appId, String appSecret) {
        logger.info("\u83b7\u53d6\u8425\u9500\u4e91TOKEN\uff1a{}\uff0c{}", (Object)appId, (Object)appSecret);
        String url = this.marketingCloudConfig.getUrl(this.marketingCloudConfig.getAccessTokenRest() + "?appId=" + appId + "&appSecret=" + appSecret);
        logger.info(url);
        String result = HttpUtils.get((String)url);
        logger.info("\u8bf7\u6c42\u8425\u9500\u4e91\u670d\u52a1\uff0c\u83b7\u53d6token\uff1a{}, {}", (Object)url, (Object)JSONObject.toJSONString((Object)result));
        if (ObjectUtils.isNotEmpty((Object)result)) {
            HttpResponseDto rest = (HttpResponseDto)JSONObject.parseObject((String)result, HttpResponseDto.class);
            Assert.isTrue((boolean)rest.getErrorCode().equals("00"), (String)rest.getErrorCode(), (String)rest.getErrorMessage());
            AccessTokenRespDto dto = (AccessTokenRespDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rest.getReturnObject()), AccessTokenRespDto.class);
            return dto.getAccess_token();
        }
        return null;
    }

    public String getBcCspToken(String appId, String appSecret) {
        logger.info("\u83b7\u53d6\u8425\u9500\u4e91TOKEN\uff1a{}\uff0c{}", (Object)appId, (Object)appSecret);
        String url = this.tokenUrl + "?appId=" + appId + "&appSecret=" + appSecret;
        logger.info(url);
        String result = HttpUtils.get((String)url);
        logger.info("\u8bf7\u6c42\u8425\u9500\u4e91BC\u9500\u552e\u8c03\u62e8\u670d\u52a1\uff0c\u83b7\u53d6token\uff1a{}, {}", (Object)url, (Object)JSONObject.toJSONString((Object)result));
        if (ObjectUtils.isNotEmpty((Object)result)) {
            HttpResponseDto rest = (HttpResponseDto)JSONObject.parseObject((String)result, HttpResponseDto.class);
            Assert.isTrue((boolean)rest.getErrorCode().equals("00"), (String)rest.getErrorCode(), (String)rest.getErrorMessage());
            AccessTokenRespDto dto = (AccessTokenRespDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rest.getReturnObject()), AccessTokenRespDto.class);
            return dto.getAccess_token();
        }
        return null;
    }
}

