/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.openapi.qimen.weizhi.common;

import com.dtyunxi.cube.commons.exceptions.BizException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
@ConfigurationProperties(prefix="channel", ignoreInvalidFields=true)
public class QimenPropertiesConfig {
    private List<Properties> properties = new ArrayList<Properties>(0);

    public Properties findByCustomer(String customer) {
        return this.properties.stream().filter(p -> Objects.equals(customer, ((Properties)p).qimenCustomerId)).findFirst().orElseThrow(() -> new BizException("\u672a\u914d\u7f6e\u7684\u6e20\u9053"));
    }

    public Properties findByPcpChannel(String pcpChannel) {
        return this.properties.stream().filter(p -> Objects.equals(pcpChannel, p.getPcpChannelCode())).findFirst().orElseThrow(() -> new BizException("\u672a\u914d\u7f6e\u7684\u6e20\u9053"));
    }

    public List<Properties> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Properties> properties) {
        this.properties = properties;
    }

    public static class Properties {
        private String pcpChannelCode;
        private String qimenServerUrl;
        private String extServerUrl = "http://192.168.1.47:8080";
        private String qimenAppKey;
        private String qimenTargetAppKey;
        private String qimenAppSecret;
        private String qimenCustomerId;
        private Boolean sign;
        private String warehouseCode;
        private String qimenDecode;
        private Boolean wmsRequest;

        public String getPcpChannelCode() {
            return this.pcpChannelCode;
        }

        public String getQimenServerUrl() {
            return this.qimenServerUrl;
        }

        public String getExtServerUrl() {
            return this.extServerUrl;
        }

        public String getQimenAppKey() {
            return this.qimenAppKey;
        }

        public String getQimenTargetAppKey() {
            return this.qimenTargetAppKey;
        }

        public String getQimenAppSecret() {
            return this.qimenAppSecret;
        }

        public String getQimenCustomerId() {
            return this.qimenCustomerId;
        }

        public Boolean getSign() {
            return this.sign;
        }

        public String getWarehouseCode() {
            return this.warehouseCode;
        }

        public String getQimenDecode() {
            return this.qimenDecode;
        }

        public Boolean getWmsRequest() {
            return this.wmsRequest;
        }

        public void setPcpChannelCode(String pcpChannelCode) {
            this.pcpChannelCode = pcpChannelCode;
        }

        public void setQimenServerUrl(String qimenServerUrl) {
            this.qimenServerUrl = qimenServerUrl;
        }

        public void setExtServerUrl(String extServerUrl) {
            this.extServerUrl = extServerUrl;
        }

        public void setQimenAppKey(String qimenAppKey) {
            this.qimenAppKey = qimenAppKey;
        }

        public void setQimenTargetAppKey(String qimenTargetAppKey) {
            this.qimenTargetAppKey = qimenTargetAppKey;
        }

        public void setQimenAppSecret(String qimenAppSecret) {
            this.qimenAppSecret = qimenAppSecret;
        }

        public void setQimenCustomerId(String qimenCustomerId) {
            this.qimenCustomerId = qimenCustomerId;
        }

        public void setSign(Boolean sign) {
            this.sign = sign;
        }

        public void setWarehouseCode(String warehouseCode) {
            this.warehouseCode = warehouseCode;
        }

        public void setQimenDecode(String qimenDecode) {
            this.qimenDecode = qimenDecode;
        }

        public void setWmsRequest(Boolean wmsRequest) {
            this.wmsRequest = wmsRequest;
        }
    }
}

