/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.control.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.ITrControlGiftConfigApi;
import com.dtyunxi.tcbj.center.control.api.ITrControlGiftGrantRecordApi;
import com.dtyunxi.tcbj.center.control.api.ITrControlGiftResultApi;
import com.dtyunxi.tcbj.center.control.api.ITrControlGiftRuleApi;
import com.dtyunxi.tcbj.center.control.api.ITrControlItemAmountImportApi;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleExitClashEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizContolGiftReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizImportDataReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftConfigReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftFreezeRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftGrantRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftResultReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftRuleReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlItemAmountImportReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizChangeRuleResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizContolGiftRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizControlGiftGrantRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizImportRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftConfigRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftFreezeRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftGrantRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.vo.CustomerExportVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftAmountResultImportVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftGrantRecordImportVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.ItemExportVo;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftConfigQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftFreezeRecordQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftGrantRecordQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftRecordQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftResultQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.ITrControlGiftRuleQueryApi;
import com.dtyunxi.tcbj.module.control.biz.service.IControlGiftAmountService;
import com.dtyunxi.tcbj.module.control.biz.utils.BeanPropertyNullUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailBaseInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.dto.request.ItemShopQueryReqDto;
import com.yx.tcbj.center.api.query.IItemCenterQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerAreaQueryExtApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ControlGiftAmountServiceImpl
implements IControlGiftAmountService {
    private static Logger logger = LoggerFactory.getLogger(ControlGiftAmountServiceImpl.class);
    @Resource
    private ITrControlGiftRuleApi trControlGiftRuleApi;
    @Resource
    private ITrControlGiftRuleQueryApi trControlGiftRuleQueryApi;
    @Resource
    private ITrControlGiftResultQueryApi trControlGiftResultQueryApi;
    @Resource
    private ITrControlGiftResultApi trControlGiftResultApi;
    @Resource
    private ITrControlGiftFreezeRecordQueryApi trControlGiftFreezeRecordQueryApi;
    @Resource
    private ITrControlGiftGrantRecordQueryApi trControlGiftGrantRecordQueryApi;
    @Resource
    private ITrControlGiftGrantRecordApi trControlGiftGrantRecordApi;
    @Resource
    private ITrControlGiftConfigApi trControlGiftConfigApi;
    @Resource
    private ITrControlGiftConfigQueryApi trControlGiftConfigQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private ITrControlGiftRecordQueryApi controlGiftRecordQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ITrControlItemAmountImportApi controlItemAmountImportApi;
    @Resource
    private IItemCenterQueryApi itemCenterQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private ICustomerAreaQueryExtApi customerAreaQueryExtApi;

    @Override
    public RestResponse<Void> addTrControlGiftRule(BizContolGiftReqDto addReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        addReqDto.setOrgId(orgId);
        RestResponse result = this.trControlGiftRuleApi.addTrControlGiftRule(addReqDto);
        StringBuilder desc = new StringBuilder("\u8be5\u5ba2\u6237\u7ef4\u5ea6\u5df2\u7ecf\u5b58\u5728\u8d60\u54c1\u989d\u5ea6\u89c4\u5219\uff08\u4e14\u5df2\u542f\u7528\u72b6\u6001\uff09\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002\n\u51b2\u7a81\u5185\u5bb9\uff1a");
        if (((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getAreaList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getAreaList().stream().map(c -> c.getAreaCode()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u533a\u57df\uff1a" + collect);
            } else if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getCustomerList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getCustomerList().stream().map(c -> c.getCustomerName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u5ba2\u6237\u5ba2\u6237\uff1a" + collect);
            } else {
                desc.append("\u5168\u90e8\u5ba2\u6237");
            }
        }
        return !((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue()) ? new RestResponse("0", "success") : new RestResponse("0001", desc.toString());
    }

    @Override
    public RestResponse<Object> modifyTrControlGiftRule(BizContolGiftReqDto modifyReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        modifyReqDto.setOrgId(orgId);
        RestResponse result = this.trControlGiftRuleApi.modifyTrControlGiftRule(modifyReqDto);
        StringBuilder desc = new StringBuilder("\u8be5\u5ba2\u6237\u7ef4\u5ea6\u5df2\u7ecf\u5b58\u5728\u8d60\u54c1\u989d\u5ea6\u89c4\u5219\uff08\u4e14\u5df2\u542f\u7528\u72b6\u6001\uff09\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\u3002\n\u51b2\u7a81\u5185\u5bb9\uff1a");
        if (((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getAreaList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getAreaList().stream().map(c -> c.getAreaCode()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u533a\u57df\uff1a" + collect);
            } else if (!ObjectUtils.isEmpty((Object)((BizChangeRuleResultRespDto)result.getData()).getCustomerList())) {
                List collect = ((BizChangeRuleResultRespDto)result.getData()).getCustomerList().stream().map(c -> c.getCustomerName()).collect(Collectors.toList());
                desc.append("\u6307\u5b9a\u5ba2\u6237\u5ba2\u6237\uff1a" + collect);
            } else {
                desc.append("\u5168\u90e8\u5ba2\u6237");
            }
        }
        return !((BizChangeRuleResultRespDto)result.getData()).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue()) ? new RestResponse("0", "success") : new RestResponse("0001", desc.toString());
    }

    @Override
    public RestResponse<Void> removeTrControlGiftRule(String ids) {
        return this.trControlGiftRuleApi.removeTrControlGiftRule(ids, null);
    }

    @Override
    public RestResponse<BizContolGiftRespDto> queryById(Long id) {
        return this.trControlGiftRuleQueryApi.queryById(id);
    }

    @Override
    public RestResponse<PageInfo<TrControlGiftRuleRespDto>> queryGiftRuleByPage(String filter, Integer pageNum, Integer pageSize) {
        TrControlGiftRuleReqDto trControlGiftRuleRespDto = (TrControlGiftRuleReqDto)JSON.parseObject((String)filter, TrControlGiftRuleReqDto.class);
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        trControlGiftRuleRespDto.setOrgId(orgId);
        return this.trControlGiftRuleQueryApi.queryByPage(JSON.toJSONString((Object)trControlGiftRuleRespDto), pageNum, pageSize);
    }

    @Override
    public RestResponse<PageInfo<TrControlGiftResultRespDto>> queryGiftResultByPage(String filter, Integer pageNum, Integer pageSize) {
        TrControlGiftResultReqDto giftResultRespDto = (TrControlGiftResultReqDto)JSON.parseObject((String)filter, TrControlGiftResultReqDto.class);
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        giftResultRespDto.setOrgId(orgId);
        return this.trControlGiftResultQueryApi.queryByPage(JSON.toJSONString((Object)giftResultRespDto), pageNum, pageSize);
    }

    @Override
    public RestResponse<BizImportRespDto> importGiftResult(MultipartFile file) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        BizImportDataReqDto bizImportDataReqDto = new BizImportDataReqDto();
        bizImportDataReqDto.setOrgId(orgId);
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), GiftAmountResultImportVo.class, (ImportParams)importParams);
            List allFieldNullList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
            bizImportDataReqDto.setExcelImportResult(allFieldNullList);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        TrControlItemAmountImportReqDto controlItemAmountImportReqDto = new TrControlItemAmountImportReqDto();
        controlItemAmountImportReqDto.setFileName(file.getOriginalFilename());
        controlItemAmountImportReqDto.setOrgId(orgId);
        bizImportDataReqDto.setTenantId(this.context.tenantId());
        logger.info("\u63d2\u5165\u6587\u4ef6\u5bfc\u5165\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)controlItemAmountImportReqDto));
        RestResponse longRestResponse = this.controlItemAmountImportApi.addTrControlItemAmountImport(controlItemAmountImportReqDto);
        bizImportDataReqDto.setImportId((Long)longRestResponse.getData());
        return this.trControlGiftResultApi.importGiftResult(bizImportDataReqDto);
    }

    @Override
    public RestResponse<PageInfo<TrControlGiftFreezeRecordRespDto>> queryGiftFreezeByPage(String filter, Integer pageNum, Integer pageSize) {
        TrControlGiftFreezeRecordReqDto giftResultRespDto = (TrControlGiftFreezeRecordReqDto)JSON.parseObject((String)filter, TrControlGiftFreezeRecordReqDto.class);
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        giftResultRespDto.setOrgId(orgId);
        return this.trControlGiftFreezeRecordQueryApi.queryByPage(JSON.toJSONString((Object)giftResultRespDto), pageNum, pageSize);
    }

    @Override
    public RestResponse<PageInfo<TrControlGiftRecordRespDto>> queryGiftRecordByPage(String filter, Integer pageNum, Integer pageSize) {
        TrControlGiftRecordReqDto giftRecordReqDto = (TrControlGiftRecordReqDto)JSON.parseObject((String)filter, TrControlGiftRecordReqDto.class);
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u6d41\u6c34\u3011\u7ec4\u7ec7id\uff1a{}", (Object)orgId);
        giftRecordReqDto.setOrgId(orgId);
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u6d41\u6c34\u3011\u8d60\u54c1\u989d\u5ea6\u6d41\u6c34\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)giftRecordReqDto));
        return this.controlGiftRecordQueryApi.queryByPage(JSON.toJSONString((Object)giftRecordReqDto), pageNum, pageSize);
    }

    @Override
    public RestResponse<PageInfo<TrControlGiftGrantRecordRespDto>> queryGiftGrantByPage(String filter, Integer pageNum, Integer pageSize) {
        TrControlGiftGrantRecordReqDto giftGrantRecordRespDto = (TrControlGiftGrantRecordReqDto)JSON.parseObject((String)filter, TrControlGiftGrantRecordReqDto.class);
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        giftGrantRecordRespDto.setOrgId(orgId);
        return this.trControlGiftGrantRecordQueryApi.queryByPage(JSON.toJSONString((Object)giftGrantRecordRespDto), pageNum, pageSize);
    }

    @Override
    public RestResponse<Void> addTrControlGiftGrantRecord(TrControlGiftGrantRecordReqDto addReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        addReqDto.setOrgId(orgId);
        RestResponse bizControlGiftGrantRespDtoRestResponse = this.trControlGiftGrantRecordApi.addTrControlGiftGrantRecord(addReqDto);
        BizControlGiftGrantRespDto data = (BizControlGiftGrantRespDto)bizControlGiftGrantRespDtoRestResponse.getData();
        if (data.getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            if (!ObjectUtils.isEmpty((Object)data.getBlackList()) || !ObjectUtils.isEmpty((Object)data.getCustomerList())) {
                return new RestResponse(ControlExceptionCode.GRANT_ERROR.getCode(), "\u8d60\u54c1\u989d\u5ea6\u89c4\u5219\u7f16\u53f7\u4e0d\u9002\u7528\u8be5\u5ba2\u6237");
            }
            if (!ObjectUtils.isEmpty((Object)data.getAmountType())) {
                return new RestResponse(ControlExceptionCode.GRANT_ERROR.getCode(), "\u63d0\u4ea4\u7c7b\u578b\u4e0e\u989d\u5ea6\u89c4\u5219\u7c7b\u578b\u4e0d\u4e00\u81f4");
            }
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeTrControlGiftGrantRecord(String ids, Long instanceId) {
        return this.trControlGiftGrantRecordApi.removeTrControlGiftGrantRecord(ids, instanceId);
    }

    @Override
    public RestResponse<Void> saveOrUpdateControlGiftConfig(TrControlGiftConfigReqDto modifyReqDto) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        modifyReqDto.setOrgId(orgId);
        return this.trControlGiftConfigApi.saveOrUpdateControlGiftConfig(modifyReqDto);
    }

    @Override
    public RestResponse<TrControlGiftConfigRespDto> queryGiftConfigByOrgId() {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        return this.trControlGiftConfigQueryApi.queryByOrgId(orgId);
    }

    @Override
    public RestResponse<BizImportRespDto> importGiftGrantRecord(MultipartFile file) {
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        BizImportDataReqDto bizImportDataReqDto = new BizImportDataReqDto();
        bizImportDataReqDto.setOrgId(orgId);
        bizImportDataReqDto.setTenantId(this.context.tenantId());
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), GiftGrantRecordImportVo.class, (ImportParams)importParams);
            List collect = result.getList().stream().filter(c -> !BeanPropertyNullUtil.isAllFieldNull(c)).collect(Collectors.toList());
            bizImportDataReqDto.setExcelImportResult(collect);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        TrControlItemAmountImportReqDto controlItemAmountImportReqDto = new TrControlItemAmountImportReqDto();
        controlItemAmountImportReqDto.setFileName(file.getOriginalFilename());
        controlItemAmountImportReqDto.setOrgId(orgId);
        logger.info("\u63d2\u5165\u6587\u4ef6\u5bfc\u5165\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)controlItemAmountImportReqDto));
        RestResponse longRestResponse = this.controlItemAmountImportApi.addTrControlItemAmountImport(controlItemAmountImportReqDto);
        bizImportDataReqDto.setImportId((Long)longRestResponse.getData());
        return this.trControlGiftGrantRecordApi.importGiftGrantRecord(bizImportDataReqDto);
    }

    @Override
    public RestResponse<Object> queryCustomerByExcel(MultipartFile file) {
        List customerDtoList;
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List<CustomerExportVo> customerImportVoList = null;
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), CustomerExportVo.class, (ImportParams)importParams);
            customerImportVoList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
        }
        catch (Exception e) {
            logger.info("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:{}", (Throwable)e);
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
        }
        if (CollectionUtils.isEmpty(customerImportVoList)) {
            throw new BizException("\u5bfc\u5165\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6");
        }
        List customerCodeList = customerImportVoList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCode())).map(c -> c.getCode()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customerCodeList)) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6");
        }
        Map<String, Object> customerDtoMap = new HashMap<String, CustomerRespDto>(customerCodeList.size() * 4 / 3 + 2);
        if (CollectionUtils.isNotEmpty(customerCodeList) && CollectionUtils.isNotEmpty((Collection)(customerDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(customerCodeList))))) {
            customerDtoMap = customerDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList customerRespDtoList = Lists.newArrayList();
        List<CustomerExportVo> customerExportVos = this.verifyCustomerExportVo(customerDtoMap, customerImportVoList, customerRespDtoList);
        String url = "";
        if (!CollectionUtils.isEmpty(customerExportVos)) {
            String excelName = "cube/\u5bfc\u5165\u5ba2\u6237\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                url = EasyPoiExportUtil.getExportUrl(customerExportVos, CustomerExportVo.class, (String)null, (String)excelName, (String)"xls");
                logger.info("\u3010\u5bfc\u5165\u5ba2\u6237\u3011\u5931\u8d25\u6587\u4ef6url : {}", (Object)url);
            }
            catch (Exception e) {
                logger.error("\u5bfc\u5165\u5ba2\u6237-\u9519\u8bef:{}", (Object)e.toString());
                e.printStackTrace();
                throw new BizException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25:{}", e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtoList)) {
            List customerNameSimpleRespDtos;
            Map<Object, Object> customerTypeMap = new HashMap();
            List customerTypeIdList = customerRespDtoList.stream().filter(dto -> Objects.nonNull(dto.getCustomerTypeId())).map(CustomerRespDto::getCustomerTypeId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(customerTypeIdList) && CollectionUtils.isNotEmpty((Collection)(customerNameSimpleRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerTypeQueryApi.queryListByIds(customerTypeIdList))))) {
                customerTypeMap = customerNameSimpleRespDtos.stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, CustomerNameSimpleRespDto::getName));
            }
            List customerIdList = customerRespDtoList.stream().filter(dto -> Objects.nonNull(dto.getId())).map(BaseRespDto::getId).collect(Collectors.toList());
            Map customerAreaMap = (Map)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryExtApi.getCustomerAreaByCustomerIdMap(customerIdList));
            for (CustomerRespDto customerRespDto : customerRespDtoList) {
                List respDtos;
                if (customerTypeMap.containsKey(customerRespDto.getCustomerTypeId())) {
                    customerRespDto.setCustomerTypeName((String)customerTypeMap.get(customerRespDto.getCustomerTypeId()));
                }
                if (!customerAreaMap.containsKey(customerRespDto.getId()) || !CollectionUtils.isNotEmpty(respDtos = ((List)customerAreaMap.get(customerRespDto.getId())).stream().filter(dto -> customerRespDto.getMerchantId().compareTo(dto.getOrgInfoId()) == 0).collect(Collectors.toList()))) continue;
                List areaCodeList = respDtos.stream().map(CustomerAreaRespDto::getCode).collect(Collectors.toList());
                String areaNames = respDtos.stream().map(CustomerAreaRespDto::getName).collect(Collectors.joining(";"));
                customerRespDto.setRegionNames(areaNames);
                customerRespDto.setRegionCodeList(areaCodeList);
            }
        }
        Map<String, CustomerRespDto> map = customerRespDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, u -> u, (key1, key2) -> key1));
        BizImportRespDto bizImportRespDto = new BizImportRespDto(Integer.valueOf(customerImportVoList.size()), Integer.valueOf(map.values().size()), Integer.valueOf(customerImportVoList.size() - map.values().size()), url);
        bizImportRespDto.setObjects(map.values());
        return new RestResponse((Object)bizImportRespDto);
    }

    public List<CustomerExportVo> verifyCustomerExportVo(Map<String, CustomerRespDto> customerDtoMap, List<CustomerExportVo> customerImportVoList, List<CustomerRespDto> customerRespDtoList) {
        ArrayList resultVoList = Lists.newArrayList();
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        ArrayList customerCodes = Lists.newArrayList();
        for (CustomerExportVo customerVo : customerImportVoList) {
            if (StringUtils.isEmpty((CharSequence)customerVo.getCode())) continue;
            if (customerCodes.contains(customerVo.getCode())) {
                customerVo.setRemark("\u91cd\u590d\u5ba2\u6237\u7f16\u7801");
                resultVoList.add(customerVo);
                continue;
            }
            if (!customerDtoMap.containsKey(customerVo.getCode())) {
                customerVo.setRemark("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5ba2\u6237");
                resultVoList.add(customerVo);
                continue;
            }
            CustomerRespDto customerRespDto = customerDtoMap.get(customerVo.getCode());
            if (customerRespDto.getMerchantId().compareTo(orgId) != 0) {
                customerVo.setRemark("\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5339\u914d");
                resultVoList.add(customerVo);
                continue;
            }
            customerCodes.add(customerVo.getCode());
            customerRespDtoList.add(customerRespDto);
        }
        return resultVoList;
    }

    @Override
    public RestResponse<Object> queryItemByExcel(MultipartFile file, Integer subtype) {
        List shopBaseDtos;
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List<ItemExportVo> itemImportVoList = null;
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), ItemExportVo.class, (ImportParams)importParams);
            itemImportVoList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
        }
        catch (Exception e) {
            logger.info("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:{}", (Throwable)e);
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
        }
        if (CollectionUtils.isEmpty(itemImportVoList)) {
            throw new BizException("\u5bfc\u5165\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6");
        }
        List itemCodeList = itemImportVoList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCode())).map(c -> c.getCode()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemCodeList)) {
            throw new BizException("\u5bfc\u5165\u5546\u54c1\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6");
        }
        Map<String, Object> itemInfoMap = new HashMap<String, ItemDetailBaseInfoRespDto>(itemCodeList.size() * 4 / 3 + 2);
        if (CollectionUtils.isNotEmpty(itemCodeList) && CollectionUtils.isNotEmpty((Collection)(shopBaseDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(orgId))))) {
            ItemShopQueryReqDto itemShopQueryReqDto = new ItemShopQueryReqDto();
            itemShopQueryReqDto.setItemCodes(itemCodeList);
            itemShopQueryReqDto.setShopId(((ShopBaseDto)shopBaseDtos.get(0)).getId());
            itemShopQueryReqDto.setTargetType(Integer.valueOf(2));
            List itemInfoList = (List)RestResponseHelper.extractData((RestResponse)this.itemCenterQueryApi.queryShopItemList(itemShopQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)itemInfoList)) {
                itemInfoMap = itemInfoList.stream().collect(Collectors.toMap(ItemDetailBaseInfoRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        ArrayList itemRespDtoResult = Lists.newArrayList();
        List<ItemExportVo> itemExportVos = this.verifyItemExportVo(itemInfoMap, itemImportVoList, itemRespDtoResult);
        try {
            String url = "";
            if (!CollectionUtils.isEmpty(itemExportVos)) {
                String excelName = "cube/\u5bfc\u5165\u5546\u54c1\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                try {
                    url = EasyPoiExportUtil.getExportUrl(itemExportVos, ItemExportVo.class, (String)null, (String)excelName, (String)"xls");
                    logger.info("\u3010\u5bfc\u5165\u5546\u54c1\u3011\u5931\u8d25\u6587\u4ef6url : {}", (Object)url);
                }
                catch (Exception var15) {
                    logger.error("\u5bfc\u5165\u5546\u54c1-\u9519\u8bef:{}", (Object)var15.toString());
                    var15.printStackTrace();
                }
            }
            Map<String, ItemDetailBaseInfoRespDto> map = itemRespDtoResult.stream().collect(Collectors.toMap(ItemDetailBaseInfoRespDto::getCode, u -> u, (key1, key2) -> key1));
            BizImportRespDto bizImportRespDto = new BizImportRespDto(Integer.valueOf(itemImportVoList.size()), Integer.valueOf(map.values().size()), Integer.valueOf(itemImportVoList.size() - map.values().size()), url);
            bizImportRespDto.setObjects(map.values());
            return new RestResponse((Object)bizImportRespDto);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
    }

    public List<ItemExportVo> verifyItemExportVo(Map<String, ItemDetailBaseInfoRespDto> itemInfoMap, List<ItemExportVo> itemExportVos, List<ItemDetailBaseInfoRespDto> itemRespDtoResult) {
        ArrayList resultVoList = Lists.newArrayList();
        ArrayList itemCodeList = Lists.newArrayList();
        for (ItemExportVo itemExportVo : itemExportVos) {
            if (StringUtils.isEmpty((CharSequence)itemExportVo.getCode())) continue;
            if (itemCodeList.contains(itemExportVo.getCode())) {
                itemExportVo.setRemark("\u91cd\u590d\u5546\u54c1\u7f16\u7801");
                resultVoList.add(itemExportVo);
                continue;
            }
            if (!itemInfoMap.containsKey(itemExportVo.getCode())) {
                itemExportVo.setRemark("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5546\u54c1");
                resultVoList.add(itemExportVo);
                continue;
            }
            itemCodeList.add(itemExportVo.getCode());
            itemRespDtoResult.add(itemInfoMap.get(itemExportVo.getCode()));
        }
        return resultVoList;
    }
}

