/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.control.biz.service.ICustomerAreaService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaSubTreeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerAreaServiceImpl
implements ICustomerAreaService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;

    @Override
    public String getMinimumAreaCodeByCustomerId(Long customerId) {
        CustomerExtDetailRespDto customerExtDetailRespDto = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryById(customerId));
        this.logger.info("\u5ba2\u6237\u7684\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)customerExtDetailRespDto));
        return this.getMinimumAreaCode(customerExtDetailRespDto.getOrgInfoId(), (List<String>)customerExtDetailRespDto.getRegionCodeList());
    }

    public String getMinimumAreaCode(Long orgId, List<String> areaCodeList) {
        if (CollectionUtils.isEmpty(areaCodeList)) {
            this.logger.warn("\u5ba2\u6237\u7684\u5730\u5740\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        CustomerAreaSubTreeReqDto customerAreaSubTreeReqDto = new CustomerAreaSubTreeReqDto();
        customerAreaSubTreeReqDto.setOrgInfoId(orgId);
        customerAreaSubTreeReqDto.setCode(areaCodeList.get(0));
        this.logger.info("\u83b7\u53d6\u5ba2\u6237\u533a\u57df\u5b50\u6811\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)customerAreaSubTreeReqDto));
        CustomerAreaTreeRespDto customerAreaTreeRespDto = (CustomerAreaTreeRespDto)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryForSubTree(customerAreaSubTreeReqDto));
        if (Objects.isNull(customerAreaTreeRespDto)) {
            return areaCodeList.get(0);
        }
        return this.getMinimumAreaCode(customerAreaTreeRespDto, areaCodeList);
    }

    private String getMinimumAreaCode(CustomerAreaTreeRespDto customerAreaTreeRespDto, List<String> areaCodeList) {
        if (CollectionUtils.isNotEmpty((Collection)customerAreaTreeRespDto.getChildren())) {
            CustomerAreaTreeRespDto customerAreaTreeResp = customerAreaTreeRespDto.getChildren().stream().filter(children -> areaCodeList.contains(children.getCode())).findFirst().orElse(new CustomerAreaTreeRespDto());
            return this.getMinimumAreaCode(customerAreaTreeResp, areaCodeList);
        }
        return customerAreaTreeRespDto.getCode();
    }
}

