/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.control.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.control.biz.service.IAnalysisService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.module.customer.biz.vo.CustomerExportVo;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AnalysisServiceImpl
implements IAnalysisService {
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;

    @Override
    public RestResponse<List<CustomerRespDto>> queryByExcel(MultipartFile file) {
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List customerImportVoList = null;
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), CustomerExportVo.class, (ImportParams)importParams);
            customerImportVoList = result.getList();
            if (CollectionUtils.isEmpty((Collection)customerImportVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
            List<String> collect = customerImportVoList.stream().map(c -> c.getCode()).collect(Collectors.toList());
            ArrayList CustomerRespDtoResult = new ArrayList();
            collect.forEach(c -> {
                RestResponse customerRespDtoRestResponse = this.iCustomerQueryApi.queryCustomerByCode(c);
                CustomerRespDto data = (CustomerRespDto)customerRespDtoRestResponse.getData();
                CustomerRespDtoResult.add(data);
            });
            List customerList = CustomerRespDtoResult.stream().filter(c -> !ObjectUtils.isEmpty((Object)c) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{c.getCode()})).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CustomerRespDto>(Comparator.comparing(CustomerRespDto::getCode))), ArrayList::new));
            return new RestResponse((Object)customerList);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
    }
}

