package com.dtyunxi.cube.biz.commons.dto.event;


import com.dtyunxi.cube.biz.commons.annotation.ClassDesc;
import com.dtyunxi.cube.biz.commons.annotation.PropertyDesc;
import com.dtyunxi.dto.RequestDto;

import java.util.UUID;


@ClassDesc(value = "MarketingExecReqDto", description = "营销执行参数")
public class MarketingExecReqDto extends RequestDto {

    private static final long serialVersionUID = 241410161953016027L;

    @PropertyDesc(value = "uuid,确保每个事件消息只被消费一次")
    private String uuid = UUID.randomUUID().toString().replace("-","");

    @PropertyDesc(value = "营销类型，主动营销由营销中心或者调度中心发起，无需其他开发人员对接【0:主动营销 1:事件营销】")
    private int type = 1;

    @PropertyDesc(value = "营销任务id【type=0时必传】")
    private Long marketingTaskId;

    @PropertyDesc(value = "会员id(客户)",notes = "事件营销需指定")
    private Long memberId;

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Long getMarketingTaskId() {
        return marketingTaskId;
    }

    public void setMarketingTaskId(Long marketingTaskId) {
        this.marketingTaskId = marketingTaskId;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public static void main(String[] args) {
        EventMarketingExecDto eventMarketingExecDto = new EventMarketingExecDto();
        System.out.println(eventMarketingExecDto.getUuid());
    }
}
