package com.dtyunxi.cube.biz.commons.enums;

import java.util.HashMap;
import java.util.Map;

public enum AssociateSource {

    /**
     *
     */
    APP("app", "app", "ZCM109"),
    HAOWAN("24haowan", "24好玩", "24haowan"),
    WECHAT("wechat", "微信商城", "ZCM005"),
    TMQJ("tmqj", "天猫会员通旗舰店", "ZCM006"),
    JDQJ("jdqj", "京东会员通旗舰店", "ZCM009");

    private String code;
    private String name;
    private String channelCode;

    public static Map<String, AssociateSource> codeMap = new HashMap<>();

    static {
        AssociateSource[] datas = AssociateSource.values();
        for (AssociateSource data : datas) {
            codeMap.put(data.code, data);
        }
    }

    AssociateSource(String code, String name, String channelCode) {
        this.code = code;
        this.name = name;
        this.channelCode = channelCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }
}
