package com.dtyunxi.cube.biz.commons.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 渠道标识
 * create By qiudao on 2019/7/24
 */
public enum BestoreChannelCode {

    QQ("ZCM004","QQ号"),
    OPENID("ZCM005","微信OPENID"),
    WEIBO("ZCM006","微博OPENID"),
    B2C("ZCM007","B2C商城ID"),
    TAOBAO("ZCM008","淘宝平台ID"),
    JD("ZCM009","京东平台ID"),
    ONESTORE("ZCM010","1号店平台ID"),
    PAPA("ZCM011","拍拍平台ID"),
    DANGDANG("ZCM012","当当平台ID"),
    SUNING("ZCM013","苏宁平台ID"),
    YOUZAN("ZCM014","有赞商城openid"),
    HOUYONG("ZCM038","厚勇食品专营店ID"),
    ALIPAY("ZCM101","支付宝OPENID"),
    QQOPENID("ZCM102","QQOPENID"),
    YUANGONG("ZCM103","员工号"),
    ELEME("ZCM104","饿了么外卖"),
    JDWM("ZCM105","京东外卖"),
    ZIYINGWM("ZCM106","自营外卖"),
    BDWM("ZCM107","百度外卖"),
    MTWM("ZCM108","美团外卖"),
    APP("ZCM109","手机APP"),
    WECHATUNDION("ZCM110","微信APPUnionID"),
    OTHER("ZCM999","其它证件"),
    TIANMAO("ZCM130","天猫ID"),
    WEIXIN_APPLET("ZCM131","微信小程序"),
    HAOWAN("ZCM135","H5");

    private String code;
    private String name;

    BestoreChannelCode(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String codeToName(String code) {
        if(StringUtils.isBlank(code)) {
            return null;
        }
        BestoreChannelCode[] datas = BestoreChannelCode.values();
        for(BestoreChannelCode data: datas) {
            if(code.equals(data.getCode())) {
                return data.getName();
            }
        }
        return null;
    }
}
