package com.dtyunxi.cube.biz.commons.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 注册来源
 * create By qiudao on 2019/7/24
 */
public enum BestoreRegisterSource {

    B2C("b2c", "b2c"),
    HD("hd", "hd"),
    WECHAT("wechat", "微信商城"),
    ALIPAY("alipay", "支付宝服务窗"),
    OMS("oms", "oms"),
    CRM("crm", "crm"),
    APP("app", "app"),
    KD("kd", "kd"),
    POS("pos", "pos"),
    O2O("o2o", "o2o"),
    CC("cc", "cc"),
    WM("wmxcx", "外卖小程序"),
    HABU("habu", "哈步"),
    WENJUAN("wenjuan", "问卷"),
    HY("hyxcx", "优惠券小程序"),
    TB("taobao", "手淘"),
    FS("fsxcx", "良品粉丝站"),
    MC("mcxcx", "会员卡小程序"),
    YZ("yz", "有赞会员"),
    WXZF("wxzf", "微信支付"),
    MTHY("mt", "美团会员通"),
    PCSB("pcsb", "品尝识别"),
    WXALPC("wxalpc", "wxalpc"),
    H5("h5", "H5"),
    ZFBXCX("zfbxcx", "支付宝小程序"),
    ASMDC("asmdc", "扫码点单支付宝小程序"),
    JDQJ("jdqj", "京东会员通旗舰店"),
    QT("qt", "蜻蜓扫脸"),
    WXHYK("wxhyk", "微信电子会员卡"),
    TMQJ("tmqj", "天猫会员通旗舰店"),
    WECHAT_APPLET("wechat_applet", "微信小程序"),
    YDYM("ydym", "一店一码");

    private String code;
    private String name;

    private static Map<String, BestoreRegisterSource> map = new HashMap<>();

    static {
        BestoreRegisterSource[] datas = BestoreRegisterSource.values();
        for (BestoreRegisterSource data : datas) {
            map.put(data.code, data);
        }
    }

    BestoreRegisterSource(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String codeToName(String code) {
        BestoreRegisterSource registereSource = map.get(code);
        if (registereSource == null) {
            return null;
        }
        return registereSource.getName();
    }
}
