/**
 * @(#) ErrorCodeEnum.java 1.0 2019-08-15
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.cube.biz.commons.enums;

/**
 * @author liubei
 * @since 1.0.0
 */
public enum BestoreThirdChannelOrderEnum {

    JD("JD", BestoreChannelCode.JD.getCode()),
    QJ("QJ", BestoreChannelCode.TIANMAO.getCode());

    BestoreThirdChannelOrderEnum(String orderPrefix, String channelCode) {
        this.orderPrefix = orderPrefix;
        this.channelCode = channelCode;
    }

    public static String getChannelCodeByOrderNo(String orderNo) {
        for (BestoreThirdChannelOrderEnum bestoreThirdChannelOrderEnum : BestoreThirdChannelOrderEnum.values()) {
            if (orderNo.startsWith(bestoreThirdChannelOrderEnum.getOrderPrefix())) {
                return bestoreThirdChannelOrderEnum.getChannelCode();
            }
        }
        return null;
    }

    private String orderPrefix;

    private String channelCode;


    public String getOrderPrefix() {
        return orderPrefix;
    }

    public String getChannelCode() {
        return channelCode;
    }}