/*
 * *
 *  @(#)PayTypeEnum.java 1.0 19-8-24 上午10:37
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * /
 */

package com.dtyunxi.cube.biz.commons.enums;

public enum PayTypeEnum {

    /**
     * 支付类型
     * 1 现金
     * 10 积分支付
     * 13 云闪付
     * 14 异业合作支付
     * 15 千牛支付
     * 2 银联刷卡
     * 20 银联钱包
     * 21 银联扫码
     * 3 米雅支付
     * 4 会员卡
     * 5 消费卡
     * 6 电子券
     * 8 预付卡
     */
    PAY_AMOUNT("1", "现金"),
    PAY_UNION_CARD("2", "银联刷卡"),
    PAY_MIA("3", "米雅支付"),
    PAY_MEMBER_CARD("4", "会员卡"),
    PAY_CONSUME_CARD("5", "消费卡"),
    PAY_E_COUPON("6", "电子券"),
    PAY_PREPAID_CARD("8", "预付卡"),
    PAY_POINTS("10", "积分支付"),
    PAY_CLOUD_FLASH("13", "云闪付"),
    PAY_DIF_TRADES("14", "异业合作支付"),
    PAY_CATTLE("15", "千牛支付"),
    PAY_UNION_WALLET("20", "银联钱包"),
    PAY_UNION_SCAN("21", "银联扫码");

    private final String code;
    private final String name;

    public static PayTypeEnum queryByCode(String code) {
        for (PayTypeEnum orderTypeEnum : PayTypeEnum.values()) {
            if (orderTypeEnum.getCode().equals(code)) {
                return orderTypeEnum;
            }
        }
        return null;
    }


    PayTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
