package com.dtyunxi.cube.biz.commons.utils;

import cn.afterturn.easypoi.entity.vo.NormalExcelConstants;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.view.PoiBaseView;
import com.dtyunxi.lang.BusinessRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.Collection;
import java.util.NoSuchElementException;

/***
* 文件导入处理类
*/
public class EasyPoiExportUtil {

    private static final Logger logger = LoggerFactory.getLogger(EasyPoiExportUtil.class);

    /**
     * 输出单个sheet Excel
     * @param fileName
     * @param title
     * @param sheetName
     * @param pojoClass
     * @param dataSet
     * @param request
     * @param response
     */
    public static void exportSingleSheetExcel(String fileName, String title, String sheetName, Class<?> pojoClass, Collection<?> dataSet, HttpServletRequest request, HttpServletResponse response){
        ModelMap modelMap = new ModelMap();
        ExportParams entity = new ExportParams(title,sheetName);
        modelMap.put(NormalExcelConstants.DATA_LIST,dataSet);
        modelMap.put(NormalExcelConstants.CLASS,pojoClass);
        modelMap.put(NormalExcelConstants.PARAMS,entity);
        modelMap.put(NormalExcelConstants.FILE_NAME,fileName);
        PoiBaseView.render(modelMap, request, response, NormalExcelConstants.EASYPOI_EXCEL_VIEW);
    }

    public static void exportManySheetsExcel(String fileName, Collection<?> dataSet,HttpServletRequest request, HttpServletResponse response){
        ModelMap modelMap = new ModelMap();
        modelMap.put(NormalExcelConstants.MAP_LIST,dataSet);
        modelMap.put(NormalExcelConstants.FILE_NAME,fileName);
        PoiBaseView.render(modelMap, request, response, NormalExcelConstants.EASYPOI_EXCEL_VIEW);
    }

    public static <T> ExcelImportResult<T> importExcel(InputStream inputStream, Integer titleRows, Integer headerRows, Class pojoClass){
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows);
        params.setHeadRows(headerRows);
        params.setKeyIndex(null);   //解决某一行，第一列为空，整行不导入问题
        ExcelImportResult<T> result = null;
        try {
            result = ExcelImportUtil.importExcelMore(inputStream, pojoClass, params);
        }catch (NoSuchElementException e){
            throw new BusinessRuntimeException("excel文件不能为空");
        } catch (Exception e) {
            throw new BusinessRuntimeException(e.getMessage());
        }
        return result;
    }

}
