package com.dtyunxi.cube.biz.commons.utils;

import java.util.concurrent.*;

/**
 * 线程池工具类
 * @author li.jundong
 * @date 2019/7/24
 */
public class ExecutorUtils {

	/**
	 * cpu核心数
	 * @author li.jundong
	 * @date 2019/7/29
	 * @param null
	 * @return
	 */
	private static Integer CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors();

	/**
	 * 最大线程数，如果cpu核心数>20,则取cpu核心数,否则则取20
	 * @author li.jundong
	 * @date 2019/7/29
	 * @param null
	 * @return
	 */
	private static Integer MAX_IMUM_POOL_SIZE = CORE_POOL_SIZE > 20 ? CORE_POOL_SIZE : 20;

	private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(
			CORE_POOL_SIZE, MAX_IMUM_POOL_SIZE, 10, TimeUnit.SECONDS,
			new LinkedBlockingQueue<>(1000), new ThreadPoolExecutor.CallerRunsPolicy());
	
	public static void execute(Runnable runnable){
		threadPool.execute(runnable);
	}
	
	public static <V> Future<V> submit(Callable<V> task){
		return threadPool.submit(task);
	}
}
