/*
 * *
 *  * @(#)TradeMessageVo.java 2.0.0 7/12/19 10:33 AM
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.cube.biz.commons.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author diyun
 * @since 1.0.0
 */
public class TradeMessageVo implements Serializable {

    /**
     * 交易编号
     */
    private String tradeCode;

    /**
     * 渠道
     */
    private String channel;

    /**
     * 店铺
     */
    private String shopCode;

    /**
     * 交易时间
     */
    private Date tradeTime;

    /**
     * 交易状态
     */
    private String tradeStatus;

    /**
     * 会员编号
     */
    private String memberId;

    /**
     * 下单人手机号
     */
    private String memberPhone;

    /**
     * 收货人姓名
     */
    private String receiverName;

    /**
     * 邮政编码
     */
    private String receiverPostCode;

    /**
     * 省市区
     */
    private String receiverRegional;

    /**
     * 详细地址
     */
    private String receiverAddress;

    /**
     * 收货人手机
     */
    private String receiverPhone;

    /**
     * 配送费用
     */
    private BigDecimal freight;

    /**
     * 交易总金额
     */
    private BigDecimal tradeAmount;

    /**
     * 支付总金额【RMB】
     */
    private BigDecimal payAmount;

    /**
     * 优惠总金额【RMB】
     */
    private BigDecimal discountAmount;

    /**
     * 支付信息
     */
    private List<PayInfo> payInfos;

    /**
     * 交易详情
     */
    private List<TradeItem> tradeItems;

    /**
     * 退款详情
     */
    private List<RefundInfo> refundInfos;

    public String getTradeCode() {
        return tradeCode;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public Date getTradeTime() {
        return tradeTime;
    }

    public void setTradeTime(Date tradeTime) {
        this.tradeTime = tradeTime;
    }

    public String getTradeStatus() {
        return tradeStatus;
    }

    public void setTradeStatus(String tradeStatus) {
        this.tradeStatus = tradeStatus;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getMemberPhone() {
        return memberPhone;
    }

    public void setMemberPhone(String memberPhone) {
        this.memberPhone = memberPhone;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverPostCode() {
        return receiverPostCode;
    }

    public void setReceiverPostCode(String receiverPostCode) {
        this.receiverPostCode = receiverPostCode;
    }

    public String getReceiverRegional() {
        return receiverRegional;
    }

    public void setReceiverRegional(String receiverRegional) {
        this.receiverRegional = receiverRegional;
    }

    public String getReceiverAddress() {
        return receiverAddress;
    }

    public void setReceiverAddress(String receiverAddress) {
        this.receiverAddress = receiverAddress;
    }

    public String getReceiverPhone() {
        return receiverPhone;
    }

    public void setReceiverPhone(String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    public BigDecimal getFreight() {
        return freight;
    }

    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    public BigDecimal getTradeAmount() {
        return tradeAmount;
    }

    public void setTradeAmount(BigDecimal tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public List<PayInfo> getPayInfos() {
        return payInfos;
    }

    public void setPayInfos(List<PayInfo> payInfos) {
        this.payInfos = payInfos;
    }

    public List<TradeItem> getTradeItems() {
        return tradeItems;
    }

    public void setTradeItems(List<TradeItem> tradeItems) {
        this.tradeItems = tradeItems;
    }

    public List<RefundInfo> getRefundInfos() {
        return refundInfos;
    }

    public void setRefundInfos(List<RefundInfo> refundInfos) {
        this.refundInfos = refundInfos;
    }

    public static class TradeItem implements Serializable {
        /**
         * 商品类型
         */
        private String itemType;

        /**
         * 商品名称
         */
        private String itemName;

        /**
         * 商品编码
         */
        private String itemCode;

        /**
         * 套装编码
         */
        private String CKDName;

        /**
         * 商品SKU
         */
        private String itemSku;

        /**
         * 商品数量
         */
        private String itemNum;

        /**
         * 商品单价
         */
        private BigDecimal itemPrice;

        /**
         * 商品优惠后单价
         */
        private BigDecimal itemTargetPrice;

        /**
         * 商品实付小计
         */
        private BigDecimal payAmount;


        public String getItemType() {
            return itemType;
        }

        public void setItemType(String itemType) {
            this.itemType = itemType;
        }

        public String getItemName() {
            return itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemCode() {
            return itemCode;
        }

        public void setItemCode(String itemCode) {
            this.itemCode = itemCode;
        }

        public String getCKDName() {
            return CKDName;
        }

        public void setCKDName(String CKDName) {
            this.CKDName = CKDName;
        }

        public String getItemSku() {
            return itemSku;
        }

        public void setItemSku(String itemSku) {
            this.itemSku = itemSku;
        }

        public String getItemNum() {
            return itemNum;
        }

        public void setItemNum(String itemNum) {
            this.itemNum = itemNum;
        }

        public BigDecimal getItemPrice() {
            return itemPrice;
        }

        public void setItemPrice(BigDecimal itemPrice) {
            this.itemPrice = itemPrice;
        }

        public BigDecimal getItemTargetPrice() {
            return itemTargetPrice;
        }

        public void setItemTargetPrice(BigDecimal itemTargetPrice) {
            this.itemTargetPrice = itemTargetPrice;
        }

        public BigDecimal getPayAmount() {
            return payAmount;
        }

        public void setPayAmount(BigDecimal payAmount) {
            this.payAmount = payAmount;
        }
    }


    public static class PayInfo implements Serializable {
        /**
         * 支付类型
         */
        private String type;

        /**
         * 支付金额
         */
        private String amount;

        /**
         * 支付时间
         */
        private String time;

        /**
         * 优惠金额
         */
        private String discountAmount;

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAmount() {
            return amount;
        }

        public void setAmount(String amount) {
            this.amount = amount;
        }

        public String getTime() {
            return time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public String getDiscountAmount() {
            return discountAmount;
        }

        public void setDiscountAmount(String discountAmount) {
            this.discountAmount = discountAmount;
        }
    }

    public static class RefundInfo implements Serializable {

        /**
         * 退款编号
         */
        private String rufundNo;

        /**
         * 退款详情
         */
        private List<TradeItem> rufundItems;

        public String getRufundNo() {
            return rufundNo;
        }

        public void setRufundNo(String rufundNo) {
            this.rufundNo = rufundNo;
        }

        public List<TradeItem> getRufundItems() {
            return rufundItems;
        }

        public void setRufundItems(List<TradeItem> rufundItems) {
            this.rufundItems = rufundItems;
        }
    }
}
