/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.api.credit.utils;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreditNoUtil {
    private static final String CREDIT_NO = "CREDITNO";
    private static final Integer STR_FORMAT_10 = 9;
    private static final Integer STR_FORMAT_100 = 100;
    private static final Integer STR_FORMAT_1000 = 1000;
    private static final Integer STR_FORMAT_10000 = 10000;
    private static int maxPerMSECSize = 999;
    private static CreditNoUtil tradeUtil;
    @Autowired
    ICacheService cacheService;

    public static String generateTradeNo(String rootTradeNo) {
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        String timeStr = String.valueOf(nowLong);
        String timeMsecStr = timeStr.substring(0, 8);
        Long result = CreditNoUtil.tradeUtil.cacheService.incr(rootTradeNo);
        Long mod = result % (long)maxPerMSECSize;
        String resultNo = "" + mod;
        if (mod < (long)STR_FORMAT_10.intValue()) {
            resultNo = "000" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            resultNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_100.intValue() && mod < (long)STR_FORMAT_1000.intValue()) {
            resultNo = "0" + mod;
        }
        rootTradeNo = rootTradeNo.substring(rootTradeNo.length() - 4);
        String tradeNo = rootTradeNo + timeMsecStr + resultNo;
        System.out.println(tradeNo);
        return tradeNo;
    }

    public static String generateTradeNo() {
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        String timeStr = String.valueOf(nowLong);
        String timeSecondStr = timeStr.substring(0, 14);
        String timeMsecStr = timeStr.substring(14, 17);
        Long result = CreditNoUtil.tradeUtil.cacheService.incr(CREDIT_NO);
        Long mod = result % (long)maxPerMSECSize;
        String resultNo = "" + mod;
        String romNo = "";
        if (mod < (long)STR_FORMAT_10.intValue()) {
            resultNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            resultNo = "0" + mod;
        }
        int romNum = RandomUtils.nextInt((int)1, (int)9999);
        romNo = romNum + "";
        if (mod < (long)STR_FORMAT_10.intValue()) {
            romNo = "000" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            romNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_100.intValue() && mod < (long)STR_FORMAT_1000.intValue()) {
            romNo = "0" + mod;
        }
        String tradeNo = timeSecondStr + "0" + timeMsecStr + resultNo + romNo;
        return tradeNo;
    }

    @PostConstruct
    public void init() {
        tradeUtil = this;
        CreditNoUtil.tradeUtil.cacheService = this.cacheService;
    }
}

