/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditDimPropReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditDimValueReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditDimValueSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditDimValueInfoRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditDimValueRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.ConfigType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.GeneralRuleCodeType;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditDimValueService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.GenerateCode;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditDimDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditDimValueDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditOrderBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.RefCreditDimPropDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditDimEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditDimValueEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.RefCreditDimPropEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="creditDimValue")
public class CreditDimValueServiceImpl
implements ICreditDimValueService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private CreditDimDas creditDimDas;
    @Resource
    private CreditDimValueDas creditDimValueDas;
    @Resource
    private CreditOrderBillDas creditOrderBillDas;
    @Resource
    private RefCreditDimPropDas refCreditDimPropDas;
    @Resource
    private CreditAccountDas creditAccountDas;
    @Autowired
    private IContext iContext;
    @Resource
    private GenerateCode generateCode;
    @Resource
    private ICreditAccountService creditAccountService;

    @Transactional(rollbackFor={Exception.class})
    public Long add(CreditDimValueReqDto dto) {
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        CreditDimEo creditDimEo = new CreditDimEo();
        creditDimEo.setDimName(dto.getDimName());
        List dimEoList = this.creditDimDas.select((BaseEo)creditDimEo);
        if (CollectionUtils.isEmpty((Collection)dimEoList)) {
            throw new BizException("\u6388\u4fe1\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        Boolean aBoolean = this.creditDimValueDas.queryByName(dto.getId(), dto.getValueDesc(), ((CreditDimEo)dimEoList.get(0)).getDimCode());
        if (!aBoolean.booleanValue()) {
            throw new BizException(((CreditDimEo)dimEoList.get(0)).getDimName() + "\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        CreditDimValueEo creditDimValueEo = new CreditDimValueEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)creditDimValueEo);
        creditDimValueEo.setDimCode(((CreditDimEo)dimEoList.get(0)).getDimCode());
        if (null == creditDimValueEo.getId()) {
            String code = StringUtils.isNotEmpty((CharSequence)dto.getValue()) ? dto.getValue() : this.generateCode.createCode(GeneralRuleCodeType.getDesc((String)dto.getDimName()));
            creditDimValueEo.setValue(code);
            creditDimValueEo.setOrgInfoId(orgId);
            this.creditDimValueDas.insert((BaseEo)creditDimValueEo);
        } else {
            this.creditDimValueDas.updateSelective((BaseEo)creditDimValueEo);
        }
        List refCreditDimPropEoList = dto.getCreditDimPropReqDtoList().stream().map(obj -> {
            RefCreditDimPropEo refCreditDimPropEo = new RefCreditDimPropEo();
            DtoHelper.dto2Eo((BaseVo)obj, (BaseEo)refCreditDimPropEo);
            refCreditDimPropEo.setDimValueId(creditDimValueEo.getId());
            refCreditDimPropEo.setOrgInfoId(orgId);
            return refCreditDimPropEo;
        }).collect(Collectors.toList());
        this.refCreditDimPropDas.insertBatch(refCreditDimPropEoList);
        return creditDimValueEo.getId();
    }

    public void enable(Long id) {
    }

    public void disable(Long id) {
    }

    public void delete(Long id) {
        CreditDimValueEo creditDimValueEo = (CreditDimValueEo)this.creditDimValueDas.selectByPrimaryKey(id);
        if (null == creditDimValueEo) {
            throw new BizException("\u6388\u4fe1\u7ef4\u5ea6\u503c\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25");
        }
        List creditDimEoList = this.creditDimDas.selectByCode(creditDimValueEo.getDimCode());
        String name = CollectionUtils.isEmpty((Collection)creditDimEoList) ? ConfigType.DIM2.getDesc() : ((CreditDimEo)creditDimEoList.get(0)).getDimName();
        ConfigType type = ConfigType.getDesc((String)name) == null ? ConfigType.DIM2 : ConfigType.getDesc((String)name);
        Map accountNumMap = this.creditAccountDas.queryConfigAccountNum(Collections.singletonList(id), type);
        if (!accountNumMap.isEmpty()) {
            throw new BizException("\u6388\u4fe1\u7ef4\u5ea6\u503c\u5df2\u88ab\u4fe1\u7528\u8d26\u6237\u7ed1\u5b9a\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.creditDimValueDas.logicDeleteById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void edit(Long id, CreditDimValueReqDto dto) {
        ConfigType configType;
        List dimEoList;
        this.saveBak(id);
        CreditDimValueEo creditDimValueEo = (CreditDimValueEo)this.creditDimValueDas.selectByPrimaryKey(id);
        if (null == creditDimValueEo) {
            throw new BizException("\u6388\u4fe1\u7ef4\u5ea6\u503c\u4e0d\u5b58\u5728\uff0c\u7f16\u8f91\u5931\u8d25");
        }
        RefCreditDimPropEo creditDimPropEo = new RefCreditDimPropEo();
        creditDimPropEo.setDimValueId(id);
        this.refCreditDimPropDas.logicDelete((BaseEo)creditDimPropEo);
        dto.setId(creditDimValueEo.getId());
        dto.setValue(creditDimValueEo.getValue());
        this.add(dto);
        if (!dto.getValueDesc().equals(creditDimValueEo.getValueDesc()) && CollectionUtils.isNotEmpty((Collection)(dimEoList = this.creditDimDas.selectByCode(creditDimValueEo.getDimCode()))) && null != (configType = ConfigType.getDesc((String)((CreditDimEo)dimEoList.get(0)).getDimName()))) {
            this.creditAccountDas.updateAccountDimValue(configType.getCode(), dto.getValueDesc(), id);
        }
    }

    private void saveBak(Long id) {
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        if (id != null) {
            CreditDimValueEo newDim = (CreditDimValueEo)this.creditDimValueDas.selectByPrimaryKey(id);
            newDim.setId(null);
            newDim.setIsBackup(Integer.valueOf(1));
            newDim.setSourceId(id);
            this.creditDimValueDas.insert((BaseEo)newDim);
            RefCreditDimPropEo creditDimPropEo1 = new RefCreditDimPropEo();
            creditDimPropEo1.setDimValueId(id);
            List refCreditDimPropEos = this.refCreditDimPropDas.selectList((BaseEo)creditDimPropEo1);
            for (RefCreditDimPropEo refCreditDimPropEo : refCreditDimPropEos) {
                refCreditDimPropEo.setId(null);
                refCreditDimPropEo.setDimValueId(newDim.getId());
                refCreditDimPropEo.setOrgInfoId(orgId);
            }
            this.refCreditDimPropDas.insertBatch(refCreditDimPropEos);
            this.creditOrderBillDas.updatePointValue("dim2_id", newDim.getId(), id);
        }
    }

    public PageInfo<CreditDimValueRespDto> queryPage(CreditDimValueSearchReqDto searchReqDto) {
        CreditDimValueEo creditDimValueEo = new CreditDimValueEo();
        List creditDimEoList = this.creditDimDas.selectByName(searchReqDto.getDimName());
        if (CollectionUtils.isNotEmpty((Collection)creditDimEoList)) {
            creditDimValueEo.setDimCode(((CreditDimEo)creditDimEoList.get(0)).getDimCode());
        }
        creditDimValueEo.setValue(searchReqDto.getValue());
        if (StringUtils.isNotBlank((CharSequence)searchReqDto.getValueDesc())) {
            creditDimValueEo.setSqlFilters(Arrays.asList(SqlFilter.isNull((String)"is_backup"), SqlFilter.like((String)"value_desc", (Object)("%" + searchReqDto.getValueDesc() + "%"))));
        } else {
            creditDimValueEo.setSqlFilters(Collections.singletonList(SqlFilter.isNull((String)"is_backup")));
        }
        creditDimValueEo.setOrderByDesc("create_time");
        PageHelper.startPage((int)searchReqDto.getPageNum(), (int)searchReqDto.getPageSize());
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        creditDimValueEo.setOrgInfoId(orgId);
        PageInfo select = new PageInfo(this.creditDimValueDas.select((BaseEo)creditDimValueEo));
        PageInfo pageInfo = new PageInfo();
        this.joinList(searchReqDto, (PageInfo<CreditDimValueEo>)select, (PageInfo<CreditDimValueRespDto>)pageInfo);
        return pageInfo;
    }

    private void joinList(CreditDimValueSearchReqDto searchReqDto, PageInfo<CreditDimValueEo> select, PageInfo<CreditDimValueRespDto> pageInfo) {
        if (CollectionUtils.isNotEmpty((Collection)select.getList())) {
            ArrayList list = Lists.newArrayList();
            BeanUtils.copyProperties(select, pageInfo, (String[])new String[]{"list"});
            CubeBeanUtils.copyCollection((Collection)list, (Collection)select.getList(), CreditDimValueRespDto.class);
            List ids = select.getList().stream().map(BaseEo::getId).collect(Collectors.toList());
            Map dimPropNumMap = this.refCreditDimPropDas.queryDimPropNum(ids);
            ConfigType type = ConfigType.getDesc((String)searchReqDto.getDimName()) == null ? ConfigType.DIM2 : ConfigType.getDesc((String)searchReqDto.getDimName());
            Map accountNumMap = this.creditAccountDas.queryConfigAccountNum(ids, type);
            for (CreditDimValueRespDto creditDimValueRespDto : list) {
                if (dimPropNumMap.containsKey(creditDimValueRespDto.getId())) {
                    creditDimValueRespDto.setDimNum((Integer)dimPropNumMap.get(creditDimValueRespDto.getId()));
                }
                if (!accountNumMap.containsKey(creditDimValueRespDto.getId())) continue;
                creditDimValueRespDto.setAccountNum((Integer)accountNumMap.get(creditDimValueRespDto.getId()));
            }
            pageInfo.setList((List)list);
        }
    }

    public CreditDimValueInfoRespDto getDetail(Long id) {
        CreditDimValueEo creditDimValueEo = (CreditDimValueEo)this.creditDimValueDas.selectByPrimaryKey(id);
        if (null == creditDimValueEo) {
            throw new BizException("\u6388\u4fe1\u7ef4\u5ea6\u503c\u4e0d\u5b58\u5728");
        }
        CreditDimValueInfoRespDto dimValueInfoRespDto = new CreditDimValueInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)creditDimValueEo, (BaseVo)dimValueInfoRespDto);
        RefCreditDimPropEo creditDimPropEo = new RefCreditDimPropEo();
        creditDimPropEo.setDimValueId(id);
        List dimPropEoList = this.refCreditDimPropDas.select((BaseEo)creditDimPropEo);
        if (CollectionUtils.isEmpty((Collection)dimPropEoList)) {
            throw new BizException("\u6388\u4fe1\u7ef4\u5ea6\u503c\u7684\u5c5e\u6027\u4e0d\u5b58\u5728");
        }
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)dimPropEoList, CreditDimPropReqDto.class);
        dimValueInfoRespDto.setCreditDimPropReqDtoList((List)list);
        return dimValueInfoRespDto;
    }
}

